/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.function.Parameter;
import org.partiql.spi.function.RoutineSignature;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

public abstract class Fn {
    @NotNull
    public abstract RoutineSignature getSignature();

    @NotNull
    public abstract Datum invoke(Datum[] var1);

    private static class FnImpl
    extends Fn {
        @NotNull
        private final RoutineSignature signature;
        @NotNull
        private final Function<Datum[], Datum> implementation;

        public FnImpl(@NotNull String name, @NotNull PType returns, @NotNull List<Parameter> parameters, @NotNull Function<Datum[], Datum> invocation, boolean isNullCall, boolean isMissingCall) {
            this.signature = new RoutineSignature(name, parameters, returns, isNullCall, isMissingCall);
            this.implementation = invocation;
        }

        @Override
        @NotNull
        public RoutineSignature getSignature() {
            return this.signature;
        }

        @Override
        @NotNull
        public Datum invoke(Datum[] args) {
            return this.implementation.apply(args);
        }
    }

    public static final class Builder {
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private final String name;
        private PType returns = PType.dynamic();
        private Function<Datum[], Datum> invocation;
        private boolean isNullCall = true;
        private boolean isMissingCall = true;

        public Builder(@NotNull String name) {
            this.name = name;
        }

        @NotNull
        public Builder addParameter(@NotNull Parameter param) {
            this.parameters.add(param);
            return this;
        }

        @NotNull
        public Builder addParameters(Parameter ... parameters) {
            this.parameters.addAll(Arrays.asList(parameters));
            return this;
        }

        @NotNull
        public Builder addParameters(@NotNull List<Parameter> parameters) {
            this.parameters.addAll(parameters);
            return this;
        }

        @NotNull
        public Builder addParameters(PType ... types) {
            for (PType type : types) {
                this.addParameter(type);
            }
            return this;
        }

        @NotNull
        public Builder addParameter(@NotNull PType type) {
            Parameter param = new Parameter("arg" + this.parameters.size(), type);
            return this.addParameter(param);
        }

        @NotNull
        public Builder isNullCall(boolean value) {
            this.isNullCall = value;
            return this;
        }

        @NotNull
        public Builder isMissingCall(boolean value) {
            this.isMissingCall = value;
            return this;
        }

        @NotNull
        public Builder returns(@NotNull PType returns) {
            this.returns = returns;
            return this;
        }

        @NotNull
        public Builder body(@NotNull Function<Datum[], Datum> impl) {
            this.invocation = impl;
            return this;
        }

        @NotNull
        public Fn build() {
            return new FnImpl(this.name, this.returns, this.parameters, this.invocation, this.isNullCall, this.isMissingCall);
        }
    }
}

