/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.Fn;
import org.partiql.spi.function.Parameter;
import org.partiql.spi.function.RoutineOverloadSignature;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

public abstract class FnOverload {
    @NotNull
    public abstract RoutineOverloadSignature getSignature();

    @Nullable
    public abstract Fn getInstance(PType[] var1);

    private static class FnOverloadImpl
    extends FnOverload {
        @NotNull
        private final RoutineOverloadSignature signature;
        @NotNull
        private final Fn instance;

        public FnOverloadImpl(@NotNull RoutineOverloadSignature signature, @NotNull Fn instance) {
            this.signature = signature;
            this.instance = instance;
        }

        @Override
        @NotNull
        public RoutineOverloadSignature getSignature() {
            return this.signature;
        }

        @Override
        @Nullable
        public Fn getInstance(PType[] args) {
            return this.instance;
        }
    }

    public static final class Builder {
        @NotNull
        private final String name;
        private final List<Parameter> parameters = new ArrayList<Parameter>();
        private PType returns = PType.dynamic();
        private Function<Datum[], Datum> invocation;
        private boolean isNullCall = true;
        private boolean isMissingCall = true;

        public Builder(@NotNull String name) {
            this.name = name;
        }

        @NotNull
        public Builder addParameter(@NotNull Parameter param) {
            this.parameters.add(param);
            return this;
        }

        @NotNull
        public Builder addParameters(Parameter ... parameters) {
            this.parameters.addAll(Arrays.asList(parameters));
            return this;
        }

        @NotNull
        public Builder addParameters(@NotNull List<Parameter> parameters) {
            this.parameters.addAll(parameters);
            return this;
        }

        @NotNull
        public Builder addParameters(PType ... types) {
            for (PType type : types) {
                this.addParameter(type);
            }
            return this;
        }

        @NotNull
        public Builder addParameter(@NotNull PType type) {
            Parameter param = new Parameter("arg" + this.parameters.size(), type);
            this.parameters.add(param);
            return this;
        }

        @NotNull
        public Builder isNullCall(boolean value) {
            this.isNullCall = value;
            return this;
        }

        @NotNull
        public Builder isMissingCall(boolean value) {
            this.isMissingCall = value;
            return this;
        }

        @NotNull
        public Builder returns(@NotNull PType returns) {
            this.returns = returns;
            return this;
        }

        @NotNull
        public Builder body(@NotNull Function<Datum[], Datum> impl) {
            this.invocation = impl;
            return this;
        }

        @NotNull
        public FnOverload build() {
            List<PType> paramTypes = this.parameters.stream().map(Parameter::getType).collect(Collectors.toList());
            RoutineOverloadSignature pSignature = new RoutineOverloadSignature(this.name, paramTypes);
            Fn instance = new Fn.Builder(this.name).returns(this.returns).addParameters(this.parameters).body(this.invocation).isNullCall(this.isNullCall).isMissingCall(this.isMissingCall).build();
            return new FnOverloadImpl(pSignature, instance);
        }
    }
}

