/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function.builtins;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.Fn;
import org.partiql.spi.function.builtins.DiadicOperator;
import org.partiql.spi.internal.SqlTypeFamily;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u001d\u0010\n\u001a\u0004\u0018\u00010\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H&J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/partiql/spi/function/builtins/DiadicComparisonOperator;", "Lorg/partiql/spi/function/builtins/DiadicOperator;", "name", "", "(Ljava/lang/String;)V", "getDecimalInstance", "Lorg/partiql/spi/function/Fn;", "decimalLhs", "Lorg/partiql/spi/types/PType;", "decimalRhs", "getInstance", "args", "", "([Lorg/partiql/spi/types/PType;)Lorg/partiql/spi/function/Fn;", "getNumberComparison", "", "lhs", "", "rhs", "getNumberInstance", "getNumber", "Lorg/partiql/spi/value/Datum;", "partiql-spi"})
public abstract class DiadicComparisonOperator
extends DiadicOperator {
    public DiadicComparisonOperator(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PType pType = PType.dynamic();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
        PType pType2 = PType.dynamic();
        Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"dynamic(...)");
        super(name, pType, pType2, false, 8, null);
    }

    @Override
    @Nullable
    public Fn getDecimalInstance(@NotNull PType decimalLhs, @NotNull PType decimalRhs) {
        Intrinsics.checkNotNullParameter((Object)decimalLhs, (String)"decimalLhs");
        Intrinsics.checkNotNullParameter((Object)decimalRhs, (String)"decimalRhs");
        return null;
    }

    @Override
    @Nullable
    public Fn getInstance(@NotNull PType[] args) {
        boolean allNumbers;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        PType lhs = args[0];
        PType rhs = args[1];
        boolean hasDecimal = lhs.code() == 7 || rhs.code() == 7;
        boolean bl = allNumbers = SqlTypeFamily.Companion.getNUMBER().contains(lhs) && SqlTypeFamily.Companion.getNUMBER().contains(rhs);
        if (hasDecimal && allNumbers) {
            return this.getNumberInstance(lhs, rhs);
        }
        return super.getInstance(args);
    }

    private final Fn getNumberInstance(PType lhs, PType rhs) {
        PType pType = PType.bool();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"bool(...)");
        return this.basic(pType, lhs, rhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>(this){
            final /* synthetic */ DiadicComparisonOperator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                Number l = DiadicComparisonOperator.access$getNumber(this.this$0, args[0]);
                Number r = DiadicComparisonOperator.access$getNumber(this.this$0, args[1]);
                Datum datum = Datum.bool(this.this$0.getNumberComparison(l, r));
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bool(...)");
                return datum;
            }
        }));
    }

    public abstract boolean getNumberComparison(@NotNull Number var1, @NotNull Number var2);

    private final Number getNumber(Datum $this$getNumber) {
        Number number;
        switch ($this$getNumber.getType().code()) {
            case 2: {
                number = $this$getNumber.getByte();
                break;
            }
            case 4: {
                number = $this$getNumber.getInt();
                break;
            }
            case 3: {
                number = $this$getNumber.getShort();
                break;
            }
            case 5: {
                number = $this$getNumber.getLong();
                break;
            }
            case 8: {
                number = Float.valueOf($this$getNumber.getFloat());
                break;
            }
            case 9: {
                number = $this$getNumber.getDouble();
                break;
            }
            case 7: {
                BigDecimal bigDecimal = $this$getNumber.getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                number = bigDecimal;
                break;
            }
            case 6: {
                BigDecimal bigDecimal = $this$getNumber.getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                number = bigDecimal;
                break;
            }
            default: {
                throw new IllegalStateException(("Unexpected type: " + $this$getNumber.getType()).toString());
            }
        }
        return number;
    }

    public static final /* synthetic */ Number access$getNumber(DiadicComparisonOperator $this, Datum $receiver) {
        return $this.getNumber($receiver);
    }
}

