/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function.builtins;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.Fn;
import org.partiql.spi.function.Function;
import org.partiql.spi.function.Parameter;
import org.partiql.spi.function.builtins.DiadicArithmeticOperator;
import org.partiql.spi.function.builtins.FnMinus;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J$\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u0018\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020\tH\u0016J\u001a\u0010/\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0018\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tH\u0016J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\"2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J(\u00104\u001a\u0002052\u0006\u0010\u000f\u001a\u0002052\u0006\u0010\u0010\u001a\u0002052\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0002J \u00108\u001a\u0002052\u0006\u0010\u000f\u001a\u0002052\u0006\u0010\u0010\u001a\u0002052\u0006\u00106\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/partiql/spi/function/builtins/FnMinus;", "Lorg/partiql/spi/function/builtins/DiadicArithmeticOperator;", "()V", "INTERVAL_MAX_PRECISION", "", "INTERVAL_MAX_SCALE", "getBigIntInstance", "Lorg/partiql/spi/function/Fn;", "bigIntLhs", "Lorg/partiql/spi/types/PType;", "bigIntRhs", "getDateInstance", "dateLhs", "dateRhs", "getDateIntervalInstance", "lhs", "rhs", "getDecimalInstance", "decimalLhs", "decimalRhs", "getDoubleInstance", "doubleLhs", "doubleRhs", "getIntegerInstance", "integerLhs", "integerRhs", "getIntervalInstance", "getNumericInstance", "numericLhs", "numericRhs", "getRealInstance", "realLhs", "realRhs", "getRemainder", "Lkotlin/Pair;", "value", "divisor", "getSmallIntInstance", "smallIntLhs", "smallIntRhs", "getTimeInstance", "timeLhs", "timeRhs", "getTimeIntervalInstance", "getTimestampInstance", "timestampLhs", "timestampRhs", "getTimestampIntervalInstance", "getTinyIntInstance", "tinyIntLhs", "tinyIntRhs", "minusPrecisionScale", "subtractIntervalDayTimes", "Lorg/partiql/spi/value/Datum;", "precision", "scale", "subtractIntervalYearMonths", "partiql-spi"})
public final class FnMinus
extends DiadicArithmeticOperator {
    @NotNull
    public static final FnMinus INSTANCE = new FnMinus();
    private static final int INTERVAL_MAX_PRECISION = 9;
    private static final int INTERVAL_MAX_SCALE = 9;

    private FnMinus() {
        super("minus", false, 2, null);
    }

    @Override
    @NotNull
    public Fn getTinyIntInstance(@NotNull PType tinyIntLhs, @NotNull PType tinyIntRhs) {
        Intrinsics.checkNotNullParameter((Object)tinyIntLhs, (String)"tinyIntLhs");
        Intrinsics.checkNotNullParameter((Object)tinyIntRhs, (String)"tinyIntRhs");
        PType pType = PType.tinyint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"tinyint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getTinyIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getSmallIntInstance(@NotNull PType smallIntLhs, @NotNull PType smallIntRhs) {
        Intrinsics.checkNotNullParameter((Object)smallIntLhs, (String)"smallIntLhs");
        Intrinsics.checkNotNullParameter((Object)smallIntRhs, (String)"smallIntRhs");
        PType pType = PType.smallint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"smallint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getSmallIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getIntegerInstance(@NotNull PType integerLhs, @NotNull PType integerRhs) {
        Intrinsics.checkNotNullParameter((Object)integerLhs, (String)"integerLhs");
        Intrinsics.checkNotNullParameter((Object)integerRhs, (String)"integerRhs");
        PType pType = PType.integer();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"integer(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getIntegerInstance.1.INSTANCE));
    }

    @Override
    @Nullable
    public Fn getIntervalInstance(@NotNull PType lhs, @NotNull PType rhs) {
        Fn fn;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        if (lhs.code() == 27 && rhs.code() == 27) {
            int p = lhs.getPrecision();
            int s = 6;
            PType pType = PType.intervalDaySecond(p, s);
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"intervalDaySecond(...)");
            fn = this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>(p, s){
                final /* synthetic */ int $p;
                final /* synthetic */ int $s;
                {
                    this.$p = $p;
                    this.$s = $s;
                    super(1);
                }

                @NotNull
                public final Datum invoke(@NotNull Datum[] args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Datum interval0 = args[0];
                    Datum interval1 = args[1];
                    return FnMinus.access$subtractIntervalDayTimes(FnMinus.INSTANCE, interval0, interval1, this.$p, this.$s);
                }
            }));
        } else if (lhs.code() == 26 && rhs.code() == 26) {
            int p = lhs.getPrecision();
            PType pType = PType.intervalYearMonth(p);
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"intervalYearMonth(...)");
            fn = this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>(p){
                final /* synthetic */ int $p;
                {
                    this.$p = $p;
                    super(1);
                }

                @NotNull
                public final Datum invoke(@NotNull Datum[] args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    Datum interval0 = args[0];
                    Datum interval1 = args[1];
                    return FnMinus.access$subtractIntervalYearMonths(FnMinus.INSTANCE, interval0, interval1, this.$p);
                }
            }));
        } else {
            fn = null;
        }
        return fn;
    }

    private final Datum subtractIntervalYearMonths(Datum lhs, Datum rhs, int precision) {
        Pair<Integer, Integer> pair = this.getRemainder(lhs.getMonths() - rhs.getMonths(), 12);
        int months = ((Number)pair.component1()).intValue();
        int yearsRemainder = ((Number)pair.component2()).intValue();
        int years = lhs.getYears() - rhs.getYears() - yearsRemainder;
        Datum datum = Datum.intervalYearMonth(years, months, precision);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalYearMonth(...)");
        return datum;
    }

    private final Datum subtractIntervalDayTimes(Datum lhs, Datum rhs, int precision, int scale) {
        Pair<Integer, Integer> pair = this.getRemainder(lhs.getNanos() - rhs.getNanos(), 1000000000);
        int nanos = ((Number)pair.component1()).intValue();
        int secondsRemainder = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = this.getRemainder(lhs.getSeconds() - rhs.getSeconds() - secondsRemainder, 60);
        int seconds = ((Number)pair2.component1()).intValue();
        int minutesRemainder = ((Number)pair2.component2()).intValue();
        Pair<Integer, Integer> pair3 = this.getRemainder(lhs.getMinutes() - rhs.getMinutes() - minutesRemainder, 60);
        int minutes = ((Number)pair3.component1()).intValue();
        int hoursRemainder = ((Number)pair3.component2()).intValue();
        Pair<Integer, Integer> pair4 = this.getRemainder(lhs.getHours() - rhs.getHours() - hoursRemainder, 12);
        int hours = ((Number)pair4.component1()).intValue();
        int daysRemainder = ((Number)pair4.component2()).intValue();
        int days = lhs.getDays() - rhs.getDays() - daysRemainder;
        Datum datum = Datum.intervalDaySecond(days, hours, minutes, seconds, nanos, precision, scale);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"intervalDaySecond(...)");
        return datum;
    }

    private final Pair<Integer, Integer> getRemainder(int value, int divisor) {
        int remainder = value % divisor;
        int quotient = value / divisor;
        return TuplesKt.to((Object)remainder, (Object)quotient);
    }

    @Override
    @NotNull
    public Fn getBigIntInstance(@NotNull PType bigIntLhs, @NotNull PType bigIntRhs) {
        Intrinsics.checkNotNullParameter((Object)bigIntLhs, (String)"bigIntLhs");
        Intrinsics.checkNotNullParameter((Object)bigIntRhs, (String)"bigIntRhs");
        PType pType = PType.bigint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"bigint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getBigIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getNumericInstance(@NotNull PType numericLhs, @NotNull PType numericRhs) {
        Intrinsics.checkNotNullParameter((Object)numericLhs, (String)"numericLhs");
        Intrinsics.checkNotNullParameter((Object)numericRhs, (String)"numericRhs");
        Pair<Integer, Integer> pair = this.minusPrecisionScale(numericLhs, numericRhs);
        int p = ((Number)pair.component1()).intValue();
        int s = ((Number)pair.component2()).intValue();
        String string = this.getSignature().getName();
        PType pType = PType.numeric(p, s);
        Parameter[] parameterArray = new Parameter[]{new Parameter("lhs", numericLhs), new Parameter("rhs", numericRhs)};
        Parameter[] parameterArray2 = parameterArray;
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)pType);
        return Function.instance$default(string, parameterArray2, pType, false, false, (Function1)new Function1<Datum[], Datum>(p, s){
            final /* synthetic */ int $p;
            final /* synthetic */ int $s;
            {
                this.$p = $p;
                this.$s = $s;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                BigDecimal bigDecimal = args[0].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                BigDecimal arg0 = bigDecimal;
                BigDecimal bigDecimal2 = args[1].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getBigDecimal(...)");
                BigDecimal arg1 = bigDecimal2;
                BigDecimal bigDecimal3 = arg0.subtract(arg1);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"subtract(...)");
                Datum datum = Datum.numeric(bigDecimal3, this.$p, this.$s);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"numeric(...)");
                return datum;
            }
        }, 24, null);
    }

    @Override
    @NotNull
    public Fn getDecimalInstance(@NotNull PType decimalLhs, @NotNull PType decimalRhs) {
        Intrinsics.checkNotNullParameter((Object)decimalLhs, (String)"decimalLhs");
        Intrinsics.checkNotNullParameter((Object)decimalRhs, (String)"decimalRhs");
        Pair<Integer, Integer> pair = this.minusPrecisionScale(decimalLhs, decimalRhs);
        int p = ((Number)pair.component1()).intValue();
        int s = ((Number)pair.component2()).intValue();
        String string = this.getSignature().getName();
        PType pType = PType.decimal(p, s);
        Parameter[] parameterArray = new Parameter[]{new Parameter("lhs", decimalLhs), new Parameter("rhs", decimalRhs)};
        Parameter[] parameterArray2 = parameterArray;
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)pType);
        return Function.instance$default(string, parameterArray2, pType, false, false, (Function1)new Function1<Datum[], Datum>(p, s){
            final /* synthetic */ int $p;
            final /* synthetic */ int $s;
            {
                this.$p = $p;
                this.$s = $s;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                BigDecimal bigDecimal = args[0].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                BigDecimal arg0 = bigDecimal;
                BigDecimal bigDecimal2 = args[1].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getBigDecimal(...)");
                BigDecimal arg1 = bigDecimal2;
                BigDecimal bigDecimal3 = arg0.subtract(arg1);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"subtract(...)");
                Datum datum = Datum.decimal(bigDecimal3, this.$p, this.$s);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"decimal(...)");
                return datum;
            }
        }, 24, null);
    }

    private final Pair<Integer, Integer> minusPrecisionScale(PType lhs, PType rhs) {
        Pair pair = TuplesKt.to((Object)lhs.getPrecision(), (Object)lhs.getScale());
        int p1 = ((Number)pair.component1()).intValue();
        int s1 = ((Number)pair.component2()).intValue();
        Pair pair2 = TuplesKt.to((Object)rhs.getPrecision(), (Object)rhs.getScale());
        int p2 = ((Number)pair2.component1()).intValue();
        int s2 = ((Number)pair2.component2()).intValue();
        int p = RangesKt.coerceAtLeast((int)s1, (int)s2) + RangesKt.coerceAtLeast((int)(p1 - s1), (int)(p2 - s2)) + 1;
        int s = RangesKt.coerceAtLeast((int)s1, (int)s2);
        int returnedP = RangesKt.coerceAtMost((int)p, (int)38);
        int returnedS = RangesKt.coerceAtMost((int)s, (int)p);
        return TuplesKt.to((Object)returnedP, (Object)returnedS);
    }

    @Override
    @NotNull
    public Fn getRealInstance(@NotNull PType realLhs, @NotNull PType realRhs) {
        Intrinsics.checkNotNullParameter((Object)realLhs, (String)"realLhs");
        Intrinsics.checkNotNullParameter((Object)realRhs, (String)"realRhs");
        PType pType = PType.real();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"real(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getRealInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getDoubleInstance(@NotNull PType doubleLhs, @NotNull PType doubleRhs) {
        Intrinsics.checkNotNullParameter((Object)doubleLhs, (String)"doubleLhs");
        Intrinsics.checkNotNullParameter((Object)doubleRhs, (String)"doubleRhs");
        PType pType = PType.doublePrecision();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"doublePrecision(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getDoubleInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getDateInstance(@NotNull PType dateLhs, @NotNull PType dateRhs) {
        Intrinsics.checkNotNullParameter((Object)dateLhs, (String)"dateLhs");
        Intrinsics.checkNotNullParameter((Object)dateRhs, (String)"dateRhs");
        PType pType = PType.intervalDay(9);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"intervalDay(...)");
        return this.basic(pType, dateLhs, dateRhs, (Function1<? super Datum[], ? extends Datum>)((Function1)getDateInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getTimeInstance(@NotNull PType timeLhs, @NotNull PType timeRhs) {
        Intrinsics.checkNotNullParameter((Object)timeLhs, (String)"timeLhs");
        Intrinsics.checkNotNullParameter((Object)timeRhs, (String)"timeRhs");
        PType pType = PType.intervalSecond(9, 9);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"intervalSecond(...)");
        return this.basic(pType, timeLhs, timeRhs, (Function1<? super Datum[], ? extends Datum>)((Function1)getTimeInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getTimestampInstance(@NotNull PType timestampLhs, @NotNull PType timestampRhs) {
        Intrinsics.checkNotNullParameter((Object)timestampLhs, (String)"timestampLhs");
        Intrinsics.checkNotNullParameter((Object)timestampRhs, (String)"timestampRhs");
        PType pType = PType.intervalDaySecond(9, 9);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"intervalDaySecond(...)");
        return this.basic(pType, timestampLhs, timestampRhs, (Function1<? super Datum[], ? extends Datum>)((Function1)getTimestampInstance.1.INSTANCE));
    }

    @Override
    @Nullable
    public Fn getDateIntervalInstance(@NotNull PType lhs, @NotNull PType rhs) {
        Function2 function2;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        switch (rhs.getIntervalCode()) {
            case 0: {
                function2 = getDateIntervalInstance.op.1.INSTANCE;
                break;
            }
            case 1: {
                function2 = getDateIntervalInstance.op.2.INSTANCE;
                break;
            }
            case 2: {
                function2 = getDateIntervalInstance.op.3.INSTANCE;
                break;
            }
            case 3: {
                function2 = getDateIntervalInstance.op.4.INSTANCE;
                break;
            }
            case 4: {
                function2 = getDateIntervalInstance.op.5.INSTANCE;
                break;
            }
            case 5: {
                function2 = getDateIntervalInstance.op.6.INSTANCE;
                break;
            }
            case 6: {
                function2 = getDateIntervalInstance.op.7.INSTANCE;
                break;
            }
            case 7: {
                function2 = getDateIntervalInstance.op.8.INSTANCE;
                break;
            }
            case 8: {
                function2 = getDateIntervalInstance.op.9.INSTANCE;
                break;
            }
            case 9: {
                function2 = getDateIntervalInstance.op.10.INSTANCE;
                break;
            }
            case 10: {
                function2 = getDateIntervalInstance.op.11.INSTANCE;
                break;
            }
            case 11: {
                function2 = getDateIntervalInstance.op.12.INSTANCE;
                break;
            }
            case 12: {
                function2 = getDateIntervalInstance.op.13.INSTANCE;
                break;
            }
            default: {
                return null;
            }
        }
        Function2 op2 = function2;
        PType pType = PType.date();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"date(...)");
        return this.basic(pType, lhs, rhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>((Function2<? super LocalDate, ? super Datum, LocalDate>)op2){
            final /* synthetic */ Function2<LocalDate, Datum, LocalDate> $op;
            {
                this.$op = $op;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                LocalDate localDate = args[0].getLocalDate();
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"getLocalDate(...)");
                LocalDate arg0 = localDate;
                Datum arg1 = args[1];
                LocalDate result = (LocalDate)this.$op.invoke((Object)arg0, (Object)arg1);
                Datum datum = Datum.date(result);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"date(...)");
                return datum;
            }
        }));
    }

    @Override
    @Nullable
    public Fn getTimeIntervalInstance(@NotNull PType lhs, @NotNull PType rhs) {
        Function2 function2;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        switch (rhs.getIntervalCode()) {
            case 2: {
                function2 = getTimeIntervalInstance.op.1.INSTANCE;
                break;
            }
            case 3: {
                function2 = getTimeIntervalInstance.op.2.INSTANCE;
                break;
            }
            case 4: {
                function2 = getTimeIntervalInstance.op.3.INSTANCE;
                break;
            }
            case 5: {
                function2 = getTimeIntervalInstance.op.4.INSTANCE;
                break;
            }
            case 7: {
                function2 = getTimeIntervalInstance.op.5.INSTANCE;
                break;
            }
            case 8: {
                function2 = getTimeIntervalInstance.op.6.INSTANCE;
                break;
            }
            case 9: {
                function2 = getTimeIntervalInstance.op.7.INSTANCE;
                break;
            }
            case 10: {
                function2 = getTimeIntervalInstance.op.8.INSTANCE;
                break;
            }
            case 11: {
                function2 = getTimeIntervalInstance.op.9.INSTANCE;
                break;
            }
            case 12: {
                function2 = getTimeIntervalInstance.op.10.INSTANCE;
                break;
            }
            default: {
                return null;
            }
        }
        Function2 op2 = function2;
        int lhsPrecision = lhs.getPrecision();
        return this.basic(lhs, lhs, rhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>((Function2<? super LocalTime, ? super Datum, LocalTime>)op2, lhsPrecision){
            final /* synthetic */ Function2<LocalTime, Datum, LocalTime> $op;
            final /* synthetic */ int $lhsPrecision;
            {
                this.$op = $op;
                this.$lhsPrecision = $lhsPrecision;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                LocalTime localTime = args[0].getLocalTime();
                Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"getLocalTime(...)");
                LocalTime arg0 = localTime;
                Datum arg1 = args[1];
                LocalTime result = (LocalTime)this.$op.invoke((Object)arg0, (Object)arg1);
                Datum datum = Datum.time(result, this.$lhsPrecision);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"time(...)");
                return datum;
            }
        }));
    }

    @Override
    @Nullable
    public Fn getTimestampIntervalInstance(@NotNull PType lhs, @NotNull PType rhs) {
        Function2 function2;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        switch (rhs.getIntervalCode()) {
            case 0: {
                function2 = getTimestampIntervalInstance.op.1.INSTANCE;
                break;
            }
            case 1: {
                function2 = getTimestampIntervalInstance.op.2.INSTANCE;
                break;
            }
            case 2: {
                function2 = getTimestampIntervalInstance.op.3.INSTANCE;
                break;
            }
            case 3: {
                function2 = getTimestampIntervalInstance.op.4.INSTANCE;
                break;
            }
            case 4: {
                function2 = getTimestampIntervalInstance.op.5.INSTANCE;
                break;
            }
            case 5: {
                function2 = getTimestampIntervalInstance.op.6.INSTANCE;
                break;
            }
            case 6: {
                function2 = getTimestampIntervalInstance.op.7.INSTANCE;
                break;
            }
            case 7: {
                function2 = getTimestampIntervalInstance.op.8.INSTANCE;
                break;
            }
            case 8: {
                function2 = getTimestampIntervalInstance.op.9.INSTANCE;
                break;
            }
            case 9: {
                function2 = getTimestampIntervalInstance.op.10.INSTANCE;
                break;
            }
            case 10: {
                function2 = getTimestampIntervalInstance.op.11.INSTANCE;
                break;
            }
            case 11: {
                function2 = getTimestampIntervalInstance.op.12.INSTANCE;
                break;
            }
            case 12: {
                function2 = getTimestampIntervalInstance.op.13.INSTANCE;
                break;
            }
            default: {
                return null;
            }
        }
        Function2 op2 = function2;
        int lhsPrecision = lhs.getPrecision();
        return this.basic(lhs, lhs, rhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>((Function2<? super LocalDateTime, ? super Datum, LocalDateTime>)op2, lhsPrecision){
            final /* synthetic */ Function2<LocalDateTime, Datum, LocalDateTime> $op;
            final /* synthetic */ int $lhsPrecision;
            {
                this.$op = $op;
                this.$lhsPrecision = $lhsPrecision;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                LocalDateTime localDateTime = args[0].getLocalDateTime();
                Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"getLocalDateTime(...)");
                LocalDateTime arg0 = localDateTime;
                Datum arg1 = args[1];
                LocalDateTime result = (LocalDateTime)this.$op.invoke((Object)arg0, (Object)arg1);
                Datum datum = Datum.timestamp(result, this.$lhsPrecision);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"timestamp(...)");
                return datum;
            }
        }));
    }

    public static final /* synthetic */ Datum access$subtractIntervalDayTimes(FnMinus $this, Datum lhs, Datum rhs, int precision, int scale) {
        return $this.subtractIntervalDayTimes(lhs, rhs, precision, scale);
    }

    public static final /* synthetic */ Datum access$subtractIntervalYearMonths(FnMinus $this, Datum lhs, Datum rhs, int precision) {
        return $this.subtractIntervalYearMonths(lhs, rhs, precision);
    }

    static {
        INSTANCE.fillTable();
    }
}

