/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function.builtins;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.function.Fn;
import org.partiql.spi.function.builtins.DiadicArithmeticOperator;
import org.partiql.spi.function.builtins.FnTimes;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006H\u0016J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002\u00a8\u0006\""}, d2={"Lorg/partiql/spi/function/builtins/FnTimes;", "Lorg/partiql/spi/function/builtins/DiadicArithmeticOperator;", "()V", "getBigIntInstance", "Lorg/partiql/spi/function/Fn;", "bigIntLhs", "Lorg/partiql/spi/types/PType;", "bigIntRhs", "getDecimalInstance", "decimalLhs", "decimalRhs", "getDoubleInstance", "doubleLhs", "doubleRhs", "getIntegerInstance", "integerLhs", "integerRhs", "getNumericInstance", "numericLhs", "numericRhs", "getRealInstance", "realLhs", "realRhs", "getSmallIntInstance", "smallIntLhs", "smallIntRhs", "getTinyIntInstance", "tinyIntLhs", "tinyIntRhs", "timesPrecisionScale", "Lkotlin/Pair;", "", "lhs", "rhs", "partiql-spi"})
public final class FnTimes
extends DiadicArithmeticOperator {
    @NotNull
    public static final FnTimes INSTANCE = new FnTimes();

    private FnTimes() {
        super("times", false, 2, null);
    }

    @Override
    @NotNull
    public Fn getTinyIntInstance(@NotNull PType tinyIntLhs, @NotNull PType tinyIntRhs) {
        Intrinsics.checkNotNullParameter((Object)tinyIntLhs, (String)"tinyIntLhs");
        Intrinsics.checkNotNullParameter((Object)tinyIntRhs, (String)"tinyIntRhs");
        PType pType = PType.tinyint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"tinyint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getTinyIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getSmallIntInstance(@NotNull PType smallIntLhs, @NotNull PType smallIntRhs) {
        Intrinsics.checkNotNullParameter((Object)smallIntLhs, (String)"smallIntLhs");
        Intrinsics.checkNotNullParameter((Object)smallIntRhs, (String)"smallIntRhs");
        PType pType = PType.smallint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"smallint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getSmallIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getIntegerInstance(@NotNull PType integerLhs, @NotNull PType integerRhs) {
        Intrinsics.checkNotNullParameter((Object)integerLhs, (String)"integerLhs");
        Intrinsics.checkNotNullParameter((Object)integerRhs, (String)"integerRhs");
        PType pType = PType.integer();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"integer(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getIntegerInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getBigIntInstance(@NotNull PType bigIntLhs, @NotNull PType bigIntRhs) {
        Intrinsics.checkNotNullParameter((Object)bigIntLhs, (String)"bigIntLhs");
        Intrinsics.checkNotNullParameter((Object)bigIntRhs, (String)"bigIntRhs");
        PType pType = PType.bigint();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"bigint(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getBigIntInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getNumericInstance(@NotNull PType numericLhs, @NotNull PType numericRhs) {
        Intrinsics.checkNotNullParameter((Object)numericLhs, (String)"numericLhs");
        Intrinsics.checkNotNullParameter((Object)numericRhs, (String)"numericRhs");
        Pair<Integer, Integer> pair = this.timesPrecisionScale(numericLhs, numericRhs);
        int p = ((Number)pair.component1()).intValue();
        int s = ((Number)pair.component2()).intValue();
        PType pType = PType.numeric(p, s);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"numeric(...)");
        return this.basic(pType, numericLhs, numericRhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>(p, s){
            final /* synthetic */ int $p;
            final /* synthetic */ int $s;
            {
                this.$p = $p;
                this.$s = $s;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                BigDecimal bigDecimal = args[0].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                BigDecimal arg0 = bigDecimal;
                BigDecimal bigDecimal2 = args[1].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getBigDecimal(...)");
                BigDecimal arg1 = bigDecimal2;
                BigDecimal bigDecimal3 = arg0.multiply(arg1);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
                Datum datum = Datum.numeric(bigDecimal3, this.$p, this.$s);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"numeric(...)");
                return datum;
            }
        }));
    }

    @Override
    @NotNull
    public Fn getDecimalInstance(@NotNull PType decimalLhs, @NotNull PType decimalRhs) {
        Intrinsics.checkNotNullParameter((Object)decimalLhs, (String)"decimalLhs");
        Intrinsics.checkNotNullParameter((Object)decimalRhs, (String)"decimalRhs");
        Pair<Integer, Integer> pair = this.timesPrecisionScale(decimalLhs, decimalRhs);
        int p = ((Number)pair.component1()).intValue();
        int s = ((Number)pair.component2()).intValue();
        PType pType = PType.decimal(p, s);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"decimal(...)");
        return this.basic(pType, decimalLhs, decimalRhs, (Function1<? super Datum[], ? extends Datum>)((Function1)new Function1<Datum[], Datum>(p, s){
            final /* synthetic */ int $p;
            final /* synthetic */ int $s;
            {
                this.$p = $p;
                this.$s = $s;
                super(1);
            }

            @NotNull
            public final Datum invoke(@NotNull Datum[] args) {
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                BigDecimal bigDecimal = args[0].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                BigDecimal arg0 = bigDecimal;
                BigDecimal bigDecimal2 = args[1].getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"getBigDecimal(...)");
                BigDecimal arg1 = bigDecimal2;
                BigDecimal bigDecimal3 = arg0.multiply(arg1);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"multiply(...)");
                Datum datum = Datum.decimal(bigDecimal3, this.$p, this.$s);
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"decimal(...)");
                return datum;
            }
        }));
    }

    private final Pair<Integer, Integer> timesPrecisionScale(PType lhs, PType rhs) {
        Pair pair = TuplesKt.to((Object)lhs.getPrecision(), (Object)lhs.getScale());
        int p1 = ((Number)pair.component1()).intValue();
        int s1 = ((Number)pair.component2()).intValue();
        Pair pair2 = TuplesKt.to((Object)rhs.getPrecision(), (Object)rhs.getScale());
        int p2 = ((Number)pair2.component1()).intValue();
        int s2 = ((Number)pair2.component2()).intValue();
        int p = p1 + p2 + 1;
        int s = s1 + s2;
        int returnedP = RangesKt.coerceAtMost((int)p, (int)38);
        int returnedS = RangesKt.coerceAtMost((int)s, (int)p);
        return TuplesKt.to((Object)returnedP, (Object)returnedS);
    }

    @Override
    @NotNull
    public Fn getRealInstance(@NotNull PType realLhs, @NotNull PType realRhs) {
        Intrinsics.checkNotNullParameter((Object)realLhs, (String)"realLhs");
        Intrinsics.checkNotNullParameter((Object)realRhs, (String)"realRhs");
        PType pType = PType.real();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"real(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getRealInstance.1.INSTANCE));
    }

    @Override
    @NotNull
    public Fn getDoubleInstance(@NotNull PType doubleLhs, @NotNull PType doubleRhs) {
        Intrinsics.checkNotNullParameter((Object)doubleLhs, (String)"doubleLhs");
        Intrinsics.checkNotNullParameter((Object)doubleRhs, (String)"doubleRhs");
        PType pType = PType.doublePrecision();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"doublePrecision(...)");
        return this.basic(pType, (Function1<? super Datum[], ? extends Datum>)((Function1)getDoubleInstance.1.INSTANCE));
    }

    static {
        INSTANCE.fillTable();
    }
}

