/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function.builtins.internal;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.builtins.internal.Accumulator;
import org.partiql.spi.types.PType;
import org.partiql.spi.utils.FunctionUtils;
import org.partiql.spi.utils.NumberUtils;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/partiql/spi/function/builtins/internal/AccumulatorAvgDynamic;", "Lorg/partiql/spi/function/builtins/internal/Accumulator;", "()V", "accumulatorType", "Lorg/partiql/spi/utils/NumberUtils$AccumulatorType;", "count", "", "sum", "", "nextValue", "", "value", "Lorg/partiql/spi/value/Datum;", "partiql-spi"})
public final class AccumulatorAvgDynamic
extends Accumulator {
    @Nullable
    private Number sum;
    private long count;
    @Nullable
    private NumberUtils.AccumulatorType accumulatorType;

    @Override
    public void nextValue(@NotNull Datum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FunctionUtils.INSTANCE.checkIsNumberType$partiql_spi("AVG", value);
        if (this.sum == null) {
            Number number;
            switch (value.getType().code()) {
                case 8: 
                case 9: {
                    this.accumulatorType = NumberUtils.AccumulatorType.APPROX;
                    number = 0.0;
                    break;
                }
                default: {
                    this.accumulatorType = NumberUtils.AccumulatorType.DECIMAL;
                    number = BigDecimal.ZERO;
                }
            }
            this.sum = number;
        } else if (value.getType().code() == 8 || value.getType().code() == 9) {
            this.accumulatorType = NumberUtils.AccumulatorType.APPROX;
        }
        Number number = this.sum;
        Intrinsics.checkNotNull((Object)number);
        NumberUtils.AccumulatorType accumulatorType = this.accumulatorType;
        Intrinsics.checkNotNull((Object)((Object)accumulatorType));
        this.sum = NumberUtils.INSTANCE.add(number, value, accumulatorType);
        ++this.count;
    }

    @Override
    @NotNull
    public Datum value() {
        Datum datum;
        if (this.count == 0L) {
            Datum datum2 = Datum.nullValue(PType.dynamic());
            datum = datum2;
            Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"nullValue(...)");
        } else {
            Number number;
            Number number2 = this.sum;
            if (number2 instanceof BigDecimal) {
                Number number3 = this.sum;
                Intrinsics.checkNotNull((Object)number3);
                number = NumberUtils.bigDecimalOf$partiql_spi$default(NumberUtils.INSTANCE, number3, null, 2, null).divide(NumberUtils.bigDecimalOf$partiql_spi$default(NumberUtils.INSTANCE, this.count, null, 2, null), NumberUtils.INSTANCE.getMATH_CONTEXT$partiql_spi());
            } else if (number2 instanceof Double) {
                Number number4 = this.sum;
                Intrinsics.checkNotNull((Object)number4);
                number = number4.doubleValue() / (double)this.count;
            } else {
                throw new IllegalStateException("Sum should be BigDecimal or Double".toString());
            }
            Double d = number;
            Intrinsics.checkNotNull((Object)d);
            Number number5 = d;
            PType pType = PType.dynamic();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
            datum = NumberUtils.INSTANCE.toTargetType$partiql_spi(number5, pType);
        }
        return datum;
    }
}

