/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.function.builtins.internal;

import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.function.builtins.internal.Accumulator;
import org.partiql.spi.types.PType;
import org.partiql.spi.utils.FunctionUtils;
import org.partiql.spi.utils.NumberUtils;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/partiql/spi/function/builtins/internal/AccumulatorSumDynamic;", "Lorg/partiql/spi/function/builtins/internal/Accumulator;", "()V", "accumulatorType", "Lorg/partiql/spi/utils/NumberUtils$AccumulatorType;", "sum", "", "getSum", "()Ljava/lang/Number;", "setSum", "(Ljava/lang/Number;)V", "nextValue", "", "value", "Lorg/partiql/spi/value/Datum;", "partiql-spi"})
public final class AccumulatorSumDynamic
extends Accumulator {
    @Nullable
    private Number sum;
    @Nullable
    private NumberUtils.AccumulatorType accumulatorType;

    @Nullable
    public final Number getSum() {
        return this.sum;
    }

    public final void setSum(@Nullable Number number) {
        this.sum = number;
    }

    @Override
    public void nextValue(@NotNull Datum value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FunctionUtils.INSTANCE.checkIsNumberType$partiql_spi("SUM", value);
        if (this.sum == null) {
            Number number;
            switch (value.getType().code()) {
                case 2: 
                case 3: 
                case 4: {
                    this.accumulatorType = NumberUtils.AccumulatorType.INTEGRAL;
                    number = 0L;
                    break;
                }
                case 8: 
                case 9: {
                    this.accumulatorType = NumberUtils.AccumulatorType.APPROX;
                    number = 0.0;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.accumulatorType = NumberUtils.AccumulatorType.DECIMAL;
                    number = BigDecimal.ZERO;
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unexpected type: " + value.getType()).toString());
                }
            }
            this.sum = number;
        } else {
            switch (value.getType().code()) {
                case 8: 
                case 9: {
                    this.accumulatorType = NumberUtils.AccumulatorType.APPROX;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    NumberUtils.AccumulatorType accumulatorType = this.accumulatorType;
                    Intrinsics.checkNotNull((Object)((Object)accumulatorType));
                    if (accumulatorType == NumberUtils.AccumulatorType.APPROX) break;
                    this.accumulatorType = NumberUtils.AccumulatorType.DECIMAL;
                }
            }
        }
        Number number = this.sum;
        Intrinsics.checkNotNull((Object)number);
        NumberUtils.AccumulatorType accumulatorType = this.accumulatorType;
        Intrinsics.checkNotNull((Object)((Object)accumulatorType));
        this.sum = NumberUtils.INSTANCE.add(number, value, accumulatorType);
    }

    @Override
    @NotNull
    public Datum value() {
        Object object;
        block3: {
            block2: {
                object = this.sum;
                if (object == null) break block2;
                PType pType = PType.dynamic();
                Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"dynamic(...)");
                if ((object = NumberUtils.INSTANCE.toTargetType$partiql_spi((Number)object, pType)) != null) break block3;
            }
            Datum datum = Datum.nullValue(PType.dynamic());
            object = datum;
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"nullValue(...)");
        }
        return object;
    }
}

