/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.internal;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/partiql/spi/internal/SqlTypeFamily;", "", "preferred", "Lorg/partiql/spi/types/PType;", "(Lorg/partiql/spi/types/PType;)V", "members", "", "", "(Lorg/partiql/spi/types/PType;Ljava/util/Set;)V", "contains", "", "type", "Companion", "partiql-spi"})
public final class SqlTypeFamily {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final PType preferred;
    @JvmField
    @NotNull
    public final Set<Integer> members;
    @NotNull
    private static final SqlTypeFamily BOOLEAN;
    @NotNull
    private static final SqlTypeFamily TEXT;
    @NotNull
    private static final SqlTypeFamily COLLECTION;
    @NotNull
    private static final SqlTypeFamily NUMBER;

    private SqlTypeFamily(PType preferred, Set<Integer> members) {
        this.preferred = preferred;
        this.members = members;
    }

    public SqlTypeFamily(@NotNull PType preferred) {
        Intrinsics.checkNotNullParameter((Object)preferred, (String)"preferred");
        this(preferred, SetsKt.setOf((Object)preferred.code()));
    }

    public final boolean contains(@NotNull PType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.members.contains(type.code());
    }

    @NotNull
    public static final SqlTypeFamily getBOOLEAN() {
        return Companion.getBOOLEAN();
    }

    @NotNull
    public static final SqlTypeFamily getTEXT() {
        return Companion.getTEXT();
    }

    @NotNull
    public static final SqlTypeFamily getCOLLECTION() {
        return Companion.getCOLLECTION();
    }

    @NotNull
    public static final SqlTypeFamily getNUMBER() {
        return Companion.getNUMBER();
    }

    static {
        PType pType = PType.bool();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"bool(...)");
        BOOLEAN = new SqlTypeFamily(pType, SetsKt.setOf((Object)1));
        PType pType2 = PType.string();
        Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"string(...)");
        Object[] objectArray = new Integer[]{10, 11, 12, 14};
        TEXT = new SqlTypeFamily(pType2, SetsKt.setOf((Object[])objectArray));
        PType pType3 = PType.bag();
        Intrinsics.checkNotNullExpressionValue((Object)pType3, (String)"bag(...)");
        objectArray = new Integer[]{20, 21};
        COLLECTION = new SqlTypeFamily(pType3, SetsKt.setOf((Object[])objectArray));
        PType pType4 = PType.decimal(38, 19);
        Intrinsics.checkNotNullExpressionValue((Object)pType4, (String)"decimal(...)");
        objectArray = new Integer[]{2, 3, 4, 5, 6, 8, 9, 7};
        NUMBER = new SqlTypeFamily(pType4, SetsKt.setOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/partiql/spi/internal/SqlTypeFamily$Companion;", "", "()V", "BOOLEAN", "Lorg/partiql/spi/internal/SqlTypeFamily;", "getBOOLEAN$annotations", "getBOOLEAN", "()Lorg/partiql/spi/internal/SqlTypeFamily;", "COLLECTION", "getCOLLECTION$annotations", "getCOLLECTION", "NUMBER", "getNUMBER$annotations", "getNUMBER", "TEXT", "getTEXT$annotations", "getTEXT", "of", "type", "Lorg/partiql/spi/types/PType;", "partiql-spi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SqlTypeFamily of(@NotNull PType type) {
            SqlTypeFamily sqlTypeFamily;
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            switch (type.code()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    sqlTypeFamily = this.getNUMBER();
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 14: {
                    sqlTypeFamily = this.getTEXT();
                    break;
                }
                case 20: 
                case 21: {
                    sqlTypeFamily = this.getCOLLECTION();
                    break;
                }
                default: {
                    sqlTypeFamily = new SqlTypeFamily(type);
                }
            }
            return sqlTypeFamily;
        }

        @NotNull
        public final SqlTypeFamily getBOOLEAN() {
            return BOOLEAN;
        }

        @JvmStatic
        public static /* synthetic */ void getBOOLEAN$annotations() {
        }

        @NotNull
        public final SqlTypeFamily getTEXT() {
            return TEXT;
        }

        @JvmStatic
        public static /* synthetic */ void getTEXT$annotations() {
        }

        @NotNull
        public final SqlTypeFamily getCOLLECTION() {
            return COLLECTION;
        }

        @JvmStatic
        public static /* synthetic */ void getCOLLECTION$annotations() {
        }

        @NotNull
        public final SqlTypeFamily getNUMBER() {
            return NUMBER;
        }

        @JvmStatic
        public static /* synthetic */ void getNUMBER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

