/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.internal;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.internal.SqlTypeFamily;
import org.partiql.spi.types.PType;
import org.partiql.spi.types.PTypeField;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J$\u0010\u000e\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J$\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/partiql/spi/internal/SqlTypes;", "", "()V", "areAssignableBooleanTypes", "", "input", "Lorg/partiql/spi/types/PType;", "target", "areAssignableCollectionTypes", "areAssignableDateTimeTypes", "areAssignableDynamicTypes", "areAssignableNumberTypes", "areAssignableStructuralTypes", "areAssignableTextTypes", "fieldsAreAssignable", "", "Lorg/partiql/spi/types/PTypeField;", "isAssignable", "namedFieldsAreAssignableUnordered", "partiql-spi"})
@SourceDebugExtension(value={"SMAP\nSqlTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlTypes.kt\norg/partiql/spi/internal/SqlTypes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n1045#2:169\n1045#2:170\n*S KotlinDebug\n*F\n+ 1 SqlTypes.kt\norg/partiql/spi/internal/SqlTypes\n*L\n96#1:169\n97#1:170\n*E\n"})
public final class SqlTypes {
    @NotNull
    public static final SqlTypes INSTANCE = new SqlTypes();

    private SqlTypes() {
    }

    public final boolean isAssignable(@NotNull PType input, @NotNull PType target) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.areAssignableNumberTypes(input, target) || this.areAssignableTextTypes(input, target) || this.areAssignableBooleanTypes(input, target) || this.areAssignableDateTimeTypes(input, target) || this.areAssignableCollectionTypes(input, target) || this.areAssignableStructuralTypes(input, target) || this.areAssignableDynamicTypes(target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areAssignableCollectionTypes(PType input, PType target) {
        if (!SqlTypeFamily.Companion.getCOLLECTION().contains(input)) return false;
        if (!SqlTypeFamily.Companion.getCOLLECTION().contains(target)) return false;
        PType pType = input.getTypeParameter();
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"getTypeParameter(...)");
        PType pType2 = target.getTypeParameter();
        Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"getTypeParameter(...)");
        if (!this.isAssignable(pType, pType2)) return false;
        return true;
    }

    private final boolean areAssignableDynamicTypes(PType target) {
        return target.code() == 0;
    }

    private final boolean areAssignableStructuralTypes(PType input, PType target) {
        boolean bl;
        if (input.code() == 22 && target.code() == 22) {
            Collection<PTypeField> collection = input.getFields();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getFields(...)");
            List list = CollectionsKt.toList((Iterable)collection);
            Collection<PTypeField> collection2 = target.getFields();
            Intrinsics.checkNotNull(collection2);
            bl = this.fieldsAreAssignable(list, CollectionsKt.toList((Iterable)collection2));
        } else {
            bl = input.code() == 23 && target.code() == 22 ? true : (input.code() == 22 && target.code() == 23 ? true : input.code() == 23 && target.code() == 23);
        }
        return bl;
    }

    private final boolean fieldsAreAssignable(List<? extends PTypeField> input, List<? extends PTypeField> target) {
        if (input.size() != target.size()) {
            return false;
        }
        Iterator<? extends PTypeField> iIter = input.iterator();
        Iterator<? extends PTypeField> tIter = target.iterator();
        while (iIter.hasNext()) {
            PTypeField iField = iIter.next();
            PTypeField tField = tIter.next();
            PType pType = iField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"getType(...)");
            PType pType2 = tField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"getType(...)");
            if (this.isAssignable(pType, pType2)) continue;
            return false;
        }
        return true;
    }

    private final boolean namedFieldsAreAssignableUnordered(List<? extends PTypeField> input, List<? extends PTypeField> target) {
        if (input.size() != target.size()) {
            return false;
        }
        Iterable $this$sortedBy$iv = input;
        boolean $i$f$sortedBy = false;
        List inputSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PTypeField it = (PTypeField)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (PTypeField)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Iterable $this$sortedBy$iv2 = target;
        boolean $i$f$sortedBy2 = false;
        List targetSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PTypeField it = (PTypeField)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (PTypeField)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Iterator iIter = inputSorted.iterator();
        Iterator tIter = targetSorted.iterator();
        while (iIter.hasNext()) {
            PTypeField iField = (PTypeField)iIter.next();
            PTypeField tField = (PTypeField)tIter.next();
            if (!Intrinsics.areEqual((Object)iField.getName(), (Object)tField.getName())) {
                return false;
            }
            PType pType = iField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"getType(...)");
            PType pType2 = tField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)pType2, (String)"getType(...)");
            if (this.isAssignable(pType, pType2)) continue;
            return false;
        }
        return true;
    }

    private final boolean areAssignableNumberTypes(PType input, PType target) {
        return SqlTypeFamily.Companion.getNUMBER().contains(input) && SqlTypeFamily.Companion.getNUMBER().contains(target);
    }

    private final boolean areAssignableBooleanTypes(PType input, PType target) {
        return input.code() == 1 && target.code() == 1;
    }

    private final boolean areAssignableTextTypes(PType input, PType target) {
        return SqlTypeFamily.Companion.getTEXT().contains(input) && SqlTypeFamily.Companion.getTEXT().contains(target);
    }

    private final boolean areAssignableDateTimeTypes(PType input, PType target) {
        int i = input.code();
        int t = target.code();
        return i == 15 && t == 15 ? true : (!(i != 17 && i != 16 || t != 17 && t != 16) ? true : !(i != 19 && i != 18 || t != 19 && t != 18));
    }
}

