/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.internal.value.ion;

import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.Span;
import com.amazon.ion.SpanProvider;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ionelement.api.AnyElement;
import com.amazon.ionelement.api.ElementLoader;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.internal.value.ion.IonDatumException;
import org.partiql.spi.internal.value.ion.IonVariant;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.DatumReader;
import org.partiql.spi.value.Encoding;
import org.partiql.spi.value.Field;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B#\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0002J\b\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\fH\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\fH\u0002J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u000b\u0010*\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010+\u001a\u00020\fH\u0002J\b\u0010,\u001a\u00020\fH\u0002J\b\u0010-\u001a\u00020\fH\u0002J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\fH\u0002J\u0010\u00101\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u00102\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u00103\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0010\u00104\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u00105\u001a\u00020\fH\u0002J\b\u00106\u001a\u00020\fH\u0002J\u0010\u00107\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/partiql/spi/internal/value/ion/IonDatumReader;", "Lorg/partiql/spi/value/DatumReader;", "input", "Ljava/io/InputStream;", "others", "", "Lorg/partiql/spi/value/Encoding;", "(Ljava/io/InputStream;Ljava/util/Map;)V", "reader", "Lcom/amazon/ion/IonReader;", "kotlin.jvm.PlatformType", "array", "Lorg/partiql/spi/value/Datum;", "bag", "bigint", "blob0", "blob1", "size", "", "bool", "char0", "char1", "length", "clob0", "clob1", "close", "", "date0", "decimal0", "decimal1", "precision", "decimal2", "scale", "double", "float", "int", "ion", "method", "Lkotlin/Function0;", "symbol", "", "missing", "next", "read", "real", "smallint", "span", "Lcom/amazon/ion/Span;", "struct", "time1", "timestamp1", "timestampz1", "timez1", "tinyint", "varchar0", "varchar1", "partiql-spi"})
public final class IonDatumReader
implements DatumReader {
    @NotNull
    private final InputStream input;
    @NotNull
    private final Map<Encoding, DatumReader> others;
    private final IonReader reader;

    public IonDatumReader(@NotNull InputStream input, @NotNull Map<Encoding, ? extends DatumReader> others) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(others, (String)"others");
        this.input = input;
        this.others = others;
        this.reader = IonReaderBuilder.standard().build(this.input);
    }

    private final Span span() {
        Span span = ((SpanProvider)this.reader.asFacet(SpanProvider.class)).currentSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"currentSpan(...)");
        return span;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    @Nullable
    public Datum next() throws IOException, IonDatumException {
        Datum datum;
        try {
            Datum datum2;
            if (this.reader.next() == null) {
                return null;
            }
            String[] anno = this.reader.getTypeAnnotations();
            switch (anno.length) {
                case 0: {
                    datum2 = this.read();
                    break;
                }
                case 1: {
                    String string = anno[0];
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
                    datum2 = (Datum)this.method(string).invoke();
                    break;
                }
                default: {
                    throw new IonDatumException("expected 0 or 1 annotations", null, this.span());
                }
            }
            datum = datum2;
        }
        catch (IonException ex) {
            throw new IonDatumException("data exception", ex, this.span());
        }
        catch (NotImplementedError ex) {
            throw new IonDatumException("unsupported type", ex, this.span());
        }
        return datum;
    }

    /*
     * WARNING - void declaration
     */
    private final Datum read() {
        Datum datum;
        IonType ionType = this.reader.getType();
        switch (ionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ionType.ordinal()]) {
            case 1: {
                Datum datum2 = Datum.nullValue();
                datum = datum2;
                Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"nullValue(...)");
                break;
            }
            case 2: {
                datum = this.bool();
                break;
            }
            case 3: {
                datum = this.bigint();
                break;
            }
            case 4: {
                datum = this.double();
                break;
            }
            case 5: {
                datum = this.decimal0();
                break;
            }
            case 6: {
                String string = "timestamp without annotation";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            case 7: {
                datum = this.varchar0();
                break;
            }
            case 8: {
                datum = this.clob0();
                break;
            }
            case 9: {
                datum = this.clob0();
                break;
            }
            case 10: {
                datum = this.array();
                break;
            }
            case 11: {
                datum = this.struct();
                break;
            }
            case 12: {
                datum = this.missing();
                break;
            }
            case 13: {
                void var2_3;
                this.reader.stepIn();
                if (this.reader.next() == null) {
                    throw new IonDatumException("expected type, was null", null, this.span());
                }
                Function0<Datum> method2 = this.method();
                if (this.reader.next() == null) {
                    throw new IonDatumException("expected value, was null", null, this.span());
                }
                Datum value = (Datum)method2.invoke();
                if (this.reader.next() != null) {
                    throw new IonDatumException("expected end of s-expression pair", null, this.span());
                }
                this.reader.stepOut();
                datum = var2_3;
                break;
            }
            default: {
                throw new IonDatumException("unknown type", null, this.span());
            }
        }
        return datum;
    }

    private final Function0<Datum> method(String symbol) {
        Function0 function0;
        switch (symbol) {
            case "bool": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$bool((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "tinyint": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$tinyint((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "smallint": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$smallint((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "int": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$int((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "bigint": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$bigint((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "real": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$real((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "double": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$double((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "char": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$char0((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "varchar": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$varchar0((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "clob": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$clob0((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "blob": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$blob0((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "array": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$array((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "bag": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$bag((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "struct": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$struct((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            case "ion": {
                function0 = (Function0)new Function0<Datum>((Object)this){

                    @NotNull
                    public final Datum invoke() {
                        return IonDatumReader.access$ion((IonDatumReader)this.receiver);
                    }
                };
                break;
            }
            default: {
                throw new IonDatumException("cannot read type " + symbol + " without arguments", null, this.span());
            }
        }
        return function0;
    }

    private final Function0<Datum> method() {
        String symbol;
        IonType ionType = this.reader.getType();
        switch (ionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[ionType.ordinal()]) {
            case 12: {
                symbol = this.reader.symbolValue().getText();
                Intrinsics.checkNotNull((Object)symbol);
                break;
            }
            case 13: {
                throw new IonDatumException("types with parameters are not supported", null, this.span());
            }
            default: {
                throw new IonDatumException("expected symbol or sexp", null, this.span());
            }
        }
        return this.method(symbol);
    }

    private final Datum missing() {
        String v = this.reader.symbolValue().getText();
        if (!Intrinsics.areEqual((Object)v, (Object)"missing")) {
            throw new IonDatumException("expected symbol `missing`, found " + v, null, this.span());
        }
        Datum datum = Datum.missing();
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"missing(...)");
        return datum;
    }

    private final Datum bool() {
        boolean v = this.reader.booleanValue();
        Datum datum = Datum.bool(v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bool(...)");
        return datum;
    }

    private final Datum tinyint() {
        long v = this.reader.longValue();
        if (v < -128L || v > 127L) {
            throw new IonDatumException("tinyint out of range", null, this.span());
        }
        Datum datum = Datum.tinyint((byte)v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"tinyint(...)");
        return datum;
    }

    private final Datum smallint() {
        long v = this.reader.longValue();
        if (v < -32768L || v > 32767L) {
            throw new IonDatumException("smallint out of range", null, this.span());
        }
        Datum datum = Datum.smallint((short)v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"smallint(...)");
        return datum;
    }

    private final Datum int() {
        long v = this.reader.longValue();
        if (v < Integer.MIN_VALUE || v > Integer.MAX_VALUE) {
            throw new IonDatumException("int out of range", null, this.span());
        }
        Datum datum = Datum.integer((int)v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"integer(...)");
        return datum;
    }

    private final Datum bigint() {
        long v = this.reader.longValue();
        Datum datum = Datum.bigint(v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bigint(...)");
        return datum;
    }

    private final Datum decimal0() {
        BigDecimal v = this.reader.decimalValue().bigDecimalValue();
        int p = v.precision();
        int s = v.scale();
        Datum datum = Datum.decimal(v, p, s);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"decimal(...)");
        return datum;
    }

    private final Datum decimal1(int precision) {
        BigDecimal v = this.reader.decimalValue().bigDecimalValue();
        int p = v.precision();
        int s = v.scale();
        if (p != precision) {
            throw new IonDatumException("decimal(" + precision + ") had precision " + p, null, this.span());
        }
        Datum datum = Datum.decimal(v, p, s);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"decimal(...)");
        return datum;
    }

    private final Datum decimal2(int precision, int scale) {
        BigDecimal v = this.reader.decimalValue().bigDecimalValue();
        int p = v.precision();
        int s = v.scale();
        if (p != precision) {
            throw new IonDatumException("decimal(" + precision + ", " + scale + ") had precision " + p, null, this.span());
        }
        if (s != scale) {
            throw new IonDatumException("decimal(" + precision + ", " + scale + ") had scale " + s, null, this.span());
        }
        Datum datum = Datum.decimal(v, p, s);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"decimal(...)");
        return datum;
    }

    private final Datum float(int precision) {
        throw new IonDatumException("float(p) not supported", null, this.span());
    }

    private final Datum real() {
        double v = this.reader.doubleValue();
        if (v > 3.4028234663852886E38 || v < (double)1.4E-45f) {
            throw new IonDatumException("real out of range", null, this.span());
        }
        Datum datum = Datum.real((float)v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"real(...)");
        return datum;
    }

    private final Datum double() {
        double v = this.reader.doubleValue();
        Datum datum = Datum.doublePrecision(v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"doublePrecision(...)");
        return datum;
    }

    private final Datum char0() {
        return this.char1(1);
    }

    private final Datum char1(int length) {
        String v = this.reader.stringValue();
        int l = v.length();
        if (l != length) {
            throw new IonDatumException("char(" + length + ") had length " + l, null, this.span());
        }
        Datum datum = Datum.character(v, length);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"character(...)");
        return datum;
    }

    private final Datum varchar0() {
        String v = this.reader.stringValue();
        Datum datum = Datum.string(v);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"string(...)");
        return datum;
    }

    private final Datum varchar1(int length) {
        String v = this.reader.stringValue();
        int l = v.length();
        if (l != length) {
            throw new IonDatumException("varchar(" + length + ") had length " + l, null, this.span());
        }
        Datum datum = Datum.varchar(v, l);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"varchar(...)");
        return datum;
    }

    private final Datum clob0() {
        byte[] v = this.reader.newBytes();
        int n = v.length;
        Datum datum = Datum.clob(v, n);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"clob(...)");
        return datum;
    }

    private final Datum clob1(int size) {
        byte[] v = this.reader.newBytes();
        int s = v.length;
        if (s != size) {
            throw new IonDatumException("clob(" + size + ") had size " + s, null, this.span());
        }
        Datum datum = Datum.clob(v, s);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"clob(...)");
        return datum;
    }

    private final Datum blob0() {
        byte[] v = this.reader.newBytes();
        int n = v.length;
        Datum datum = Datum.blob(v, n);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"blob(...)");
        return datum;
    }

    private final Datum blob1(int size) {
        byte[] v = this.reader.newBytes();
        int s = v.length;
        if (s != size) {
            throw new IonDatumException("blob(" + size + ") had size " + s, null, this.span());
        }
        Datum datum = Datum.blob(v, s);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"blob(...)");
        return datum;
    }

    private final Datum date0() {
        throw new IonDatumException("date not supported", null, this.span());
    }

    private final Datum time1(int precision) {
        throw new IonDatumException("time(p) not supported", null, this.span());
    }

    private final Datum timez1(int precision) {
        throw new IonDatumException("timez(p) not supported", null, this.span());
    }

    private final Datum timestamp1(int precision) {
        throw new IonDatumException("timestamp(p) not supported", null, this.span());
    }

    private final Datum timestampz1(int precision) {
        throw new IonDatumException("timestampz(p) not supported", null, this.span());
    }

    private final Datum array() {
        this.reader.stepIn();
        List elements = new ArrayList();
        Datum next = this.next();
        while (next != null) {
            elements.add(next);
            next = this.next();
        }
        this.reader.stepOut();
        Datum datum = Datum.array(elements);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"array(...)");
        return datum;
    }

    private final Datum bag() {
        this.reader.stepIn();
        List elements = new ArrayList();
        Datum next = this.next();
        while (next != null) {
            elements.add(next);
            next = this.next();
        }
        this.reader.stepOut();
        Datum datum = Datum.bag(elements);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"bag(...)");
        return datum;
    }

    private final Datum struct() {
        this.reader.stepIn();
        List fields = new ArrayList();
        while (this.reader.next() != null) {
            String name = this.reader.getFieldName();
            Datum value = this.read();
            Field field = Field.of(name, value);
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"of(...)");
            fields.add(field);
        }
        this.reader.stepOut();
        Datum datum = Datum.struct(fields);
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"struct(...)");
        return datum;
    }

    private final Datum ion() {
        IonReader ionReader = this.reader;
        Intrinsics.checkNotNullExpressionValue((Object)ionReader, (String)"reader");
        AnyElement v = ElementLoader.loadSingleElement$default((IonReader)ionReader, null, (int)2, null);
        return new IonVariant(v);
    }

    public static final /* synthetic */ Datum access$bool(IonDatumReader $this) {
        return $this.bool();
    }

    public static final /* synthetic */ Datum access$tinyint(IonDatumReader $this) {
        return $this.tinyint();
    }

    public static final /* synthetic */ Datum access$smallint(IonDatumReader $this) {
        return $this.smallint();
    }

    public static final /* synthetic */ Datum access$int(IonDatumReader $this) {
        return $this.int();
    }

    public static final /* synthetic */ Datum access$bigint(IonDatumReader $this) {
        return $this.bigint();
    }

    public static final /* synthetic */ Datum access$real(IonDatumReader $this) {
        return $this.real();
    }

    public static final /* synthetic */ Datum access$double(IonDatumReader $this) {
        return $this.double();
    }

    public static final /* synthetic */ Datum access$char0(IonDatumReader $this) {
        return $this.char0();
    }

    public static final /* synthetic */ Datum access$varchar0(IonDatumReader $this) {
        return $this.varchar0();
    }

    public static final /* synthetic */ Datum access$clob0(IonDatumReader $this) {
        return $this.clob0();
    }

    public static final /* synthetic */ Datum access$blob0(IonDatumReader $this) {
        return $this.blob0();
    }

    public static final /* synthetic */ Datum access$array(IonDatumReader $this) {
        return $this.array();
    }

    public static final /* synthetic */ Datum access$bag(IonDatumReader $this) {
        return $this.bag();
    }

    public static final /* synthetic */ Datum access$struct(IonDatumReader $this) {
        return $this.struct();
    }

    public static final /* synthetic */ Datum access$ion(IonDatumReader $this) {
        return $this.ion();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IonType.values().length];
            try {
                nArray[IonType.NULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.BOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.INT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.FLOAT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.DECIMAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.TIMESTAMP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.STRING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.CLOB.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.BLOB.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.LIST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.STRUCT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.SYMBOL.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IonType.SEXP.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

