/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.internal.value.ion;

import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import com.amazon.ion.system.IonBinaryWriterBuilder;
import com.amazon.ion.system.IonTextWriterBuilder;
import com.amazon.ionelement.api.AnyElement;
import com.amazon.ionelement.api.ElementType;
import com.amazon.ionelement.api.IntElementSize;
import com.amazon.ionelement.api.StructElement;
import com.amazon.ionelement.api.StructField;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.Field;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010)\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020\rH\u0016J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0096\u0002J\b\u0010%\u001a\u00020\u0001H\u0016J\u0012\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\f\u0010)\u001a\u00020\u001d*\u00020*H\u0002J\f\u0010+\u001a\u00020\u0006*\u00020,H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/partiql/spi/internal/value/ion/IonVariant;", "Lorg/partiql/spi/value/Datum;", "value", "Lcom/amazon/ionelement/api/AnyElement;", "(Lcom/amazon/ionelement/api/AnyElement;)V", "type", "Lorg/partiql/spi/types/PType;", "get", "name", "", "getBigDecimal", "Ljava/math/BigDecimal;", "getBoolean", "", "getBytes", "", "getDouble", "", "getFields", "", "Lorg/partiql/spi/value/Field;", "getInsensitive", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getString", "getType", "isMissing", "isNull", "iterator", "lower", "pack", "charset", "Ljava/nio/charset/Charset;", "toOffsetDateTime", "Lcom/amazon/ion/Timestamp;", "toPType", "Lcom/amazon/ionelement/api/ElementType;", "partiql-spi"})
@SourceDebugExtension(value={"SMAP\nIonVariant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IonVariant.kt\norg/partiql/spi/internal/value/ion/IonVariant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1549#2:262\n1620#2,3:263\n1549#2:266\n1620#2,3:267\n1549#2:270\n1620#2,3:271\n1549#2:274\n1620#2,3:275\n1549#2:278\n1620#2,3:279\n1549#2:282\n1620#2,3:283\n*S KotlinDebug\n*F\n+ 1 IonVariant.kt\norg/partiql/spi/internal/value/ion/IonVariant\n*L\n97#1:262\n97#1:263,3\n98#1:266\n98#1:267,3\n99#1:270\n99#1:271,3\n203#1:274\n203#1:275,3\n204#1:278\n204#1:279,3\n212#1:282\n212#1:283,3\n*E\n"})
public final class IonVariant
implements Datum {
    @NotNull
    private AnyElement value;
    @NotNull
    private PType type;

    public IonVariant(@NotNull AnyElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        PType pType = PType.variant("ion");
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"variant(...)");
        this.type = pType;
    }

    @Override
    @NotNull
    public byte[] pack(@Nullable Charset charset) {
        IonWriter ionWriter;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Charset charset2 = charset;
        if (charset2 == null) {
            ionWriter = IonBinaryWriterBuilder.standard().build((OutputStream)buffer);
        } else if (Intrinsics.areEqual((Object)charset2, (Object)StandardCharsets.UTF_8) ? true : Intrinsics.areEqual((Object)charset2, (Object)StandardCharsets.US_ASCII)) {
            ionWriter = IonTextWriterBuilder.standard().build((OutputStream)buffer);
        } else {
            byte[] byArray = Datum.super.pack(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"pack(...)");
            return byArray;
        }
        IonWriter writer = ionWriter;
        Intrinsics.checkNotNull((Object)writer);
        this.value.writeTo(writer);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Datum lower() {
        Datum datum;
        if (this.value.isNull()) {
            Datum datum2 = Datum.nullValue(this.toPType(this.value.getType()));
            Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"nullValue(...)");
            return datum2;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()]) {
            case 1: {
                Datum datum3 = Datum.string(this.value.getStringValue());
                datum = datum3;
                Intrinsics.checkNotNullExpressionValue((Object)datum3, (String)"string(...)");
                break;
            }
            case 2: {
                Datum datum4 = Datum.string(this.value.getSymbolValue());
                datum = datum4;
                Intrinsics.checkNotNullExpressionValue((Object)datum4, (String)"string(...)");
                break;
            }
            case 3: {
                Datum datum5 = Datum.bool(this.value.getBooleanValue());
                datum = datum5;
                Intrinsics.checkNotNullExpressionValue((Object)datum5, (String)"bool(...)");
                break;
            }
            case 4: {
                Datum datum6 = Datum.clob(this.value.getClobValue().copyOfBytes());
                datum = datum6;
                Intrinsics.checkNotNullExpressionValue((Object)datum6, (String)"clob(...)");
                break;
            }
            case 5: {
                Datum datum7 = Datum.blob(this.value.getBlobValue().copyOfBytes());
                datum = datum7;
                Intrinsics.checkNotNullExpressionValue((Object)datum7, (String)"blob(...)");
                break;
            }
            case 6: {
                Timestamp ts = this.value.getTimestampValue();
                OffsetDateTime ot = this.toOffsetDateTime(ts);
                Datum datum8 = Datum.timestampz(ot, 9);
                Intrinsics.checkNotNull((Object)datum8);
                datum = datum8;
                break;
            }
            case 7: {
                Datum datum9;
                switch (WhenMappings.$EnumSwitchMapping$0[this.value.getIntegerSize().ordinal()]) {
                    case 1: {
                        boolean bl;
                        long l = this.value.getLongValue();
                        boolean bl2 = bl = l < Integer.MAX_VALUE && l > Integer.MIN_VALUE;
                        if (bl) {
                            datum9 = Datum.integer((int)l);
                            break;
                        }
                        if (!bl) {
                            datum9 = Datum.bigint(l);
                            break;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 2: {
                        BigDecimal dec = new BigDecimal(this.value.getBigIntegerValue());
                        datum9 = Datum.decimal(dec, dec.precision(), 0);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Datum datum10 = datum9;
                Intrinsics.checkNotNull((Object)datum10);
                datum = datum10;
                break;
            }
            case 8: {
                Datum datum11 = Datum.doublePrecision(this.value.getDoubleValue());
                datum = datum11;
                Intrinsics.checkNotNullExpressionValue((Object)datum11, (String)"doublePrecision(...)");
                break;
            }
            case 9: {
                BigDecimal decimal = this.value.getDecimalValue().bigDecimalValue();
                Datum datum12 = Datum.decimal(decimal, decimal.precision(), decimal.scale());
                Intrinsics.checkNotNull((Object)datum12);
                datum = datum12;
                break;
            }
            case 10: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.value.getListValues();
                boolean $i$f$map = false;
                Iterable dec = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AnyElement anyElement = (AnyElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new IonVariant((AnyElement)it));
                }
                Datum datum13 = Datum.array((List)destination$iv$iv);
                datum = datum13;
                Intrinsics.checkNotNullExpressionValue((Object)datum13, (String)"array(...)");
                break;
            }
            case 11: {
                Iterable $this$map$iv = this.value.getSexpValues();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    AnyElement it = (AnyElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new IonVariant(it));
                }
                Datum datum14 = Datum.array((List)destination$iv$iv);
                datum = datum14;
                Intrinsics.checkNotNullExpressionValue((Object)datum14, (String)"array(...)");
                break;
            }
            case 12: {
                Iterable $this$map$iv = this.value.getStructFields();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    StructField it = (StructField)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Field.of(it.getName(), new IonVariant(it.getValue())));
                }
                Datum datum15 = Datum.struct((List)destination$iv$iv);
                datum = datum15;
                Intrinsics.checkNotNullExpressionValue((Object)datum15, (String)"struct(...)");
                break;
            }
            case 13: {
                throw new IllegalStateException("The NULL type is impossible to be received.".toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return datum;
    }

    private final PType toPType(ElementType $this$toPType) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toPType.ordinal()]) {
            case 1: 
            case 2: {
                n = 12;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 14;
                break;
            }
            case 5: {
                n = 13;
                break;
            }
            case 6: {
                n = 18;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            case 8: {
                n = 9;
                break;
            }
            case 9: {
                n = 7;
                break;
            }
            case 10: 
            case 11: {
                n = 20;
                break;
            }
            case 12: {
                n = 23;
                break;
            }
            case 13: {
                n = 24;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int code = n;
        PType pType = PType.of(code);
        Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"of(...)");
        return pType;
    }

    @Override
    @NotNull
    public PType getType() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    @NotNull
    public String getString() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()]) {
            case 2: {
                string = this.value.getStringValue();
                break;
            }
            case 1: {
                string = this.value.getStringValue();
                break;
            }
            default: {
                String string2 = Datum.super.getString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            }
        }
        return string;
    }

    @Override
    public boolean getBoolean() {
        return WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()] == 3 ? this.value.getBooleanValue() : Datum.super.getBoolean();
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        byte[] byArray;
        switch (WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()]) {
            case 4: {
                byArray = this.value.getClobValue().copyOfBytes();
                break;
            }
            case 5: {
                byArray = this.value.getBlobValue().copyOfBytes();
                break;
            }
            default: {
                byte[] byArray2 = Datum.super.getBytes();
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            }
        }
        return byArray;
    }

    @Override
    @NotNull
    public LocalDate getLocalDate() {
        if (this.value.getType() != ElementType.TIMESTAMP) {
            LocalDate localDate = Datum.super.getLocalDate();
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"getLocalDate(...)");
            return localDate;
        }
        Timestamp ts = this.value.getTimestampValue();
        LocalDate localDate = LocalDate.of(ts.getYear(), ts.getMonth(), ts.getDay());
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"of(...)");
        return localDate;
    }

    @Override
    @NotNull
    public LocalTime getLocalTime() {
        throw new IllegalArgumentException("getLocalTime() not supported, use lower() or getLocalDateTime()");
    }

    @Override
    @NotNull
    public OffsetTime getOffsetTime() {
        throw new IllegalArgumentException("getOffsetTime() not supported, use lower() or getOffsetDateTime()");
    }

    @Override
    @NotNull
    public LocalDateTime getLocalDateTime() {
        LocalDateTime localDateTime = this.getOffsetDateTime().toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"toLocalDateTime(...)");
        return localDateTime;
    }

    @Override
    @NotNull
    public OffsetDateTime getOffsetDateTime() {
        if (this.value.getType() != ElementType.TIMESTAMP) {
            OffsetDateTime offsetDateTime = Datum.super.getOffsetDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"getOffsetDateTime(...)");
            return offsetDateTime;
        }
        return this.toOffsetDateTime(this.value.getTimestampValue());
    }

    @Override
    @NotNull
    public BigDecimal getBigDecimal() {
        BigDecimal bigDecimal;
        switch (WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()]) {
            case 7: {
                bigDecimal = new BigDecimal(this.value.getBigIntegerValue());
                break;
            }
            case 9: {
                BigDecimal bigDecimal2 = this.value.getDecimalValue().bigDecimalValue();
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"bigDecimalValue(...)");
                break;
            }
            default: {
                BigDecimal bigDecimal3 = Datum.super.getBigDecimal();
                bigDecimal = bigDecimal3;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"getBigDecimal(...)");
            }
        }
        return bigDecimal;
    }

    @Override
    public double getDouble() {
        return WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()] == 8 ? this.value.getDoubleValue() : Datum.super.getDouble();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Datum> iterator() {
        Iterator<Datum> iterator;
        switch (WhenMappings.$EnumSwitchMapping$1[this.value.getType().ordinal()]) {
            case 10: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.value.getListValues();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AnyElement anyElement = (AnyElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new IonVariant((AnyElement)it));
                }
                iterator = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)).iterator();
                break;
            }
            case 11: {
                Iterable $this$map$iv = this.value.getSexpValues();
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    AnyElement it = (AnyElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new IonVariant(it));
                }
                iterator = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)).iterator();
                break;
            }
            default: {
                Iterator<Datum> iterator2 = Datum.super.iterator();
                iterator = iterator2;
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            }
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterator<Field> getFields() {
        void $this$mapTo$iv$iv;
        if (this.value.getType() != ElementType.STRUCT) {
            Iterator<Field> iterator = Datum.super.getFields();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"getFields(...)");
            return iterator;
        }
        Iterable $this$map$iv = this.value.getStructFields();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StructField structField = (StructField)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Field.of(it.getName(), new IonVariant(it.getValue())));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv)).iterator();
    }

    @Override
    @NotNull
    public Datum get(@NotNull String name) {
        Datum datum;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.value.getType() != ElementType.STRUCT) {
            Datum datum2 = Datum.super.get(name);
            Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"get(...)");
            return datum2;
        }
        AnyElement v = this.value.asStruct().getOptional(name);
        if (v == null) {
            Datum datum3 = Datum.missing();
            Intrinsics.checkNotNull((Object)datum3);
            datum = datum3;
        } else {
            datum = new IonVariant(v);
        }
        return datum;
    }

    @Override
    @NotNull
    public Datum getInsensitive(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.value.getType() != ElementType.STRUCT) {
            Datum datum = Datum.super.get(name);
            Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"get(...)");
            return datum;
        }
        StructElement struct = this.value.asStruct();
        for (StructField field : struct.getFields()) {
            if (!StringsKt.equals((String)field.getName(), (String)name, (boolean)true)) continue;
            return new IonVariant(field.getValue());
        }
        Datum datum = Datum.missing();
        Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"missing(...)");
        return datum;
    }

    private final OffsetDateTime toOffsetDateTime(Timestamp $this$toOffsetDateTime) {
        Timestamp ts = $this$toOffsetDateTime;
        Integer o = ts.getLocalOffset();
        ZoneOffset tz = o == null ? ZoneOffset.UTC : ZoneOffset.ofHoursMinutes(o / 60, o % 60);
        BigDecimal ds = ts.getDecimalSecond();
        int second = ds.intValue();
        int nanoOfSecond = ds.remainder(BigDecimal.ONE).movePointRight(9).intValue();
        LocalDate date = LocalDate.of(ts.getYear(), ts.getMonth(), ts.getDay());
        LocalTime time = LocalTime.of(ts.getHour(), ts.getMinute(), second, nanoOfSecond);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(date, time, tz);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"of(...)");
        return offsetDateTime;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IntElementSize.values().length];
            try {
                nArray[IntElementSize.LONG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntElementSize.BIG_INTEGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ElementType.values().length];
            try {
                nArray[ElementType.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.SYMBOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.BOOL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.CLOB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.BLOB.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.TIMESTAMP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.INT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.FLOAT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.DECIMAL.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.LIST.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.SEXP.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.STRUCT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ElementType.NULL.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

