/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.types;

import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.Enum;
import org.partiql.spi.UnsupportedCodeException;
import org.partiql.spi.types.PTypeCollection;
import org.partiql.spi.types.PTypeDecimal;
import org.partiql.spi.types.PTypeField;
import org.partiql.spi.types.PTypeIntervalDateTime;
import org.partiql.spi.types.PTypeIntervalYearMonth;
import org.partiql.spi.types.PTypePrimitive;
import org.partiql.spi.types.PTypeRow;
import org.partiql.spi.types.PTypeVariant;
import org.partiql.spi.types.PTypeWithMaxLength;
import org.partiql.spi.types.PTypeWithPrecisionOnly;

public abstract class PType
extends Enum {
    public static final int DYNAMIC = 0;
    public static final int BOOL = 1;
    public static final int TINYINT = 2;
    public static final int SMALLINT = 3;
    public static final int INTEGER = 4;
    public static final int BIGINT = 5;
    public static final int NUMERIC = 6;
    public static final int DECIMAL = 7;
    public static final int REAL = 8;
    public static final int DOUBLE = 9;
    public static final int CHAR = 10;
    public static final int VARCHAR = 11;
    public static final int STRING = 12;
    public static final int BLOB = 13;
    public static final int CLOB = 14;
    public static final int DATE = 15;
    public static final int TIME = 16;
    public static final int TIMEZ = 17;
    public static final int TIMESTAMP = 18;
    public static final int TIMESTAMPZ = 19;
    public static final int ARRAY = 20;
    public static final int BAG = 21;
    public static final int ROW = 22;
    public static final int STRUCT = 23;
    public static final int UNKNOWN = 24;
    public static final int VARIANT = 25;
    public static final int INTERVAL_YM = 26;
    public static final int INTERVAL_DT = 27;

    protected PType(int code) {
        super(code);
    }

    @NotNull
    public Collection<PTypeField> getFields() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getPrecision() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getLength() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getScale() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PType getTypeParameter() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getIntervalCode() throws UnsupportedOperationException {
        String name;
        try {
            name = this.name();
        }
        catch (UnsupportedCodeException e) {
            name = Integer.toString(this.code());
        }
        throw new UnsupportedOperationException("Code " + this.getClass().getName() + "." + name + " does not support getIntervalCode().");
    }

    public int getFractionalPrecision() throws UnsupportedOperationException {
        String name;
        try {
            name = this.name();
        }
        catch (UnsupportedCodeException e) {
            name = Integer.toString(this.code());
        }
        throw new UnsupportedOperationException("Code " + this.getClass().getName() + "." + name + " does not support getLeadingPrecision().");
    }

    public static int[] codes() {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    }

    @Override
    @NotNull
    public String name() throws UnsupportedCodeException {
        int code = this.code();
        switch (code) {
            case 0: {
                return "DYNAMIC";
            }
            case 1: {
                return "BOOL";
            }
            case 2: {
                return "TINYINT";
            }
            case 3: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case 5: {
                return "BIGINT";
            }
            case 6: {
                return "NUMERIC";
            }
            case 7: {
                return "DECIMAL";
            }
            case 8: {
                return "REAL";
            }
            case 9: {
                return "DOUBLE";
            }
            case 10: {
                return "CHAR";
            }
            case 11: {
                return "VARCHAR";
            }
            case 12: {
                return "STRING";
            }
            case 13: {
                return "BLOB";
            }
            case 14: {
                return "CLOB";
            }
            case 15: {
                return "DATE";
            }
            case 16: {
                return "TIME";
            }
            case 17: {
                return "TIMEZ";
            }
            case 18: {
                return "TIMESTAMP";
            }
            case 19: {
                return "TIMESTAMPZ";
            }
            case 20: {
                return "ARRAY";
            }
            case 21: {
                return "BAG";
            }
            case 22: {
                return "ROW";
            }
            case 23: {
                return "STRUCT";
            }
            case 24: {
                return "UNKNOWN";
            }
            case 25: {
                return "VARIANT";
            }
            case 26: {
                return "INTERVAL_YM";
            }
            case 27: {
                return "INTERVAL_DT";
            }
        }
        throw new UnsupportedCodeException(code);
    }

    @NotNull
    public static PType intervalYear(int precision) {
        return new PTypeIntervalYearMonth(0, precision);
    }

    @NotNull
    public static PType intervalMonth(int precision) {
        return new PTypeIntervalYearMonth(1, precision);
    }

    @NotNull
    public static PType intervalDay(int precision) {
        return new PTypeIntervalDateTime(2, precision);
    }

    @NotNull
    public static PType intervalHour(int precision) {
        return new PTypeIntervalDateTime(3, precision);
    }

    @NotNull
    public static PType intervalMinute(int precision) {
        return new PTypeIntervalDateTime(4, precision);
    }

    @NotNull
    public static PType intervalSecond(int precision, int fractionalPrecision) {
        return new PTypeIntervalDateTime(5, precision, fractionalPrecision);
    }

    @NotNull
    public static PType intervalYearMonth(int precision) {
        return new PTypeIntervalYearMonth(6, precision);
    }

    @NotNull
    public static PType intervalDayHour(int precision) {
        return new PTypeIntervalDateTime(7, precision);
    }

    @NotNull
    public static PType intervalDayMinute(int precision) {
        return new PTypeIntervalDateTime(8, precision);
    }

    @NotNull
    public static PType intervalDaySecond(int precision, int fractionalPrecision) {
        return new PTypeIntervalDateTime(9, precision, fractionalPrecision);
    }

    @NotNull
    public static PType intervalHourMinute(int precision) {
        return new PTypeIntervalDateTime(10, precision);
    }

    @NotNull
    public static PType intervalHourSecond(int precision, int fractionalPrecision) {
        return new PTypeIntervalDateTime(11, precision, fractionalPrecision);
    }

    @NotNull
    public static PType intervalMinuteSecond(int precision, int fractionalPrecision) {
        return new PTypeIntervalDateTime(12, precision, fractionalPrecision);
    }

    @NotNull
    public static PType dynamic() {
        return new PTypePrimitive(0);
    }

    @NotNull
    public static PType bool() {
        return new PTypePrimitive(1);
    }

    @NotNull
    public static PType tinyint() {
        return new PTypePrimitive(2);
    }

    @NotNull
    public static PType smallint() {
        return new PTypePrimitive(3);
    }

    @NotNull
    public static PType integer() {
        return new PTypePrimitive(4);
    }

    @NotNull
    public static PType bigint() {
        return new PTypePrimitive(5);
    }

    @NotNull
    public static PType numeric(int precision, int scale) {
        return new PTypeDecimal(6, precision, scale);
    }

    @NotNull
    public static PType numeric() {
        return new PTypeDecimal(6, 38, 0);
    }

    @NotNull
    public static PType decimal(int precision, int scale) {
        return new PTypeDecimal(7, precision, scale);
    }

    @NotNull
    public static PType decimal() {
        return new PTypeDecimal(7, 38, 0);
    }

    @NotNull
    public static PType real() {
        return new PTypePrimitive(8);
    }

    @NotNull
    public static PType doublePrecision() {
        return new PTypePrimitive(9);
    }

    @NotNull
    public static PType character(int length) {
        return new PTypeWithMaxLength(10, length);
    }

    @NotNull
    public static PType character() {
        return new PTypeWithMaxLength(10, 1);
    }

    @NotNull
    public static PType varchar(int length) {
        return new PTypeWithMaxLength(11, length);
    }

    @NotNull
    public static PType varchar() {
        return new PTypeWithMaxLength(11, 1);
    }

    @NotNull
    public static PType string() {
        return new PTypePrimitive(12);
    }

    @NotNull
    public static PType clob(int length) {
        return new PTypeWithMaxLength(14, length);
    }

    @NotNull
    public static PType clob() {
        return new PTypeWithMaxLength(14, Integer.MAX_VALUE);
    }

    @NotNull
    public static PType blob(int length) {
        return new PTypeWithMaxLength(13, length);
    }

    @NotNull
    public static PType blob() {
        return new PTypeWithMaxLength(13, Integer.MAX_VALUE);
    }

    @NotNull
    public static PType date() {
        return new PTypePrimitive(15);
    }

    @NotNull
    public static PType time(int precision) {
        return new PTypeWithPrecisionOnly(16, precision);
    }

    @NotNull
    public static PType time() {
        return new PTypeWithPrecisionOnly(16, 6);
    }

    @NotNull
    public static PType timez(int precision) {
        return new PTypeWithPrecisionOnly(17, precision);
    }

    @NotNull
    public static PType timez() {
        return new PTypeWithPrecisionOnly(17, 6);
    }

    @NotNull
    public static PType timestamp(int precision) {
        return new PTypeWithPrecisionOnly(18, precision);
    }

    @NotNull
    public static PType timestamp() {
        return new PTypeWithPrecisionOnly(18, 6);
    }

    @NotNull
    public static PType timestampz(int precision) {
        return new PTypeWithPrecisionOnly(19, precision);
    }

    @NotNull
    public static PType timestampz() {
        return new PTypeWithPrecisionOnly(19, 6);
    }

    @NotNull
    public static PType array() {
        return new PTypeCollection(20, PType.dynamic());
    }

    @NotNull
    public static PType array(@NotNull PType typeParam) {
        return new PTypeCollection(20, typeParam);
    }

    @NotNull
    public static PType bag() {
        return new PTypeCollection(21, PType.dynamic());
    }

    @NotNull
    public static PType bag(@NotNull PType typeParam) {
        return new PTypeCollection(21, typeParam);
    }

    @NotNull
    public static PType row(@NotNull Collection<PTypeField> fields) {
        return new PTypeRow(fields);
    }

    @NotNull
    public static PType row(PTypeField ... fields) {
        return new PTypeRow(Arrays.asList(fields));
    }

    @NotNull
    public static PType struct() {
        return new PTypePrimitive(23);
    }

    @NotNull
    public static PType unknown() {
        return new PTypePrimitive(24);
    }

    @NotNull
    public static PType variant(String encoding) {
        return new PTypeVariant(encoding);
    }

    @NotNull
    public static PType of(int code) throws IllegalArgumentException {
        switch (code) {
            case 0: {
                return PType.dynamic();
            }
            case 1: {
                return PType.bool();
            }
            case 2: {
                return PType.tinyint();
            }
            case 3: {
                return PType.smallint();
            }
            case 4: {
                return PType.integer();
            }
            case 5: {
                return PType.bigint();
            }
            case 6: {
                return PType.numeric();
            }
            case 7: {
                return PType.decimal();
            }
            case 8: {
                return PType.real();
            }
            case 9: {
                return PType.doublePrecision();
            }
            case 10: {
                return PType.character();
            }
            case 11: {
                return PType.varchar();
            }
            case 12: {
                return PType.string();
            }
            case 14: {
                return PType.clob();
            }
            case 13: {
                return PType.blob();
            }
            case 15: {
                return PType.date();
            }
            case 16: {
                return PType.time();
            }
            case 17: {
                return PType.timez();
            }
            case 18: {
                return PType.timestamp();
            }
            case 19: {
                return PType.timestampz();
            }
            case 20: {
                return PType.array();
            }
            case 21: {
                return PType.bag();
            }
            case 22: {
                return PType.row(new PTypeField[0]);
            }
            case 23: {
                return PType.struct();
            }
            case 24: {
                return PType.unknown();
            }
            case 25: {
                return PType.variant("ion");
            }
        }
        throw new IllegalArgumentException("Unknown type code: " + code);
    }
}

