/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.types.PTypeField;

class PTypeRow
extends PType {
    final Collection<PTypeField> _fields;

    PTypeRow(@NotNull Collection<PTypeField> fields) {
        super(22);
        this._fields = fields;
    }

    @Override
    @NotNull
    public Collection<PTypeField> getFields() {
        return this._fields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PType)) {
            return false;
        }
        if (22 != ((PType)o).code()) {
            return false;
        }
        Collection<PTypeField> otherFields = ((PType)o).getFields();
        int size = this._fields.size();
        if (size != otherFields.size()) {
            return false;
        }
        Iterator<PTypeField> thisIter = this._fields.iterator();
        Iterator<PTypeField> otherIter = otherFields.iterator();
        for (int i = 0; i < size; ++i) {
            PTypeField otherField;
            PTypeField thisField = thisIter.next();
            if (thisField.equals(otherField = otherIter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        Collection fieldStringList = this._fields.stream().map(f -> f.getName() + ": " + f.getType()).collect(Collectors.toList());
        String fieldStrings = String.join((CharSequence)", ", fieldStringList);
        return "ROW(" + fieldStrings + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.code(), this._fields);
    }
}

