/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.utils;

import com.amazon.ion.Decimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.function.builtins.internal.PErrors;
import org.partiql.spi.types.PType;
import org.partiql.spi.utils.NumberUtils;
import org.partiql.spi.value.Datum;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u00019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001f\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\b\b\u0002\u0010\u0017\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0018J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0011\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0000\u00a2\u0006\u0002\b J)\u0010!\u001a\u0002H\"\"\b\b\u0000\u0010\"*\u00020\u0007*\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\"0\u0006H\u0002\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\u001f*\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0080\u0002\u00a2\u0006\u0002\b&J\u0011\u0010'\u001a\u00020(*\u00020\u0011H\u0000\u00a2\u0006\u0002\b)J\u0011\u0010*\u001a\u00020\u001e*\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0011\u0010-\u001a\u00020\u001e*\u00020\u0007H\u0000\u00a2\u0006\u0002\b.J\u0011\u0010/\u001a\u000200*\u00020\u0011H\u0000\u00a2\u0006\u0002\b1J\u0011\u00102\u001a\u00020\u0007*\u00020\u0011H\u0000\u00a2\u0006\u0002\b3J\u0011\u00104\u001a\u00020\u001e*\u00020\u001fH\u0000\u00a2\u0006\u0002\b5J\f\u00106\u001a\u00020\u0011*\u00020\u0007H\u0002J\u0019\u00107\u001a\u00020\u0011*\u00020\u00072\u0006\u0010\u0012\u001a\u00020+H\u0000\u00a2\u0006\u0002\b8R,\u0010\u0003\u001a \u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006:"}, d2={"Lorg/partiql/spi/utils/NumberUtils;", "", "()V", "CONVERSION_MAP", "", "", "Ljava/lang/Class;", "", "CONVERTERS", "Lkotlin/Function1;", "MATH_CONTEXT", "Ljava/math/MathContext;", "getMATH_CONTEXT$partiql_spi", "()Ljava/math/MathContext;", "add", "curSum", "value", "Lorg/partiql/spi/value/Datum;", "type", "Lorg/partiql/spi/utils/NumberUtils$AccumulatorType;", "bigDecimalOf", "Ljava/math/BigDecimal;", "num", "mc", "bigDecimalOf$partiql_spi", "coerceNumbers", "Lkotlin/Pair;", "first", "second", "byteOverflows", "", "", "byteOverflows$partiql_spi", "coerce", "T", "(Ljava/lang/Number;Ljava/lang/Class;)Ljava/lang/Number;", "compareTo", "other", "compareTo$partiql_spi", "doubleValue", "", "doubleValue$partiql_spi", "isNumber", "Lorg/partiql/spi/types/PType;", "isNumber$partiql_spi", "isZero", "isZero$partiql_spi", "longValue", "", "longValue$partiql_spi", "numberValue", "numberValue$partiql_spi", "shortOverflows", "shortOverflows$partiql_spi", "toDatum", "toTargetType", "toTargetType$partiql_spi", "AccumulatorType", "partiql-spi"})
public final class NumberUtils {
    @NotNull
    public static final NumberUtils INSTANCE = new NumberUtils();
    @NotNull
    private static final MathContext MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_EVEN);
    @NotNull
    private static final Map<Set<Class<?>>, Class<? extends Number>> CONVERSION_MAP;
    @NotNull
    private static final Map<Class<?>, Function1<Number, Number>> CONVERTERS;

    private NumberUtils() {
    }

    @NotNull
    public final MathContext getMATH_CONTEXT$partiql_spi() {
        return MATH_CONTEXT;
    }

    @NotNull
    public final BigDecimal bigDecimalOf$partiql_spi(@NotNull Number num, @NotNull MathContext mc) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Number number = num;
        if (number instanceof Decimal) {
            bigDecimal = (BigDecimal)num;
        } else if (number instanceof Integer) {
            bigDecimal = new BigDecimal(num.intValue(), mc);
        } else if (number instanceof Long) {
            bigDecimal = new BigDecimal(num.longValue(), mc);
        } else if (number instanceof Float) {
            bigDecimal = new BigDecimal(num.doubleValue(), mc);
        } else if (number instanceof Double) {
            bigDecimal = new BigDecimal(num.doubleValue(), mc);
        } else if (number instanceof BigInteger) {
            bigDecimal = new BigDecimal((BigInteger)num, mc);
        } else if (number instanceof BigDecimal) {
            bigDecimal = (BigDecimal)num;
        } else {
            throw new IllegalArgumentException("Unsupported number type: " + num + ", " + num.getClass());
        }
        return bigDecimal;
    }

    public static /* synthetic */ BigDecimal bigDecimalOf$partiql_spi$default(NumberUtils numberUtils, Number number, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            mathContext = MATH_CONTEXT;
        }
        return numberUtils.bigDecimalOf$partiql_spi(number, mathContext);
    }

    public final boolean isZero$partiql_spi(@NotNull Number $this$isZero) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
        Number number = $this$isZero;
        if (number instanceof Byte) {
            bl = $this$isZero.intValue() == 0;
        } else if (number instanceof Short) {
            bl = $this$isZero.intValue() == 0;
        } else if (number instanceof Integer) {
            bl = Intrinsics.areEqual((Object)$this$isZero, (Object)0);
        } else if (number instanceof Long) {
            bl = Intrinsics.areEqual((Object)$this$isZero, (Object)0L);
        } else if (number instanceof Float) {
            bl = $this$isZero.floatValue() == 0.0f || $this$isZero.floatValue() == -0.0f;
        } else if (number instanceof Double) {
            bl = $this$isZero.doubleValue() == 0.0 || $this$isZero.doubleValue() == -0.0;
        } else if (number instanceof BigDecimal) {
            bl = ((BigDecimal)$this$isZero).signum() == 0;
        } else if (number instanceof BigInteger) {
            bl = ((BigInteger)$this$isZero).signum() == 0;
        } else {
            throw new IllegalStateException($this$isZero + " (" + $this$isZero.getClass().getSimpleName() + ')');
        }
        return bl;
    }

    private final <T extends Number> T coerce(Number $this$coerce, Class<T> type) {
        Function1<Number, Number> function1 = CONVERTERS.get(type);
        if (function1 == null) {
            throw new IllegalArgumentException("No converter for " + type);
        }
        Function1<Number, Number> conv = function1;
        Object object = conv.invoke((Object)$this$coerce);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of org.partiql.spi.utils.NumberUtils.coerce");
        return (T)((Number)object);
    }

    private final Pair<Number, Number> coerceNumbers(Number first, Number second) {
        Object[] objectArray = new Class[]{NumberUtils.coerceNumbers$typeFor(first), NumberUtils.coerceNumbers$typeFor(second)};
        Class<? extends Number> clazz = CONVERSION_MAP.get(SetsKt.setOf((Object[])objectArray));
        if (clazz == null) {
            throw new IllegalArgumentException("No coercion support for " + NumberUtils.coerceNumbers$typeFor(first) + " to " + NumberUtils.coerceNumbers$typeFor(second));
        }
        Class<? extends Number> type = clazz;
        return new Pair((Object)this.coerce(first, type), (Object)this.coerce(second, type));
    }

    public final int compareTo$partiql_spi(@NotNull Number $this$compareTo, @NotNull Number other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Pair<Number, Number> pair = this.coerceNumbers($this$compareTo, other);
        Number first = (Number)pair.component1();
        Number second = (Number)pair.component2();
        Number number = first;
        if (number instanceof Byte) {
            int n2 = first.intValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Byte");
            n = Intrinsics.compare((int)n2, (int)((Byte)second).byteValue());
        } else if (number instanceof Short) {
            int n3 = first.intValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Short");
            n = Intrinsics.compare((int)n3, (int)((Short)second).shortValue());
        } else if (number instanceof Integer) {
            int n4 = first.intValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Int");
            n = Intrinsics.compare((int)n4, (int)((Integer)second));
        } else if (number instanceof Long) {
            long l = first.longValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Long");
            n = Intrinsics.compare((long)l, (long)((Long)second));
        } else if (number instanceof Float) {
            float f = first.floatValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Float");
            n = Float.compare(f, ((Float)second).floatValue());
        } else if (number instanceof Double) {
            double d = first.doubleValue();
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type kotlin.Double");
            n = Double.compare(d, (Double)second);
        } else if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)first;
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type java.math.BigDecimal");
            n = bigDecimal.compareTo((BigDecimal)second);
        } else if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)first;
            Intrinsics.checkNotNull((Object)second, (String)"null cannot be cast to non-null type java.math.BigInteger");
            n = bigInteger.compareTo((BigInteger)second);
        } else {
            throw new IllegalStateException();
        }
        return n;
    }

    public final boolean byteOverflows$partiql_spi(int $this$byteOverflows) {
        return $this$byteOverflows < -128 || $this$byteOverflows > 127;
    }

    public final boolean shortOverflows$partiql_spi(int $this$shortOverflows) {
        return $this$shortOverflows < Short.MIN_VALUE || $this$shortOverflows > Short.MAX_VALUE;
    }

    public final long longValue$partiql_spi(@NotNull Datum $this$longValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$longValue, (String)"<this>");
        switch ($this$longValue.getType().code()) {
            case 25: {
                Datum datum = $this$longValue.lower();
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"lower(...)");
                l = this.longValue$partiql_spi(datum);
                break;
            }
            case 2: {
                l = $this$longValue.getByte();
                break;
            }
            case 3: {
                l = $this$longValue.getShort();
                break;
            }
            case 4: {
                l = $this$longValue.getInt();
                break;
            }
            case 5: {
                l = $this$longValue.getLong();
                break;
            }
            default: {
                throw new IllegalStateException(("Cannot convert Datum (" + $this$longValue + ") to long.").toString());
            }
        }
        return l;
    }

    public final double doubleValue$partiql_spi(@NotNull Datum $this$doubleValue) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$doubleValue, (String)"<this>");
        switch ($this$doubleValue.getType().code()) {
            case 25: {
                Datum datum = $this$doubleValue.lower();
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"lower(...)");
                d = this.doubleValue$partiql_spi(datum);
                break;
            }
            case 2: {
                d = $this$doubleValue.getByte();
                break;
            }
            case 3: {
                d = $this$doubleValue.getShort();
                break;
            }
            case 4: {
                d = $this$doubleValue.getInt();
                break;
            }
            case 5: {
                d = $this$doubleValue.getLong();
                break;
            }
            case 6: {
                d = $this$doubleValue.getBigDecimal().doubleValue();
                break;
            }
            case 8: {
                d = $this$doubleValue.getFloat();
                break;
            }
            case 9: {
                d = $this$doubleValue.getDouble();
                break;
            }
            case 7: {
                d = $this$doubleValue.getBigDecimal().doubleValue();
                break;
            }
            default: {
                throw new IllegalStateException(("Cannot convert Datum (" + $this$doubleValue + ") to double.").toString());
            }
        }
        return d;
    }

    @NotNull
    public final Number numberValue$partiql_spi(@NotNull Datum $this$numberValue) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$numberValue, (String)"<this>");
        switch ($this$numberValue.getType().code()) {
            case 25: {
                Datum datum = $this$numberValue.lower();
                Intrinsics.checkNotNullExpressionValue((Object)datum, (String)"lower(...)");
                number = this.numberValue$partiql_spi(datum);
                break;
            }
            case 2: {
                number = $this$numberValue.getByte();
                break;
            }
            case 3: {
                number = $this$numberValue.getShort();
                break;
            }
            case 4: {
                number = $this$numberValue.getInt();
                break;
            }
            case 5: {
                number = $this$numberValue.getLong();
                break;
            }
            case 6: {
                BigDecimal bigDecimal = $this$numberValue.getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                number = bigDecimal;
                break;
            }
            case 8: {
                number = Float.valueOf($this$numberValue.getFloat());
                break;
            }
            case 9: {
                number = $this$numberValue.getDouble();
                break;
            }
            case 7: {
                BigDecimal bigDecimal = $this$numberValue.getBigDecimal();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"getBigDecimal(...)");
                number = bigDecimal;
                break;
            }
            default: {
                throw new IllegalStateException(("Cannot convert Datum (" + $this$numberValue + ") to number.").toString());
            }
        }
        return number;
    }

    public final boolean isNumber$partiql_spi(@NotNull PType $this$isNumber) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isNumber, (String)"<this>");
        switch ($this$isNumber.code()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Datum toTargetType$partiql_spi(@NotNull Number $this$toTargetType, @NotNull PType type) {
        Datum datum;
        Intrinsics.checkNotNullParameter((Object)$this$toTargetType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (type.code()) {
            case 0: {
                datum = this.toDatum($this$toTargetType);
                break;
            }
            case 8: {
                Datum datum2 = Datum.real($this$toTargetType.floatValue());
                datum = datum2;
                Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"real(...)");
                break;
            }
            case 9: {
                Datum datum3 = Datum.doublePrecision($this$toTargetType.doubleValue());
                datum = datum3;
                Intrinsics.checkNotNullExpressionValue((Object)datum3, (String)"doublePrecision(...)");
                break;
            }
            case 7: {
                BigDecimal d;
                Datum datum4;
                Number number = $this$toTargetType;
                if (number instanceof BigDecimal) {
                    datum4 = Datum.decimal((BigDecimal)$this$toTargetType, ((BigDecimal)$this$toTargetType).precision(), ((BigDecimal)$this$toTargetType).scale());
                } else if (number instanceof BigInteger) {
                    d = new BigDecimal((BigInteger)$this$toTargetType);
                    datum4 = Datum.decimal(d, d.precision(), d.scale());
                } else {
                    d = BigDecimal.valueOf($this$toTargetType.doubleValue());
                    datum4 = Datum.decimal(d, d.precision(), d.scale());
                }
                Datum datum5 = datum4;
                Intrinsics.checkNotNull((Object)datum5);
                datum = datum5;
                break;
            }
            case 2: {
                Datum datum6 = Datum.tinyint($this$toTargetType.byteValue());
                datum = datum6;
                Intrinsics.checkNotNullExpressionValue((Object)datum6, (String)"tinyint(...)");
                break;
            }
            case 3: {
                Datum datum7 = Datum.smallint($this$toTargetType.shortValue());
                datum = datum7;
                Intrinsics.checkNotNullExpressionValue((Object)datum7, (String)"smallint(...)");
                break;
            }
            case 4: {
                Datum datum8 = Datum.integer($this$toTargetType.intValue());
                datum = datum8;
                Intrinsics.checkNotNullExpressionValue((Object)datum8, (String)"integer(...)");
                break;
            }
            case 5: {
                Datum datum9 = Datum.bigint($this$toTargetType.longValue());
                datum = datum9;
                Intrinsics.checkNotNullExpressionValue((Object)datum9, (String)"bigint(...)");
                break;
            }
            case 6: {
                Number number = $this$toTargetType;
                Datum datum10 = number instanceof BigInteger ? Datum.numeric(new BigDecimal((BigInteger)$this$toTargetType)) : (number instanceof BigDecimal ? Datum.numeric((BigDecimal)$this$toTargetType) : Datum.numeric(BigDecimal.valueOf($this$toTargetType.longValue())));
                Intrinsics.checkNotNull((Object)datum10);
                datum = datum10;
                break;
            }
            default: {
                String string = "Unsupported target type " + type;
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return datum;
    }

    private final Datum toDatum(Number $this$toDatum) {
        Datum datum;
        Number number = $this$toDatum;
        if (number instanceof Integer) {
            Datum datum2 = Datum.integer($this$toDatum.intValue());
            datum = datum2;
            Intrinsics.checkNotNullExpressionValue((Object)datum2, (String)"integer(...)");
        } else if (number instanceof Long) {
            Datum datum3 = Datum.bigint($this$toDatum.longValue());
            datum = datum3;
            Intrinsics.checkNotNullExpressionValue((Object)datum3, (String)"bigint(...)");
        } else if (number instanceof Double) {
            Datum datum4 = Datum.doublePrecision($this$toDatum.doubleValue());
            datum = datum4;
            Intrinsics.checkNotNullExpressionValue((Object)datum4, (String)"doublePrecision(...)");
        } else if (number instanceof BigDecimal) {
            Datum datum5 = Datum.decimal((BigDecimal)$this$toDatum, ((BigDecimal)$this$toDatum).precision(), ((BigDecimal)$this$toDatum).scale());
            datum = datum5;
            Intrinsics.checkNotNullExpressionValue((Object)datum5, (String)"decimal(...)");
        } else if (number instanceof BigInteger) {
            Datum datum6 = Datum.numeric(new BigDecimal((BigInteger)$this$toDatum));
            datum = datum6;
            Intrinsics.checkNotNullExpressionValue((Object)datum6, (String)"numeric(...)");
        } else {
            String string = "Could not convert " + $this$toDatum + " to PartiQL Value";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        return datum;
    }

    @NotNull
    public final Number add(@NotNull Number curSum, @NotNull Datum value, @NotNull AccumulatorType type) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)curSum, (String)"curSum");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                long l;
                long arg02 = curSum.longValue();
                long arg1 = this.longValue$partiql_spi(value);
                try {
                    l = Math.addExact(arg02, arg1);
                }
                catch (ArithmeticException e) {
                    String string = arg02 + " + " + arg1;
                    PType pType = PType.bigint();
                    Intrinsics.checkNotNullExpressionValue((Object)pType, (String)"bigint(...)");
                    throw PErrors.INSTANCE.numericValueOutOfRangeException(string, pType);
                }
                number = l;
                break;
            }
            case 2: {
                BigDecimal arg0 = NumberUtils.bigDecimalOf$partiql_spi$default(this, curSum, null, 2, null);
                BigDecimal arg1 = NumberUtils.bigDecimalOf$partiql_spi$default(this, this.numberValue$partiql_spi(value), null, 2, null);
                BigDecimal arg02 = arg0.add(arg1, MATH_CONTEXT);
                Intrinsics.checkNotNull((Object)arg02);
                number = arg02;
                break;
            }
            case 3: {
                double arg0 = curSum.doubleValue();
                double arg1 = this.doubleValue$partiql_spi(value);
                number = arg0 + arg1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return number;
    }

    private static final Class<?> coerceNumbers$typeFor(Number n) {
        return n instanceof Decimal ? BigDecimal.class : n.getClass();
    }

    static {
        Pair[] pairArray = new Pair[64];
        Object[] objectArray = new Class[]{Byte.class, Byte.class};
        pairArray[0] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Byte.class);
        objectArray = new Class[]{Byte.class, Short.class};
        pairArray[1] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Short.class);
        objectArray = new Class[]{Byte.class, Integer.class};
        pairArray[2] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Integer.class);
        objectArray = new Class[]{Byte.class, Long.class};
        pairArray[3] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Byte.class, BigInteger.class};
        pairArray[4] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{Byte.class, Float.class};
        pairArray[5] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Byte.class, Double.class};
        pairArray[6] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Byte.class, BigDecimal.class};
        pairArray[7] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Short.class, Byte.class};
        pairArray[8] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Short.class);
        objectArray = new Class[]{Short.class, Short.class};
        pairArray[9] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Short.class);
        objectArray = new Class[]{Short.class, Integer.class};
        pairArray[10] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Integer.class);
        objectArray = new Class[]{Short.class, Long.class};
        pairArray[11] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Short.class, BigInteger.class};
        pairArray[12] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{Short.class, Float.class};
        pairArray[13] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Short.class, Double.class};
        pairArray[14] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Short.class, BigDecimal.class};
        pairArray[15] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Integer.class, Byte.class};
        pairArray[16] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Integer.class);
        objectArray = new Class[]{Integer.class, Short.class};
        pairArray[17] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Integer.class);
        objectArray = new Class[]{Integer.class, Integer.class};
        pairArray[18] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Integer.class);
        objectArray = new Class[]{Integer.class, Long.class};
        pairArray[19] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Integer.class, BigInteger.class};
        pairArray[20] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{Integer.class, Float.class};
        pairArray[21] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Integer.class, Double.class};
        pairArray[22] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Integer.class, BigDecimal.class};
        pairArray[23] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Long.class, Byte.class};
        pairArray[24] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Long.class, Short.class};
        pairArray[25] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Long.class, Integer.class};
        pairArray[26] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Long.class, Long.class};
        pairArray[27] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Long.class);
        objectArray = new Class[]{Long.class, BigInteger.class};
        pairArray[28] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{Long.class, Float.class};
        pairArray[29] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Long.class, Double.class};
        pairArray[30] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Long.class, BigDecimal.class};
        pairArray[31] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Float.class, Byte.class};
        pairArray[32] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Float.class, Short.class};
        pairArray[33] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Float.class, Integer.class};
        pairArray[34] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Float.class, Long.class};
        pairArray[35] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Float.class, BigInteger.class};
        pairArray[36] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Float.class, Float.class};
        pairArray[37] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Float.class);
        objectArray = new Class[]{Float.class, Double.class};
        pairArray[38] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Float.class, BigDecimal.class};
        pairArray[39] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{Double.class, Byte.class};
        pairArray[40] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, Short.class};
        pairArray[41] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, Integer.class};
        pairArray[42] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, Long.class};
        pairArray[43] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, BigInteger.class};
        pairArray[44] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, Float.class};
        pairArray[45] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, Double.class};
        pairArray[46] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{Double.class, BigDecimal.class};
        pairArray[47] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigInteger.class, Byte.class};
        pairArray[48] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{BigInteger.class, Short.class};
        pairArray[49] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{BigInteger.class, Integer.class};
        pairArray[50] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{BigInteger.class, Long.class};
        pairArray[51] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{BigInteger.class, BigInteger.class};
        pairArray[52] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigInteger.class);
        objectArray = new Class[]{BigInteger.class, Float.class};
        pairArray[53] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{BigInteger.class, Double.class};
        pairArray[54] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), Double.class);
        objectArray = new Class[]{BigInteger.class, BigDecimal.class};
        pairArray[55] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Byte.class};
        pairArray[56] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Short.class};
        pairArray[57] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Integer.class};
        pairArray[58] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Long.class};
        pairArray[59] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, BigInteger.class};
        pairArray[60] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Float.class};
        pairArray[61] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, Double.class};
        pairArray[62] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        objectArray = new Class[]{BigDecimal.class, BigDecimal.class};
        pairArray[63] = TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), BigDecimal.class);
        CONVERSION_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to(Byte.class, (Object)((Object)CONVERTERS.1.INSTANCE)), TuplesKt.to(Short.class, (Object)((Object)CONVERTERS.2.INSTANCE)), TuplesKt.to(Integer.class, (Object)((Object)CONVERTERS.3.INSTANCE)), TuplesKt.to(Long.class, (Object)((Object)CONVERTERS.4.INSTANCE)), TuplesKt.to(Float.class, (Object)((Object)CONVERTERS.5.INSTANCE)), TuplesKt.to(Double.class, (Object)((Object)CONVERTERS.6.INSTANCE)), TuplesKt.to(BigInteger.class, (Object)((Object)CONVERTERS.7.INSTANCE)), TuplesKt.to(BigDecimal.class, (Object)((Object)CONVERTERS.8.INSTANCE))};
        CONVERTERS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/partiql/spi/utils/NumberUtils$AccumulatorType;", "", "(Ljava/lang/String;I)V", "INTEGRAL", "DECIMAL", "APPROX", "partiql-spi"})
    public static final class AccumulatorType
    extends Enum<AccumulatorType> {
        public static final /* enum */ AccumulatorType INTEGRAL = new AccumulatorType();
        public static final /* enum */ AccumulatorType DECIMAL = new AccumulatorType();
        public static final /* enum */ AccumulatorType APPROX = new AccumulatorType();
        private static final /* synthetic */ AccumulatorType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AccumulatorType[] values() {
            return (AccumulatorType[])$VALUES.clone();
        }

        public static AccumulatorType valueOf(String value) {
            return Enum.valueOf(AccumulatorType.class, value);
        }

        @NotNull
        public static EnumEntries<AccumulatorType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = accumulatorTypeArray = new AccumulatorType[]{AccumulatorType.INTEGRAL, AccumulatorType.DECIMAL, AccumulatorType.APPROX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AccumulatorType.values().length];
            try {
                nArray[AccumulatorType.INTEGRAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccumulatorType.DECIMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccumulatorType.APPROX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

