/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.utils;

import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.utils.StringUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J)\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J!\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/partiql/spi/utils/PatternUtils;", "", "()V", "ANY_MANY", "", "ANY_ONE", "PATTERN_ADDITIONAL_BUFFER", "checkEscapeChar", "", "escape", "checkPattern", "Lkotlin/Pair;", "pattern", "checkPattern$partiql_spi", "matchRegexPattern", "", "value", "likePattern", "Ljava/util/regex/Pattern;", "matchRegexPattern$partiql_spi", "parsePattern", "escapeChar", "parsePattern$partiql_spi", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/regex/Pattern;", "partiql-spi"})
public final class PatternUtils {
    @NotNull
    public static final PatternUtils INSTANCE = new PatternUtils();
    private static final int ANY_MANY = 37;
    private static final int ANY_ONE = 95;
    private static final int PATTERN_ADDITIONAL_BUFFER = 8;

    private PatternUtils() {
    }

    @NotNull
    public final Pattern parsePattern$partiql_spi(@NotNull String likePattern, @Nullable Integer escapeChar) {
        Intrinsics.checkNotNullParameter((Object)likePattern, (String)"likePattern");
        StringBuilder buf = new StringBuilder(likePattern.length() + 8);
        buf.append("^");
        boolean isEscaped = false;
        Ref.IntRef wildcardMin = new Ref.IntRef();
        wildcardMin.element = -1;
        Ref.BooleanRef wildcardUnbounded = new Ref.BooleanRef();
        StringBuilder literal = new StringBuilder();
        Function0 flushWildcard2 = (Function0)new Function0<Unit>(wildcardMin, wildcardUnbounded, buf){
            final /* synthetic */ Ref.IntRef $wildcardMin;
            final /* synthetic */ Ref.BooleanRef $wildcardUnbounded;
            final /* synthetic */ StringBuilder $buf;
            {
                this.$wildcardMin = $wildcardMin;
                this.$wildcardUnbounded = $wildcardUnbounded;
                this.$buf = $buf;
                super(0);
            }

            public final void invoke() {
                if (this.$wildcardMin.element != -1) {
                    if (this.$wildcardUnbounded.element) {
                        switch (this.$wildcardMin.element) {
                            case 0: {
                                this.$buf.append(".*?");
                                break;
                            }
                            case 1: {
                                this.$buf.append(".+?");
                                break;
                            }
                            default: {
                                this.$buf.append(".{" + this.$wildcardMin.element + ",}?");
                                break;
                            }
                        }
                    } else if (this.$wildcardMin.element == 1) {
                        this.$buf.append(".");
                    } else {
                        this.$buf.append(".{" + this.$wildcardMin.element + ',' + this.$wildcardMin.element + '}');
                    }
                    this.$wildcardMin.element = -1;
                    this.$wildcardUnbounded.element = false;
                }
            }
        };
        Function0 flushLiteral2 = (Function0)new Function0<Unit>(literal, buf){
            final /* synthetic */ StringBuilder $literal;
            final /* synthetic */ StringBuilder $buf;
            {
                this.$literal = $literal;
                this.$buf = $buf;
                super(0);
            }

            public final void invoke() {
                if (((CharSequence)this.$literal).length() > 0) {
                    this.$buf.append(Pattern.quote(this.$literal.toString()));
                    StringsKt.clear((StringBuilder)this.$literal);
                }
            }
        };
        PrimitiveIterator.OfInt ofInt = likePattern.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer codepoint = ofInt.next();
            if (!isEscaped) {
                Integer n;
                if (Intrinsics.areEqual((Object)codepoint, (Object)escapeChar)) {
                    isEscaped = true;
                    continue;
                }
                Integer n2 = n = codepoint;
                int n3 = 95;
                if (n2 != null && n2 == n3) {
                    flushLiteral2.invoke();
                    wildcardMin.element = Math.max(wildcardMin.element, 0) + 1;
                    continue;
                }
                Integer n4 = n;
                n3 = 37;
                if (n4 != null && n4 == n3) {
                    flushLiteral2.invoke();
                    wildcardMin.element = Math.max(wildcardMin.element, 0);
                    wildcardUnbounded.element = true;
                    continue;
                }
                flushWildcard2.invoke();
                Intrinsics.checkNotNull((Object)codepoint);
                literal.appendCodePoint(codepoint);
                continue;
            }
            flushWildcard2.invoke();
            Intrinsics.checkNotNull((Object)codepoint);
            literal.appendCodePoint(codepoint);
            isEscaped = false;
        }
        flushLiteral2.invoke();
        flushWildcard2.invoke();
        buf.append("$");
        Pattern pattern = Pattern.compile(buf.toString());
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        return pattern;
    }

    public final boolean matchRegexPattern$partiql_spi(@NotNull String value, @NotNull Pattern likePattern) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)likePattern, (String)"likePattern");
        return likePattern.matcher(value).matches();
    }

    @NotNull
    public final Pair<String, Integer> checkPattern$partiql_spi(@NotNull String pattern, @NotNull String escape) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)escape, (String)"escape");
        String escapeCharString = this.checkEscapeChar(escape);
        int escapeCharCodePoint = escapeCharString.codePointAt(0);
        Object[] objectArray = new Integer[]{37, 95, escapeCharCodePoint};
        Set validEscapedChars = SetsKt.setOf((Object[])objectArray);
        Iterator iter = StringUtils.INSTANCE.codePointSequence$partiql_spi(pattern).iterator();
        while (iter.hasNext()) {
            int current = ((Number)iter.next()).intValue();
            if (current != escapeCharCodePoint || iter.hasNext() && validEscapedChars.contains(iter.next())) continue;
            throw new IllegalStateException("Invalid Escape Sequence");
        }
        return new Pair((Object)pattern, (Object)escapeCharCodePoint);
    }

    private final String checkEscapeChar(String escape) {
        if (((CharSequence)escape).length() == 0) {
            throw new IllegalStateException("Cannot use empty character as ESCAPE character in a LIKE predicate: " + escape);
        }
        if (((Object)StringsKt.trim((CharSequence)escape)).toString().length() != 1) {
            throw new IllegalStateException("Escape character must have size 1 : " + escape);
        }
        return escape;
    }
}

