/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import com.amazon.ionelement.api.AnyElement;
import com.amazon.ionelement.api.ElementLoader;
import com.amazon.ionelement.api.IonElementLoader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.errors.PRuntimeException;
import org.partiql.spi.internal.value.ion.IonVariant;
import org.partiql.spi.types.PType;
import org.partiql.spi.types.PTypeField;
import org.partiql.spi.value.DatumBoolean;
import org.partiql.spi.value.DatumByte;
import org.partiql.spi.value.DatumBytes;
import org.partiql.spi.value.DatumCollection;
import org.partiql.spi.value.DatumComparator;
import org.partiql.spi.value.DatumDate;
import org.partiql.spi.value.DatumDecimal;
import org.partiql.spi.value.DatumDouble;
import org.partiql.spi.value.DatumFloat;
import org.partiql.spi.value.DatumInt;
import org.partiql.spi.value.DatumIntervalDayTime;
import org.partiql.spi.value.DatumIntervalHelpers;
import org.partiql.spi.value.DatumIntervalYearMonth;
import org.partiql.spi.value.DatumLong;
import org.partiql.spi.value.DatumMissing;
import org.partiql.spi.value.DatumNull;
import org.partiql.spi.value.DatumRow;
import org.partiql.spi.value.DatumShort;
import org.partiql.spi.value.DatumString;
import org.partiql.spi.value.DatumStruct;
import org.partiql.spi.value.DatumTime;
import org.partiql.spi.value.DatumTimestamp;
import org.partiql.spi.value.DatumTimestampz;
import org.partiql.spi.value.DatumTimez;
import org.partiql.spi.value.Field;
import org.partiql.spi.value.InvalidOperationException;
import org.partiql.spi.value.PErrors;

public interface Datum
extends Iterable<Datum> {
    default public boolean isNull() {
        return false;
    }

    default public boolean isMissing() {
        return false;
    }

    @NotNull
    public PType getType();

    @NotNull
    default public String getString() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getString");
    }

    default public boolean getBoolean() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getBoolean");
    }

    @NotNull
    default public byte[] getBytes() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getBytes");
    }

    default public byte getByte() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getByte");
    }

    default public short getShort() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getShort");
    }

    default public int getInt() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getInt");
    }

    default public long getLong() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getLong");
    }

    default public float getFloat() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getFloat");
    }

    default public double getDouble() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getDouble");
    }

    @NotNull
    default public BigDecimal getBigDecimal() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getBigDecimal");
    }

    @NotNull
    default public LocalDate getLocalDate() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getLocalDate");
    }

    @NotNull
    default public LocalTime getLocalTime() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getLocalTime");
    }

    @NotNull
    default public OffsetTime getOffsetTime() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getOffsetTime");
    }

    @NotNull
    default public LocalDateTime getLocalDateTime() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getLocalDateTime");
    }

    @NotNull
    default public OffsetDateTime getOffsetDateTime() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getOffsetDateTime");
    }

    default public int getYears() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getYears");
    }

    default public int getMonths() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getMonths");
    }

    default public int getDays() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getDays");
    }

    default public int getHours() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getHours");
    }

    default public int getMinutes() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getMinutes");
    }

    default public int getSeconds() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getSeconds");
    }

    default public int getNanos() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "getNanos");
    }

    @Override
    @NotNull
    default public Iterator<Datum> iterator() {
        throw new InvalidOperationException(this.getType(), "iterator");
    }

    @NotNull
    default public Iterator<Field> getFields() {
        throw new InvalidOperationException(this.getType(), "getFields");
    }

    default public Datum get(@NotNull String name) {
        throw new InvalidOperationException(this.getType(), "get");
    }

    default public Datum getInsensitive(@NotNull String name) {
        throw new InvalidOperationException(this.getType(), "getInsensitive");
    }

    default public byte[] pack(@Nullable Charset charset) {
        throw new InvalidOperationException(this.getType(), "pack");
    }

    default public Datum lower() throws InvalidOperationException, NullPointerException {
        throw new InvalidOperationException(this.getType(), "lower");
    }

    @NotNull
    public static Datum nullValue() {
        return new DatumNull();
    }

    @NotNull
    public static Datum missing() {
        return new DatumMissing();
    }

    @NotNull
    public static Datum nullValue(@NotNull PType type) throws PRuntimeException {
        return new DatumNull(type);
    }

    @NotNull
    public static Datum missing(@NotNull PType type) throws PRuntimeException {
        return new DatumMissing(type);
    }

    @NotNull
    public static Datum bool(boolean value) {
        return new DatumBoolean(value);
    }

    @NotNull
    public static Datum tinyint(byte value) {
        return new DatumByte(value, PType.tinyint());
    }

    @NotNull
    public static Datum smallint(short value) {
        return new DatumShort(value);
    }

    @NotNull
    public static Datum integer(int value) {
        return new DatumInt(value);
    }

    @NotNull
    public static Datum bigint(long value) {
        return new DatumLong(value);
    }

    @NotNull
    public static Datum real(float value) {
        return new DatumFloat(value);
    }

    @NotNull
    public static Datum doublePrecision(double value) {
        return new DatumDouble(value);
    }

    @NotNull
    public static Datum decimal(@NotNull BigDecimal value) throws PRuntimeException {
        return new DatumDecimal(value, PType.decimal(38, 0));
    }

    @NotNull
    public static Datum decimal(@NotNull BigDecimal value, int precision, int scale) throws PRuntimeException {
        BigDecimal d = value.round(new MathContext(precision)).setScale(scale, RoundingMode.HALF_UP);
        PType type = PType.decimal(precision, scale);
        if (d.precision() > precision) {
            throw PErrors.numericValueOutOfRangeException(value.toString(), type);
        }
        return new DatumDecimal(d, type);
    }

    @NotNull
    public static Datum numeric(@NotNull BigDecimal value) throws PRuntimeException {
        return new DatumDecimal(value, PType.numeric());
    }

    @NotNull
    public static Datum numeric(@NotNull BigDecimal value, int precision, int scale) throws PRuntimeException {
        BigDecimal d = value.round(new MathContext(precision)).setScale(scale, RoundingMode.HALF_UP);
        PType type = PType.numeric(precision, scale);
        if (d.precision() > precision) {
            throw PErrors.numericValueOutOfRangeException(value.toString(), type);
        }
        return new DatumDecimal(d, type);
    }

    @NotNull
    public static Datum string(@NotNull String value) {
        return new DatumString(value, PType.string());
    }

    @NotNull
    public static Datum varchar(@NotNull String value) throws PRuntimeException {
        return Datum.varchar(value, 255);
    }

    @NotNull
    public static Datum varchar(@NotNull String value, int length) throws PRuntimeException {
        if (length <= 0) {
            throw PErrors.wrappedException(new IllegalArgumentException("VARCHAR of length " + length + " not allowed."));
        }
        String newValue = value.length() < length ? String.format("%-" + length + "." + length + "s", value) : (value.length() == length ? value : value.substring(0, length));
        return new DatumString(newValue, PType.varchar(length));
    }

    @NotNull
    public static Datum character(@NotNull String value) throws PRuntimeException {
        return Datum.character(value, 255);
    }

    @NotNull
    public static Datum character(@NotNull String value, int length) throws PRuntimeException {
        if (length <= 0) {
            throw PErrors.wrappedException(new IllegalArgumentException("CHAR of length " + length + " not allowed."));
        }
        String newValue = value.length() < length ? String.format("%-" + length + "." + length + "s", value) : (value.length() == length ? value : value.substring(0, length));
        return new DatumString(newValue, PType.character(length));
    }

    @NotNull
    public static Datum clob(@NotNull byte[] value) throws PRuntimeException {
        return Datum.clob(value, Integer.MAX_VALUE);
    }

    @NotNull
    public static Datum clob(@NotNull byte[] value, int length) throws PRuntimeException {
        return new DatumBytes(value, PType.clob(length));
    }

    @NotNull
    public static Datum blob(@NotNull byte[] value) throws PRuntimeException {
        return new DatumBytes(value, PType.blob(Integer.MAX_VALUE));
    }

    @NotNull
    public static Datum blob(@NotNull byte[] value, int length) throws PRuntimeException {
        return new DatumBytes(value, PType.blob(length));
    }

    @NotNull
    public static Datum date(@NotNull LocalDate value) throws PRuntimeException {
        return new DatumDate(value);
    }

    @NotNull
    public static Datum time(@NotNull LocalTime value, int precision) throws PRuntimeException {
        return new DatumTime(value, precision);
    }

    @NotNull
    public static Datum timez(@NotNull OffsetTime value, int precision) throws PRuntimeException {
        return new DatumTimez(value, precision);
    }

    @NotNull
    public static Datum timestamp(@NotNull LocalDateTime value, int precision) throws PRuntimeException {
        return new DatumTimestamp(value, precision);
    }

    @NotNull
    public static Datum timestampz(@NotNull OffsetDateTime value, int precision) throws PRuntimeException {
        return new DatumTimestampz(value, precision);
    }

    @NotNull
    public static Datum bag(@NotNull Iterable<Datum> values) {
        return new DatumCollection(values, PType.bag());
    }

    @NotNull
    public static Datum bagVararg(Datum ... values) {
        List<Datum> elements = Arrays.stream(values).collect(Collectors.toList());
        return new DatumCollection(elements, PType.bag());
    }

    @NotNull
    public static Datum array(@NotNull Iterable<Datum> values) {
        return new DatumCollection(values, PType.array());
    }

    @NotNull
    public static Datum struct() {
        return Datum.struct(Collections.emptyList());
    }

    @NotNull
    public static Datum struct(Field ... values) {
        return new DatumStruct(Arrays.stream(values).collect(Collectors.toList()));
    }

    @NotNull
    public static Datum struct(@NotNull Iterable<Field> values) {
        return new DatumStruct(values);
    }

    @NotNull
    public static Datum row() {
        return new DatumRow(new ArrayList<Field>(), PType.row(new PTypeField[0]));
    }

    @NotNull
    public static Datum row(Field ... values) {
        return new DatumRow(Arrays.stream(values).collect(Collectors.toList()));
    }

    @NotNull
    public static Datum row(List<PTypeField> typeFields, Field ... values) {
        return Datum.row(typeFields, Arrays.stream(values).collect(Collectors.toList()));
    }

    @NotNull
    public static Datum row(@NotNull List<Field> values) {
        return new DatumRow(values);
    }

    @NotNull
    public static Datum row(@NotNull List<PTypeField> typeFields, @NotNull List<Field> values) {
        PType type = PType.row(typeFields);
        return new DatumRow(values, type);
    }

    @NotNull
    public static Datum ion(@NotNull String value) throws PRuntimeException {
        try {
            IonElementLoader loader = ElementLoader.createIonElementLoader();
            AnyElement element = loader.loadSingleElement(value);
            return new IonVariant(element);
        }
        catch (Throwable t) {
            throw PErrors.wrappedException(t);
        }
    }

    @NotNull
    public static Datum intervalYear(int years, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(years, precision);
        return new DatumIntervalYearMonth(years, 0, precision, 0);
    }

    @NotNull
    public static Datum intervalMonth(int months, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(months, precision);
        return new DatumIntervalYearMonth(0, months, precision, 1);
    }

    @NotNull
    public static Datum intervalDay(int days, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(days, precision);
        return new DatumIntervalDayTime(days, 0, 0, 0, 0, precision, 0, 2);
    }

    @NotNull
    public static Datum intervalHour(int hours, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(hours, precision);
        return new DatumIntervalDayTime(0, hours, 0, 0, 0, precision, 0, 3);
    }

    @NotNull
    public static Datum intervalMinute(int minutes, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(minutes, precision);
        return new DatumIntervalDayTime(0, 0, minutes, 0, 0, precision, 0, 4);
    }

    @NotNull
    public static Datum intervalSecond(int seconds, int nanos, int precision, int fractionalPrecision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkScale(fractionalPrecision);
        DatumIntervalHelpers.checkUsingPrecision(seconds, precision);
        int newNanos = DatumIntervalHelpers.coerceNanos(nanos, fractionalPrecision);
        return new DatumIntervalDayTime(0, 0, 0, seconds, newNanos, precision, fractionalPrecision, 5);
    }

    @NotNull
    public static Datum intervalYearMonth(int years, int months, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(years, precision);
        DatumIntervalHelpers.checkMonths(months);
        return new DatumIntervalYearMonth(years, months, precision, 6);
    }

    @NotNull
    public static Datum intervalDayHour(int days, int hours, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(days, precision);
        DatumIntervalHelpers.checkHours(hours);
        return new DatumIntervalDayTime(days, hours, 0, 0, 0, precision, 0, 7);
    }

    @NotNull
    public static Datum intervalDayMinute(int days, int hours, int minutes, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(days, precision);
        DatumIntervalHelpers.checkHours(hours);
        DatumIntervalHelpers.checkMinutes(minutes);
        return new DatumIntervalDayTime(days, hours, minutes, 0, 0, precision, 0, 8);
    }

    @NotNull
    public static Datum intervalDaySecond(int days, int hours, int minutes, int seconds, int nanos, int precision, int fractionalPrecision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkScale(fractionalPrecision);
        DatumIntervalHelpers.checkUsingPrecision(days, precision);
        DatumIntervalHelpers.checkHours(hours);
        DatumIntervalHelpers.checkMinutes(minutes);
        DatumIntervalHelpers.checkSeconds(seconds);
        int newNanos = DatumIntervalHelpers.coerceNanos(nanos, fractionalPrecision);
        return new DatumIntervalDayTime(days, hours, minutes, seconds, newNanos, precision, fractionalPrecision, 9);
    }

    @NotNull
    public static Datum intervalHourMinute(int hours, int minutes, int precision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkUsingPrecision(hours, precision);
        DatumIntervalHelpers.checkMinutes(minutes);
        return new DatumIntervalDayTime(0, hours, minutes, 0, 0, precision, 0, 10);
    }

    @NotNull
    public static Datum intervalHourSecond(int hours, int minutes, int seconds, int nanos, int precision, int fractionalPrecision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkScale(fractionalPrecision);
        DatumIntervalHelpers.checkUsingPrecision(hours, precision);
        DatumIntervalHelpers.checkMinutes(minutes);
        DatumIntervalHelpers.checkSeconds(seconds);
        int newNanos = DatumIntervalHelpers.coerceNanos(nanos, fractionalPrecision);
        return new DatumIntervalDayTime(0, hours, minutes, seconds, newNanos, precision, fractionalPrecision, 11);
    }

    @NotNull
    public static Datum intervalMinuteSecond(int minutes, int seconds, int nanos, int precision, int fractionalPrecision) throws RuntimeException {
        DatumIntervalHelpers.checkPrecision(precision);
        DatumIntervalHelpers.checkScale(fractionalPrecision);
        DatumIntervalHelpers.checkUsingPrecision(minutes, precision);
        DatumIntervalHelpers.checkSeconds(seconds);
        int newNanos = DatumIntervalHelpers.coerceNanos(nanos, fractionalPrecision);
        return new DatumIntervalDayTime(0, 0, minutes, seconds, newNanos, precision, fractionalPrecision, 11);
    }

    @NotNull
    public static Comparator<Datum> comparator() {
        return Datum.comparator(true);
    }

    @NotNull
    public static Comparator<Datum> comparator(boolean nullsFirst) {
        if (nullsFirst) {
            return new DatumComparator.NullsFirst();
        }
        return new DatumComparator.NullsLast();
    }
}

