/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.Field;

abstract class DatumComparator
implements Comparator<Datum> {
    private static final int EQUAL = 0;
    private static final int LESS = -1;
    private static final int GREATER = 1;
    @NotNull
    private static final int[] TYPE_KINDS = PType.codes();
    private static final int TYPE_KINDS_LENGTH = TYPE_KINDS.length;
    @NotNull
    private static final Map<Integer, Integer> TYPE_PRECEDENCE = DatumComparator.initializeTypePrecedence();
    private static final DatumComparison[][] COMPARISON_TABLE = DatumComparator.initializeComparators();
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long HOURS_PER_DAY = 24L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;

    DatumComparator() {
    }

    abstract int lhsUnknown();

    abstract int rhsUnknown();

    @Override
    public int compare(Datum lhs, Datum rhs) {
        Datum rhsActual;
        Integer result = this.checkUnknown(lhs, rhs);
        if (result != null) {
            return result;
        }
        boolean lhsIsVariant = lhs.getType().code() == 25;
        boolean rhsIsVariant = rhs.getType().code() == 25;
        Datum lhsActual = lhsIsVariant ? lhs.lower() : lhs;
        Datum datum = rhsActual = rhsIsVariant ? rhs.lower() : rhs;
        if ((lhsIsVariant || rhsIsVariant) && (result = this.checkUnknown(lhsActual, rhsActual)) != null) {
            return result;
        }
        int lhsKind = lhsActual.getType().code();
        int rhsKind = rhsActual.getType().code();
        return COMPARISON_TABLE[lhsKind][rhsKind].apply(lhsActual, rhsActual, this);
    }

    private Integer checkUnknown(Datum lhs, Datum rhs) {
        boolean rhsIsUnknown;
        boolean lhsIsUnknown = lhs.isNull() || lhs.isMissing();
        boolean bl = rhsIsUnknown = rhs.isNull() || rhs.isMissing();
        if (lhsIsUnknown && rhsIsUnknown) {
            return 0;
        }
        if (lhsIsUnknown) {
            return this.lhsUnknown();
        }
        if (rhsIsUnknown) {
            return this.rhsUnknown();
        }
        return null;
    }

    @NotNull
    private static Map<Integer, Integer> initializeTypePrecedence() {
        HashMap<Integer, Integer> precedence = new HashMap<Integer, Integer>();
        precedence.put(1, 0);
        precedence.put(2, 1);
        precedence.put(3, 1);
        precedence.put(4, 1);
        precedence.put(5, 1);
        precedence.put(6, 1);
        precedence.put(7, 1);
        precedence.put(8, 1);
        precedence.put(9, 1);
        precedence.put(15, 2);
        precedence.put(17, 3);
        precedence.put(16, 3);
        precedence.put(19, 4);
        precedence.put(18, 4);
        precedence.put(26, 5);
        precedence.put(27, 5);
        precedence.put(10, 6);
        precedence.put(11, 6);
        precedence.put(12, 6);
        precedence.put(14, 7);
        precedence.put(13, 7);
        precedence.put(20, 8);
        precedence.put(22, 9);
        precedence.put(23, 9);
        precedence.put(21, 10);
        precedence.put(0, 100);
        precedence.put(24, 100);
        precedence.put(25, 100);
        return precedence;
    }

    private static DatumComparison[][] initializeComparators() {
        DatumComparison[][] table = new DatumComparison[TYPE_KINDS_LENGTH][TYPE_KINDS_LENGTH];
        block20: for (int i = 0; i < TYPE_KINDS_LENGTH; ++i) {
            int kind = TYPE_KINDS[i];
            DatumComparison[] row = DatumComparator.initializeComparatorArray(kind);
            table[i] = row;
            switch (kind) {
                case 0: 
                case 24: {
                    continue block20;
                }
                case 1: {
                    DatumComparator.fillBooleanComparator(row);
                    continue block20;
                }
                case 2: {
                    DatumComparator.fillTinyIntComparator(row);
                    continue block20;
                }
                case 3: {
                    DatumComparator.fillSmallIntComparator(row);
                    continue block20;
                }
                case 4: {
                    DatumComparator.fillIntComparator(row);
                    continue block20;
                }
                case 5: {
                    DatumComparator.fillBigIntComparator(row);
                    continue block20;
                }
                case 6: 
                case 7: {
                    DatumComparator.fillDecimalComparator(row);
                    continue block20;
                }
                case 8: {
                    DatumComparator.fillRealComparator(row);
                    continue block20;
                }
                case 9: {
                    DatumComparator.fillDoubleComparator(row);
                    continue block20;
                }
                case 10: 
                case 11: 
                case 12: {
                    DatumComparator.fillStringComparator(row);
                    continue block20;
                }
                case 13: 
                case 14: {
                    DatumComparator.fillLobComparator(row);
                    continue block20;
                }
                case 15: {
                    DatumComparator.fillDateComparator(row);
                    continue block20;
                }
                case 16: 
                case 17: {
                    DatumComparator.fillTimeComparator(row);
                    continue block20;
                }
                case 18: 
                case 19: {
                    DatumComparator.fillTimestampComparator(row);
                    continue block20;
                }
                case 21: {
                    DatumComparator.fillBagComparator(row);
                    continue block20;
                }
                case 20: {
                    DatumComparator.fillListComparator(row);
                    continue block20;
                }
                case 22: 
                case 23: {
                    DatumComparator.fillStructComparator(row);
                    continue block20;
                }
                case 26: 
                case 27: {
                    DatumComparator.fillIntervalComparator(row);
                }
            }
        }
        return table;
    }

    private static DatumComparison[] fillTinyIntComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> Byte.compare(self.getByte(), tinyInt.getByte());
        comps[3] = (self, smallInt, comp) -> Short.compare(self.getByte(), smallInt.getShort());
        comps[4] = (self, intNum, comp) -> Integer.compare(self.getByte(), intNum.getInt());
        comps[5] = (self, bigInt, comp) -> Long.compare(self.getByte(), bigInt.getLong());
        comps[6] = (self, intArbitrary, comp) -> BigDecimal.valueOf(self.getByte()).compareTo(intArbitrary.getBigDecimal());
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubleRhs(real.getFloat(), () -> Float.compare(self.getByte(), real.getFloat()));
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubleRhs(doublePrecision.getDouble(), () -> Double.compare(self.getByte(), doublePrecision.getDouble()));
        comps[7] = (self, decimal, comp) -> BigDecimal.valueOf(self.getByte()).compareTo(decimal.getBigDecimal());
        return comps;
    }

    private static DatumComparison[] fillSmallIntComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> Short.compare(self.getShort(), tinyInt.getByte());
        comps[3] = (self, smallInt, comp) -> Short.compare(self.getShort(), smallInt.getShort());
        comps[4] = (self, intNum, comp) -> Integer.compare(self.getShort(), intNum.getInt());
        comps[5] = (self, bigInt, comp) -> Long.compare(self.getShort(), bigInt.getLong());
        comps[6] = (self, intArbitrary, comp) -> BigDecimal.valueOf(self.getShort()).compareTo(intArbitrary.getBigDecimal());
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubleRhs(real.getFloat(), () -> Float.compare(self.getShort(), real.getFloat()));
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubleRhs(doublePrecision.getDouble(), () -> Double.compare(self.getShort(), doublePrecision.getDouble()));
        comps[7] = (self, decimal, comp) -> BigDecimal.valueOf(self.getShort()).compareTo(decimal.getBigDecimal());
        return comps;
    }

    private static DatumComparison[] fillIntComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> Integer.compare(self.getInt(), tinyInt.getByte());
        comps[3] = (self, smallInt, comp) -> Integer.compare(self.getInt(), smallInt.getShort());
        comps[4] = (self, intNum, comp) -> Integer.compare(self.getInt(), intNum.getInt());
        comps[5] = (self, bigInt, comp) -> Long.compare(self.getInt(), bigInt.getLong());
        comps[6] = (self, intArbitrary, comp) -> BigDecimal.valueOf(self.getInt()).compareTo(intArbitrary.getBigDecimal());
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubleRhs(real.getFloat(), () -> Float.compare(self.getInt(), real.getFloat()));
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubleRhs(doublePrecision.getDouble(), () -> Double.compare(self.getInt(), doublePrecision.getDouble()));
        comps[7] = (self, decimal, comp) -> BigDecimal.valueOf(self.getInt()).compareTo(decimal.getBigDecimal());
        return comps;
    }

    private static DatumComparison[] fillBigIntComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> Long.compare(self.getLong(), tinyInt.getByte());
        comps[3] = (self, smallInt, comp) -> Long.compare(self.getLong(), smallInt.getShort());
        comps[4] = (self, intNum, comp) -> Long.compare(self.getLong(), intNum.getInt());
        comps[5] = (self, bigInt, comp) -> Long.compare(self.getLong(), bigInt.getLong());
        comps[6] = (self, intArbitrary, comp) -> BigDecimal.valueOf(self.getLong()).compareTo(intArbitrary.getBigDecimal());
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubleRhs(real.getFloat(), () -> Float.compare(self.getLong(), real.getFloat()));
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubleRhs(doublePrecision.getDouble(), () -> Double.compare(self.getLong(), doublePrecision.getDouble()));
        comps[7] = (self, decimal, comp) -> BigDecimal.valueOf(self.getLong()).compareTo(decimal.getBigDecimal());
        return comps;
    }

    private static DatumComparison[] fillRealComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> Float.compare(self.getFloat(), tinyInt.getByte()));
        comps[3] = (self, smallInt, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> Float.compare(self.getFloat(), smallInt.getShort()));
        comps[4] = (self, intNum, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> Float.compare(self.getFloat(), intNum.getInt()));
        comps[5] = (self, bigInt, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> Float.compare(self.getFloat(), bigInt.getLong()));
        comps[6] = (self, intArbitrary, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> Float.compare(self.getFloat(), intArbitrary.getBigDecimal().floatValue()));
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubles(self.getFloat(), real.getFloat(), () -> Float.compare(self.getFloat(), real.getFloat()));
        comps[9] = (self, doublePrecision, comp) -> {
            float selfFlt = self.getFloat();
            double otherDbl = doublePrecision.getDouble();
            return DatumComparator.compareDoubles(selfFlt, otherDbl, () -> Double.compare(selfFlt, otherDbl));
        };
        comps[7] = (self, decimal, comp) -> DatumComparator.compareDoubleLhs(self.getFloat(), () -> BigDecimal.valueOf(self.getFloat()).compareTo(decimal.getBigDecimal()));
        return comps;
    }

    private static int compareDoubles(double lhs, double rhs, Supplier<Integer> func) {
        boolean rhsIsZero;
        boolean rhsIsPositiveInf;
        boolean rhsIsNegativeInf;
        boolean lhsIsNan = Double.isNaN(lhs);
        boolean rhsIsNan = Double.isNaN(rhs);
        if (lhsIsNan && rhsIsNan) {
            return 0;
        }
        if (lhsIsNan) {
            return -1;
        }
        if (rhsIsNan) {
            return 1;
        }
        boolean lhsIsNegativeInf = Double.isInfinite(lhs) && lhs < 0.0;
        boolean bl = rhsIsNegativeInf = Double.isInfinite(rhs) && rhs < 0.0;
        if (lhsIsNegativeInf && rhsIsNegativeInf) {
            return 0;
        }
        if (lhsIsNegativeInf) {
            return -1;
        }
        if (rhsIsNegativeInf) {
            return 1;
        }
        boolean lhsIsPositiveInf = Double.isInfinite(lhs) && lhs > 0.0;
        boolean bl2 = rhsIsPositiveInf = Double.isInfinite(rhs) && rhs > 0.0;
        if (lhsIsPositiveInf && rhsIsPositiveInf) {
            return 0;
        }
        if (lhsIsPositiveInf) {
            return 1;
        }
        if (rhsIsPositiveInf) {
            return -1;
        }
        boolean lhsIsZero = lhs == 0.0;
        boolean bl3 = rhsIsZero = rhs == 0.0;
        if (lhsIsZero && rhsIsZero) {
            return 0;
        }
        return func.get();
    }

    private static int compareDoubleLhs(double lhs, Supplier<Integer> func) {
        if (Double.isNaN(lhs)) {
            return -1;
        }
        if (Double.isInfinite(lhs)) {
            if (lhs > 0.0) {
                return 1;
            }
            if (lhs < 0.0) {
                return -1;
            }
        }
        return func.get();
    }

    private static int compareDoubleRhs(double rhs, Supplier<Integer> comparison) {
        if (Double.isNaN(rhs)) {
            return 1;
        }
        if (Double.isInfinite(rhs)) {
            if (rhs > 0.0) {
                return -1;
            }
            if (rhs < 0.0) {
                return 1;
            }
        }
        return comparison.get();
    }

    private static DatumComparison[] fillDoubleComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> Double.compare(self.getDouble(), tinyInt.getByte()));
        comps[3] = (self, smallInt, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> Double.compare(self.getDouble(), smallInt.getShort()));
        comps[4] = (self, intNum, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> Double.compare(self.getDouble(), intNum.getInt()));
        comps[5] = (self, bigInt, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> Double.compare(self.getDouble(), bigInt.getLong()));
        comps[6] = (self, intArbitrary, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> Double.compare(self.getDouble(), intArbitrary.getBigDecimal().doubleValue()));
        comps[8] = (self, real, comp) -> {
            double selfDbl = self.getDouble();
            float otherFlt = real.getFloat();
            return DatumComparator.compareDoubles(selfDbl, otherFlt, () -> Double.compare(selfDbl, otherFlt));
        };
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubles(self.getDouble(), doublePrecision.getDouble(), () -> Double.compare(self.getDouble(), doublePrecision.getDouble()));
        comps[7] = (self, decimal, comp) -> DatumComparator.compareDoubleLhs(self.getDouble(), () -> BigDecimal.valueOf(self.getDouble()).compareTo(decimal.getBigDecimal()));
        return comps;
    }

    private static DatumComparison[] fillDecimalComparator(DatumComparison[] comps) {
        comps[2] = (self, tinyInt, comp) -> self.getBigDecimal().compareTo(BigDecimal.valueOf(tinyInt.getByte()));
        comps[3] = (self, smallInt, comp) -> self.getBigDecimal().compareTo(BigDecimal.valueOf(smallInt.getShort()));
        comps[4] = (self, intNum, comp) -> self.getBigDecimal().compareTo(BigDecimal.valueOf(intNum.getInt()));
        comps[5] = (self, bigInt, comp) -> self.getBigDecimal().compareTo(BigDecimal.valueOf(bigInt.getLong()));
        comps[6] = (self, numeric, comp) -> self.getBigDecimal().compareTo(numeric.getBigDecimal());
        comps[8] = (self, real, comp) -> DatumComparator.compareDoubleRhs(real.getFloat(), () -> self.getBigDecimal().compareTo(BigDecimal.valueOf(real.getFloat())));
        comps[9] = (self, doublePrecision, comp) -> DatumComparator.compareDoubleRhs(doublePrecision.getDouble(), () -> self.getBigDecimal().compareTo(BigDecimal.valueOf(doublePrecision.getDouble())));
        comps[7] = (self, decimal, comp) -> self.getBigDecimal().compareTo(decimal.getBigDecimal());
        return comps;
    }

    private static DatumComparison[] fillDateComparator(DatumComparison[] comps) {
        comps[15] = (self, date, comp) -> self.getLocalDate().compareTo(date.getLocalDate());
        return comps;
    }

    private static DatumComparison[] fillTimeComparator(DatumComparison[] comps) {
        comps[16] = (self, time, comp) -> self.getLocalTime().compareTo(time.getLocalTime());
        comps[17] = (self, time, comp) -> self.getOffsetTime().compareTo(time.getOffsetTime());
        return comps;
    }

    private static DatumComparison[] fillIntervalComparator(DatumComparison[] comps) {
        comps[26] = (self, other, comp) -> {
            long totalMonths = (long)self.getYears() * 12L + (long)self.getMonths();
            long otherTotalMonths = (long)other.getYears() * 12L + (long)other.getMonths();
            return Long.compare(totalMonths, otherTotalMonths);
        };
        comps[27] = (self, other, comp) -> {
            long otherTotalSeconds;
            long totalSeconds = (long)self.getDays() * 86400L + (long)self.getHours() * 3600L + (long)self.getMinutes() * 60L + (long)self.getSeconds();
            int comparison = Long.compare(totalSeconds, otherTotalSeconds = (long)other.getDays() * 86400L + (long)other.getHours() * 3600L + (long)other.getMinutes() * 60L + (long)other.getSeconds());
            if (comparison != 0) {
                return comparison;
            }
            return Integer.compare(self.getNanos(), other.getNanos());
        };
        return comps;
    }

    private static DatumComparison[] fillTimestampComparator(DatumComparison[] comps) {
        comps[18] = (self, timestamp, comp) -> self.getLocalDateTime().compareTo(timestamp.getLocalDateTime());
        comps[19] = (self, timestamp, comp) -> self.getOffsetDateTime().compareTo(timestamp.getOffsetDateTime());
        return comps;
    }

    private static DatumComparison[] fillStringComparator(DatumComparison[] comps) {
        comps[12] = (self, string, comp) -> self.getString().compareTo(string.getString());
        comps[10] = (self, string, comp) -> self.getString().compareTo(string.getString());
        comps[11] = (self, string, comp) -> self.getString().compareTo(string.getString());
        return comps;
    }

    private static DatumComparison[] fillListComparator(DatumComparison[] comps) {
        comps[20] = (self, list, comp) -> DatumComparator.compareOrdered(self.iterator(), list.iterator(), comp);
        return comps;
    }

    private static DatumComparison[] fillBagComparator(DatumComparison[] comps) {
        comps[21] = DatumComparator::compareUnordered;
        return comps;
    }

    private static DatumComparison[] fillBooleanComparator(DatumComparison[] comps) {
        comps[1] = (self, bool, comp) -> Boolean.compare(self.getBoolean(), bool.getBoolean());
        return comps;
    }

    private static DatumComparison[] fillLobComparator(DatumComparison[] comps) {
        comps[13] = (self, blob, comp) -> DatumComparator.compareArray(self.getBytes(), blob.getBytes());
        comps[14] = (self, blob, comp) -> DatumComparator.compareArray(self.getBytes(), blob.getBytes());
        return comps;
    }

    private static DatumComparison[] fillStructComparator(DatumComparison[] comps) {
        comps[23] = (self, struct, comp) -> DatumComparator.compareUnordered(new DatumFieldIterable(self), new DatumFieldIterable(struct), new FieldComparator(comp));
        comps[22] = (self, row, comp) -> DatumComparator.compareOrdered(self.getFields(), row.getFields(), new FieldComparator(comp));
        return comps;
    }

    private static int compareArray(byte[] l, byte[] r) {
        ByteIterator lIter = new ByteIterator(l);
        ByteIterator rIter = new ByteIterator(r);
        return DatumComparator.compareOrdered(lIter, rIter, new ByteComparator());
    }

    private static <T> int compareOrdered(Iterator<T> lIter, Iterator<T> rIter, Comparator<T> elementComparator) {
        while (lIter.hasNext() && rIter.hasNext()) {
            T rVal;
            T lVal = lIter.next();
            int result = elementComparator.compare(lVal, rVal = rIter.next());
            if (result == 0) continue;
            return result;
        }
        if (lIter.hasNext()) {
            return 1;
        }
        if (rIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static <T> int compareUnordered(Iterable<T> l, Iterable<T> r, Comparator<T> elementComparator) {
        ArrayList<T> lhsList = new ArrayList<T>();
        l.forEach(lhsList::add);
        ArrayList<T> rhsList = new ArrayList<T>();
        r.forEach(rhsList::add);
        lhsList.sort(elementComparator);
        rhsList.sort(elementComparator);
        return DatumComparator.compareOrdered(lhsList.iterator(), rhsList.iterator(), elementComparator);
    }

    @NotNull
    private static DatumComparison[] initializeComparatorArray(int lhs) {
        DatumComparison[] array = new DatumComparison[TYPE_KINDS_LENGTH];
        for (int i = 0; i < TYPE_KINDS_LENGTH; ++i) {
            int rhs = TYPE_KINDS[i];
            int lhsPrecedence = TYPE_PRECEDENCE.getOrDefault(lhs, -1);
            int rhsPrecedence = TYPE_PRECEDENCE.getOrDefault(rhs, -1);
            if (lhsPrecedence < 0) {
                throw new IllegalStateException("No precedence set for type: " + lhs);
            }
            if (rhsPrecedence < 0) {
                throw new IllegalStateException("No precedence set for type: " + rhs);
            }
            int typeComparison = Integer.compare(lhsPrecedence, rhsPrecedence);
            array[i] = (self, other, comp) -> typeComparison;
        }
        return array;
    }

    @FunctionalInterface
    static interface DatumComparison {
        public int apply(Datum var1, Datum var2, Comparator<Datum> var3);
    }

    private static class DatumFieldIterable
    implements Iterable<Field> {
        private final Datum datum;

        DatumFieldIterable(Datum datum) {
            this.datum = datum;
        }

        @Override
        @NotNull
        public Iterator<Field> iterator() {
            return this.datum.getFields();
        }
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private final Comparator<Datum> comparator;

        FieldComparator(Comparator<Datum> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Field o1, Field o2) {
            int cmpKey = o1.getName().compareTo(o2.getName());
            if (cmpKey != 0) {
                return cmpKey;
            }
            return this.comparator.compare(o1.getValue(), o2.getValue());
        }
    }

    private static class ByteIterator
    implements Iterator<Byte> {
        private int index = 0;
        private final byte[] bytes;

        ByteIterator(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.bytes.length;
        }

        @Override
        public Byte next() {
            return this.bytes[this.index++];
        }
    }

    private static class ByteComparator
    implements Comparator<Byte> {
        private ByteComparator() {
        }

        @Override
        public int compare(Byte o1, Byte o2) {
            return Byte.compare(o1, o2);
        }
    }

    static class NullsLast
    extends DatumComparator {
        NullsLast() {
        }

        @Override
        int lhsUnknown() {
            return 1;
        }

        @Override
        int rhsUnknown() {
            return -1;
        }
    }

    static class NullsFirst
    extends DatumComparator {
        NullsFirst() {
        }

        @Override
        int lhsUnknown() {
            return -1;
        }

        @Override
        int rhsUnknown() {
            return 1;
        }
    }
}

