/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.InvalidOperationException;

class DatumIntervalDayTime
implements Datum {
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final int nanos;
    private final int precision;
    private final int fractionalPrecision;
    private final int intervalCode;
    private PType _type;

    DatumIntervalDayTime(int days, int hours, int minutes, int seconds, int nanos, int precision, int fractionalPrecision, int intervalCode) {
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.nanos = DatumIntervalDayTime.coerceNanos(nanos, fractionalPrecision);
        this.precision = precision;
        this.fractionalPrecision = fractionalPrecision;
        this.intervalCode = intervalCode;
    }

    private static int coerceNanos(int nanos, int fractionalPrecision) {
        int change = (int)Math.pow(10.0, 9 - fractionalPrecision);
        return nanos / change * change;
    }

    @Override
    @NotNull
    public PType getType() {
        if (this._type == null) {
            this.initType();
        }
        return this._type;
    }

    private void initType() {
        switch (this.intervalCode) {
            case 2: {
                this._type = PType.intervalDay(this.precision);
                break;
            }
            case 3: {
                this._type = PType.intervalHour(this.precision);
                break;
            }
            case 4: {
                this._type = PType.intervalMinute(this.precision);
                break;
            }
            case 5: {
                this._type = PType.intervalSecond(this.precision, this.fractionalPrecision);
                break;
            }
            case 7: {
                this._type = PType.intervalDayHour(this.precision);
                break;
            }
            case 8: {
                this._type = PType.intervalDayMinute(this.precision);
                break;
            }
            case 9: {
                this._type = PType.intervalDaySecond(this.precision, this.fractionalPrecision);
                break;
            }
            case 10: {
                this._type = PType.intervalHourMinute(this.precision);
                break;
            }
            case 11: {
                this._type = PType.intervalHourSecond(this.precision, this.fractionalPrecision);
                break;
            }
            case 12: {
                this._type = PType.intervalMinuteSecond(this.precision, this.fractionalPrecision);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown interval code for day-time: " + this.intervalCode);
            }
        }
    }

    @Override
    public int getDays() throws InvalidOperationException, NullPointerException {
        return this.days;
    }

    @Override
    public int getHours() {
        return this.hours;
    }

    @Override
    public int getMinutes() throws InvalidOperationException, NullPointerException {
        return this.minutes;
    }

    @Override
    public int getSeconds() throws InvalidOperationException, NullPointerException {
        return this.seconds;
    }

    @Override
    public int getNanos() {
        return this.nanos;
    }

    public String toString() {
        return "INTERVAL '" + this.days + " " + this.hours + ":" + this.minutes + ":" + this.seconds + "." + this.nanos + "' " + this.getType();
    }
}

