/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

class DatumIntervalHelpers {
    DatumIntervalHelpers() {
    }

    static void checkPrecision(int precision) {
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Leading field precision must be between 0 and 9 inclusive");
        }
    }

    static void checkScale(int scale) {
        if (scale < 0 || scale > 9) {
            throw new IllegalArgumentException("Fractional seconds precision must be between 0 and 6 inclusive");
        }
    }

    static void checkUsingPrecision(int value, int precision) {
        long newValue = Math.abs((long)value);
        if ((double)newValue < -Math.pow(10.0, precision) || (double)newValue > Math.pow(10.0, precision) - 1.0) {
            throw new IllegalArgumentException("Value " + value + " is out of range for precision " + precision);
        }
    }

    static void checkHours(int hours) {
        long newHours = Math.abs((long)hours);
        if (newHours > 23L) {
            throw new IllegalArgumentException("Hours must be between 0 and 23 inclusive");
        }
    }

    static void checkMinutes(int minutes) {
        long newMinutes = Math.abs((long)minutes);
        if (newMinutes > 59L) {
            throw new IllegalArgumentException("Minutes must be between 0 and 59 inclusive");
        }
    }

    static void checkSeconds(int seconds) {
        long newSeconds = Math.abs((long)seconds);
        if (newSeconds > 59L) {
            throw new IllegalArgumentException("Seconds must be between 0 and 59 inclusive");
        }
    }

    static void checkMonths(int months) {
        long newMonths = Math.abs((long)months);
        if (newMonths > 11L) {
            throw new IllegalArgumentException("Months must be between 0 and 11 inclusive");
        }
    }

    static int coerceNanos(int nanos, int fractionalPrecision) {
        int change = (int)Math.pow(10.0, 9 - fractionalPrecision);
        return nanos / change * change;
    }
}

