/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.InvalidOperationException;

class DatumIntervalYearMonth
implements Datum {
    private final int _years;
    private final int _months;
    private final int precision;
    private final int intervalCode;
    private PType _type;

    DatumIntervalYearMonth(int years, int months, int precision, int intervalCode) {
        this._years = years;
        this._months = months;
        this.precision = precision;
        this.intervalCode = intervalCode;
    }

    @Override
    @NotNull
    public PType getType() {
        if (this._type == null) {
            this.initType();
        }
        return this._type;
    }

    private void initType() {
        switch (this.intervalCode) {
            case 0: {
                this._type = PType.intervalYear(this.precision);
                break;
            }
            case 1: {
                this._type = PType.intervalMonth(this.precision);
                break;
            }
            case 6: {
                this._type = PType.intervalYearMonth(this.precision);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown interval code for year-month: " + this.intervalCode);
            }
        }
    }

    @Override
    public int getYears() throws InvalidOperationException, NullPointerException {
        return this._years;
    }

    @Override
    public int getMonths() throws InvalidOperationException, NullPointerException {
        return this._months;
    }

    public String toString() {
        return "INTERVAL '" + this._years + "-" + this._months + "' " + this.getType();
    }
}

