/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.Field;
import org.partiql.spi.value.InvalidOperationException;

class DatumNull
implements Datum {
    @NotNull
    private final PType _type;

    DatumNull() {
        this._type = PType.unknown();
    }

    DatumNull(@NotNull PType type) {
        this._type = type;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    @NotNull
    public PType getType() {
        return this._type;
    }

    @Override
    public boolean getBoolean() {
        if (this._type.code() == 1) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getBoolean");
    }

    @Override
    public short getShort() {
        if (this._type.code() == 3) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getShort");
    }

    @Override
    public int getInt() {
        if (this._type.code() == 4) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getInt");
    }

    @Override
    public long getLong() {
        if (this._type.code() == 5) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getLong");
    }

    @Override
    @NotNull
    public BigDecimal getBigDecimal() {
        if (this._type.code() == 7 || this._type.code() == 6) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getBigDecimal");
    }

    @Override
    public byte getByte() {
        if (this._type.code() == 2) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getByte");
    }

    @Override
    @NotNull
    public byte[] getBytes() {
        if (this._type.code() == 13 || this._type.code() == 14) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getBytes");
    }

    @Override
    public double getDouble() {
        if (this._type.code() == 9) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getDouble");
    }

    @Override
    public float getFloat() {
        if (this._type.code() == 8) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getFloat");
    }

    @Override
    @NotNull
    public Iterator<Datum> iterator() {
        if (this._type.code() == 21 || this._type.code() == 20) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "iterator");
    }

    @Override
    @NotNull
    public Iterator<Field> getFields() {
        if (this._type.code() == 23 || this._type.code() == 22) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getFields");
    }

    @Override
    @NotNull
    public String getString() {
        if (this._type.code() == 12 || this._type.code() == 10) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getString");
    }

    @Override
    @NotNull
    public LocalDate getLocalDate() {
        switch (this._type.code()) {
            case 15: 
            case 18: 
            case 19: {
                throw new NullPointerException();
            }
        }
        throw new InvalidOperationException(this.getType(), "getLocalDate");
    }

    @Override
    @NotNull
    public LocalTime getLocalTime() {
        switch (this._type.code()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                throw new NullPointerException();
            }
        }
        throw new InvalidOperationException(this.getType(), "getLocalTime");
    }

    @Override
    @NotNull
    public OffsetTime getOffsetTime() {
        switch (this._type.code()) {
            case 17: 
            case 19: {
                throw new NullPointerException();
            }
        }
        throw new InvalidOperationException(this.getType(), "getOffsetTime");
    }

    @Override
    @NotNull
    public LocalDateTime getLocalDateTime() {
        switch (this._type.code()) {
            case 18: 
            case 19: {
                throw new NullPointerException();
            }
        }
        throw new InvalidOperationException(this.getType(), "getLocalDateTime");
    }

    @Override
    @NotNull
    public OffsetDateTime getOffsetDateTime() {
        if (this._type.code() == 19) {
            throw new NullPointerException();
        }
        throw new InvalidOperationException(this.getType(), "getOffsetDateTime");
    }
}

