/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.spi.internal.value.ion.IonDatumReader;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.Encoding;

public interface DatumReader
extends AutoCloseable {
    @Nullable
    public Datum next();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public static DatumReader ion(InputStream input) {
        return new IonDatumReader(input, new HashMap());
    }

    public static class Builder {
        private Encoding encoding;
        private final Map<Encoding, DatumReader> others = new HashMap<Encoding, DatumReader>();

        public Builder encoding(Encoding encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder register(Encoding encoding, DatumReader reader) {
            this.others.put(encoding, reader);
            return this;
        }

        public DatumReader build(InputStream input) {
            if (this.encoding == null) {
                throw new IllegalArgumentException("encoding cannot be null, set with .encoding(..)");
            }
            switch (this.encoding.code()) {
                case 1: {
                    return new IonDatumReader(input, this.others);
                }
            }
            throw new IllegalArgumentException("no reader for encoding: " + this.encoding);
        }
    }
}

