/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;
import org.partiql.spi.value.Field;

class DatumStruct
implements Datum {
    @NotNull
    private final HashMap<String, List<Datum>> _delegate = new HashMap();
    @NotNull
    private final HashMap<String, List<Datum>> _delegateNormalized = new HashMap();
    private static final PType _type = PType.struct();

    DatumStruct(@NotNull Iterable<Field> fields) {
        for (Field field : fields) {
            String key = field.getName();
            String keyNormalized = field.getName().toLowerCase();
            Datum value = field.getValue();
            this.addFieldToStruct(this._delegate, key, value);
            this.addFieldToStruct(this._delegateNormalized, keyNormalized, value);
        }
    }

    private void addFieldToStruct(Map<String, List<Datum>> struct, String key, Datum value) {
        List values = struct.getOrDefault(key, new ArrayList());
        values.add(value);
        struct.put(key, values);
    }

    @Override
    @NotNull
    public Iterator<Field> getFields() {
        return this._delegate.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> Field.of((String)entry.getKey(), value))).iterator();
    }

    @Override
    public Datum get(@NotNull String name) {
        List<Datum> values = this._delegate.get(name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public Datum getInsensitive(@NotNull String name) {
        List<Datum> values = this._delegateNormalized.get(name.toLowerCase());
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    @NotNull
    public PType getType() {
        return _type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("struct::{ ");
        for (Map.Entry<String, List<Datum>> entry : this._delegate.entrySet()) {
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().toString());
            sb.append(", ");
        }
        sb.append(" }");
        return sb.toString();
    }
}

