/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.spi.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.jetbrains.annotations.NotNull;
import org.partiql.spi.types.PType;
import org.partiql.spi.value.Datum;

final class DatumTimestamp
implements Datum {
    @NotNull
    private final PType type;
    @NotNull
    private final LocalDateTime value;

    DatumTimestamp(@NotNull LocalDateTime value, int precision) {
        this.type = PType.timestamp(precision);
        this.value = value;
    }

    @Override
    @NotNull
    public PType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public LocalDate getLocalDate() {
        return this.value.toLocalDate();
    }

    @Override
    @NotNull
    public LocalTime getLocalTime() {
        return this.value.toLocalTime();
    }

    @Override
    @NotNull
    public OffsetTime getOffsetTime() {
        return this.value.atOffset(ZoneOffset.UTC).toOffsetTime();
    }

    @Override
    @NotNull
    public LocalDateTime getLocalDateTime() {
        return this.value;
    }

    @Override
    @NotNull
    public OffsetDateTime getOffsetDateTime() {
        return this.value.atOffset(ZoneOffset.UTC);
    }

    public String toString() {
        return this.value.toString();
    }
}

