/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.japa.parser;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;

public class AnnotationExprParser {
    public List<AnnotationExpr> parse(String text) throws ParseException {
        Objects.requireNonNull(text);
        String classText = text + "\npublic class Dummy{}";
        StringReader reader = new StringReader(classText);
        CompilationUnit compilationUnit = JavaParser.parse((Reader)reader, (boolean)true);
        List typeDeclarations = compilationUnit.getTypes();
        if (typeDeclarations.size() > 1) {
            throw new ParseException(MessageFormat.format("Annotation [{0}] could not be parsed, it contains an unexpected type declaration.", text));
        }
        TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
        if (!(typeDeclaration instanceof ClassOrInterfaceDeclaration)) {
            throw new ParseException(MessageFormat.format("Expected [{0}] as type declaration.", ClassOrInterfaceDeclaration.class.getName()));
        }
        ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)typeDeclaration;
        if (!"Dummy".equals(classDeclaration.getName())) {
            throw new ParseException(MessageFormat.format("Expected [{0}] as type declaration.", "Dummy"));
        }
        List annotations = typeDeclaration.getAnnotations();
        if (annotations == null || annotations.isEmpty()) {
            throw new ParseException(MessageFormat.format("Annotation [{0}] could not be parsed, it does not seem to contain an annotation declaration.", text));
        }
        return annotations;
    }
}

