/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.jvnet.basicjaxb_annox.model.XAnnotation;
import org.jvnet.basicjaxb_annox.model.XMember;
import org.jvnet.basicjaxb_annox.model.XParameter;
import org.jvnet.basicjaxb_annox.reflect.ParameterizedAnnotatedElement;

public class XMethod
extends XMember<Method>
implements ParameterizedAnnotatedElement {
    public static final XMethod[] EMPTY_ARRAY = new XMethod[0];
    private final XParameter[] parameters;

    public XMethod(Method method, XAnnotation<?>[] xannotations, XParameter[] parameters) {
        super(method, xannotations);
        Validate.noNullElements((Object[])parameters);
        this.parameters = parameters;
        this.check();
    }

    public XParameter[] getParameters() {
        return this.parameters;
    }

    private void check() {
        Class<?>[] parameterTypes;
        Method method = this.getMethod();
        XParameter[] parameters = this.getParameters();
        Validate.isTrue((parameters.length == (parameterTypes = method.getParameterTypes()).length ? 1 : 0) != 0, (String)("Wrong number of parameters: [" + parameters.length + "], expected [" + parameterTypes.length + "]."), (Object[])new Object[0]);
        for (int index = 0; index < parameters.length; ++index) {
            XParameter parameter = parameters[index];
            Class<?> parameterType = parameterTypes[index];
            Validate.isTrue((boolean)parameterType.equals(parameter.getType()), (String)("Wrong parameter type: [" + String.valueOf(parameter.getType()) + "], expected [" + String.valueOf(parameterType) + "]"), (Object[])new Object[0]);
        }
    }

    public Method getMethod() {
        return (Method)this.getMember();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        XParameter[] xparameters = this.getParameters();
        Annotation[][] parameterAnnotations = new Annotation[xparameters.length][];
        for (int index = 0; index < xparameters.length; ++index) {
            parameterAnnotations[index] = xparameters[index].getAnnotations();
        }
        return parameterAnnotations;
    }
}

