/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.model.annotation.field;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.jvnet.basicjaxb_annox.model.XAnnotationFieldVisitor;
import org.jvnet.basicjaxb_annox.model.annotation.field.XAnnotationField;
import org.jvnet.basicjaxb_annox.model.annotation.value.XAnnotationValue;
import org.jvnet.basicjaxb_annox.util.ClassUtils;

public class XArrayAnnotationField<T>
extends XAnnotationField<T[]> {
    private final Class<?> type;
    private final Class<?> componentType;
    private final Class<?> wrapperComponentType;
    private final XAnnotationValue<T>[] annotationValues;

    @SafeVarargs
    public XArrayAnnotationField(String name, Class<?> type, XAnnotationValue<T> ... values) {
        super(name);
        if (!type.isArray()) {
            throw new IllegalArgumentException(MessageFormat.format("Type [{0}] is expected to be an array type.", type));
        }
        type = ClassUtils.wrapperArrayToPrimitiveArray(type);
        this.annotationValues = (XAnnotationValue[])Validate.noNullElements((Object[])values);
        this.type = type;
        this.componentType = type.getComponentType();
        this.wrapperComponentType = ClassUtils.primitiveToWrapper(this.componentType);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public XAnnotationValue<T>[] getAnnotationValues() {
        return this.annotationValues;
    }

    @Override
    public T[] getValue() {
        Object array = Array.newInstance(this.wrapperComponentType, this.annotationValues.length);
        Object[] value = (Object[])array;
        for (int index = 0; index < this.annotationValues.length; ++index) {
            T singleValue = this.annotationValues[index].getValue();
            value[index] = singleValue;
        }
        return value;
    }

    @Override
    public Object getResult() {
        Object array = Array.newInstance(this.componentType, this.annotationValues.length);
        for (int index = 0; index < this.annotationValues.length; ++index) {
            Array.set(array, index, this.annotationValues[index].getValue());
        }
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("=[");
        XAnnotationValue<T>[] values = this.getAnnotationValues();
        for (int index = 0; index < values.length; ++index) {
            XAnnotationValue<T> value = values[index];
            if (index > 0) {
                sb.append(", ");
            }
            sb.append(value.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 0;
        String name = this.getName();
        hash = hash * 37 + name.hashCode();
        XAnnotationValue<T>[] values = this.getAnnotationValues();
        for (int index = 0; index < values.length; ++index) {
            XAnnotationValue<T> v = values[index];
            hash = hash * 37 + v.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        XAnnotationValue<T>[] rhs;
        if (!(obj instanceof XArrayAnnotationField)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        XArrayAnnotationField other = (XArrayAnnotationField)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        XAnnotationValue<T>[] lhs = this.getAnnotationValues();
        if (lhs == (rhs = other.getAnnotationValues())) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i].equals(rhs[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public <P> P accept(XAnnotationFieldVisitor<P> visitor) {
        return visitor.visitArrayAnnotationField(this);
    }
}

