/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.parser;

import japa.parser.ast.Node;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayInitializerExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.visitor.GenericVisitor;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.List;
import org.jvnet.basicjaxb_annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.basicjaxb_annox.japa.parser.ast.visitor.AbstractGenericExpressionVisitor;
import org.jvnet.basicjaxb_annox.model.XAnnotation;
import org.jvnet.basicjaxb_annox.model.annotation.field.XAnnotationField;
import org.jvnet.basicjaxb_annox.model.annotation.field.XArrayAnnotationField;
import org.jvnet.basicjaxb_annox.model.annotation.value.XAnnotationValue;
import org.jvnet.basicjaxb_annox.model.annotation.value.XXAnnotationAnnotationValue;
import org.jvnet.basicjaxb_annox.parser.XAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.XAnnotationParser;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationElementParseException;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.basicjaxb_annox.util.AnnotationElementUtils;
import org.w3c.dom.Element;

public class XAnnotationArrayAnnotationFieldParser<A extends Annotation>
extends XAnnotationFieldParser<A[], A[]> {
    @Override
    public XAnnotationField<A[]> parse(Element annotationElement, String name, Class<?> type) throws AnnotationElementParseException {
        Element[] elements = AnnotationElementUtils.getFieldElements(annotationElement, name);
        XAnnotation[] xannotations = new XAnnotation[elements.length];
        for (int index = 0; index < elements.length; ++index) {
            try {
                XAnnotation<?> annotation;
                xannotations[index] = annotation = XAnnotationParser.INSTANCE.parse(elements[index]);
                continue;
            }
            catch (AnnotationElementParseException aepex) {
                throw new AnnotationElementParseException(annotationElement, (Throwable)aepex);
            }
        }
        return this.construct(name, xannotations, type);
    }

    @Override
    public XAnnotationField<A[]> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
        Annotation[] value = (Annotation[])this.getAnnotationFieldValue(annotation, name);
        XAnnotation[] xannotations = new XAnnotation[value.length];
        for (int index = 0; index < value.length; ++index) {
            XAnnotation<?> xannotation;
            xannotations[index] = xannotation = XAnnotationParser.INSTANCE.parse(value[index]);
        }
        return this.construct(name, xannotations, type);
    }

    @Override
    public XAnnotationField<A[]> parse(Expression expression, String name, Class<?> type) throws AnnotationExpressionParseException {
        Expression[] items = (Expression[])expression.accept((GenericVisitor)new AbstractGenericExpressionVisitor<Expression[], Void>(){

            @Override
            public Expression[] visit(ArrayInitializerExpr n, Void arg) {
                List values = n.getValues();
                return values.toArray(new Expression[values.size()]);
            }

            @Override
            public Expression[] visitDefault(Expression n, Void arg) {
                return new Expression[]{n};
            }

            @Override
            public Expression[] visitDefault(Node n, Void arg) {
                throw new IllegalArgumentException(MessageFormat.format("Unexpected expression [{0}], only array initializer expressions are expected.", n));
            }
        }, null);
        XAnnotation[] xannotations = new XAnnotation[items.length];
        for (int index = 0; index < items.length; ++index) {
            XAnnotation<?> annotation;
            Expression item = items[index];
            AnnotationExpr annotationExpression = (AnnotationExpr)item.accept((GenericVisitor)new AbstractGenericExpressionVisitor<AnnotationExpr, Void>(){

                @Override
                public AnnotationExpr visitDefault(Node n, Void arg) {
                    throw new IllegalArgumentException(MessageFormat.format("Unexpected expression [{0}], only annotation expressions are expected.", n));
                }

                @Override
                public AnnotationExpr visitDefault(AnnotationExpr n, Void arg) {
                    return n;
                }
            }, null);
            xannotations[index] = annotation = XAnnotationParser.INSTANCE.parse(annotationExpression);
        }
        return this.construct(name, xannotations, type);
    }

    @Override
    public XAnnotationField<A[]> construct(String name, A[] annotations, Class<?> type) {
        XAnnotation[] xannotations = new XAnnotation[annotations.length];
        XAnnotationValue[] xannotationValues = new XAnnotationValue[annotations.length];
        for (int index = 0; index < annotations.length; ++index) {
            XAnnotation<?> xannotation;
            xannotations[index] = xannotation = XAnnotationParser.INSTANCE.parse((Annotation)annotations[index]);
            xannotationValues[index] = new XXAnnotationAnnotationValue<A>(annotations[index], xannotations[index]);
        }
        return new XArrayAnnotationField(name, type, xannotationValues);
    }

    @Override
    private XAnnotationField<A[]> construct(String name, XAnnotation<A>[] xannotations, Class<?> type) {
        XAnnotationValue[] xannotationValues = new XAnnotationValue[xannotations.length];
        for (int index = 0; index < xannotations.length; ++index) {
            xannotationValues[index] = new XXAnnotationAnnotationValue<A>(xannotations[index]);
        }
        return new XArrayAnnotationField(name, type, xannotationValues);
    }
}

