/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.parser;

import japa.parser.ast.expr.Expression;
import java.lang.annotation.Annotation;
import org.jvnet.basicjaxb_annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.basicjaxb_annox.model.annotation.field.XAnnotationField;
import org.jvnet.basicjaxb_annox.parser.XAnnotationArrayAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.XAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.XAnnotationSingleAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.XArrayAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.XSingleAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationElementParseException;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.basicjaxb_annox.parser.value.XBooleanAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XByteAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XCharAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XClassAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XDoubleAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XEnumAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XFloatAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XIntAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XLongAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XShortAnnotationValueParser;
import org.jvnet.basicjaxb_annox.parser.value.XStringAnnotationValueParser;
import org.w3c.dom.Element;

public class XGenericFieldParser<T, V>
extends XAnnotationFieldParser<T, V> {
    public static final XAnnotationFieldParser<Boolean, Boolean> BOOLEAN = new XSingleAnnotationFieldParser<Boolean, Boolean>(new XBooleanAnnotationValueParser());
    public static final XAnnotationFieldParser<Byte, Byte> BYTE = new XSingleAnnotationFieldParser<Byte, Byte>(new XByteAnnotationValueParser());
    public static final XAnnotationFieldParser<Integer, Integer> INT = new XSingleAnnotationFieldParser<Integer, Integer>(new XIntAnnotationValueParser());
    public static final XAnnotationFieldParser<Long, Long> LONG = new XSingleAnnotationFieldParser<Long, Long>(new XLongAnnotationValueParser());
    public static final XAnnotationFieldParser<Short, Short> SHORT = new XSingleAnnotationFieldParser<Short, Short>(new XShortAnnotationValueParser());
    public static final XAnnotationFieldParser<Character, Character> CHAR = new XSingleAnnotationFieldParser<Character, Character>(new XCharAnnotationValueParser());
    public static final XAnnotationFieldParser<Class<?>, Class<?>> CLASS = new XSingleAnnotationFieldParser(new XClassAnnotationValueParser());
    public static final XAnnotationFieldParser<Double, Double> DOUBLE = new XSingleAnnotationFieldParser<Double, Double>(new XDoubleAnnotationValueParser());
    public static final XAnnotationFieldParser<Float, Float> FLOAT = new XSingleAnnotationFieldParser<Float, Float>(new XFloatAnnotationValueParser());
    public static final XAnnotationFieldParser<Enum<?>, Enum<?>> ENUM = new XSingleAnnotationFieldParser(new XEnumAnnotationValueParser());
    public static final XAnnotationFieldParser<String, String> STRING = new XSingleAnnotationFieldParser<String, String>(new XStringAnnotationValueParser());
    public static final XAnnotationFieldParser<?, ?> ANNOTATION = new XAnnotationSingleAnnotationFieldParser();
    public static final XAnnotationFieldParser<Boolean[], Boolean[]> BOOLEAN_ARRAY = new XArrayAnnotationFieldParser<Boolean, Boolean>(new XBooleanAnnotationValueParser());
    public static final XAnnotationFieldParser<Byte[], Byte[]> BYTE_ARRAY = new XArrayAnnotationFieldParser<Byte, Byte>(new XByteAnnotationValueParser());
    public static final XAnnotationFieldParser<Integer[], Integer[]> INT_ARRAY = new XArrayAnnotationFieldParser<Integer, Integer>(new XIntAnnotationValueParser());
    public static final XAnnotationFieldParser<Long[], Long[]> LONG_ARRAY = new XArrayAnnotationFieldParser<Long, Long>(new XLongAnnotationValueParser());
    public static final XAnnotationFieldParser<Short[], Short[]> SHORT_ARRAY = new XArrayAnnotationFieldParser<Short, Short>(new XShortAnnotationValueParser());
    public static final XAnnotationFieldParser<Character[], Character[]> CHAR_ARRAY = new XArrayAnnotationFieldParser<Character, Character>(new XCharAnnotationValueParser());
    public static final XAnnotationFieldParser<Class<?>[], Class<?>[]> CLASS_ARRAY = new XArrayAnnotationFieldParser(new XClassAnnotationValueParser());
    public static final XAnnotationFieldParser<Double[], Double[]> DOUBLE_ARRAY = new XArrayAnnotationFieldParser<Double, Double>(new XDoubleAnnotationValueParser());
    public static final XAnnotationFieldParser<Float[], Float[]> FLOAT_ARRAY = new XArrayAnnotationFieldParser<Float, Float>(new XFloatAnnotationValueParser());
    public static final XAnnotationFieldParser<Enum<?>[], Enum<?>[]> ENUM_ARRAY = new XArrayAnnotationFieldParser(new XEnumAnnotationValueParser());
    public static final XAnnotationFieldParser<String[], String[]> STRING_ARRAY = new XArrayAnnotationFieldParser<String, String>(new XStringAnnotationValueParser());
    public static final XAnnotationArrayAnnotationFieldParser ANNOTATION_ARRAY = new XAnnotationArrayAnnotationFieldParser();
    public static final XGenericFieldParser GENERIC = new XGenericFieldParser();

    @Override
    public XAnnotationField<T> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
        XAnnotationFieldParser<?, ?> parser = XGenericFieldParser.detectType(type);
        return parser.parse(element, name, type);
    }

    @Override
    public XAnnotationField<T> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
        XAnnotationFieldParser<?, ?> parser = XGenericFieldParser.detectType(type);
        return parser.parse(annotation, name, type);
    }

    @Override
    public XAnnotationField<T> construct(String name, V value, Class<?> type) {
        XAnnotationFieldParser<?, ?> parser = XGenericFieldParser.detectType(type);
        return parser.construct(name, value, type);
    }

    @Override
    public XAnnotationField<T> parse(Expression expression, String name, Class<?> type) throws AnnotationExpressionParseException {
        XAnnotationFieldParser<?, ?> parser = XGenericFieldParser.detectType(type);
        return parser.parse(expression, name, type);
    }

    public static <T, V> XAnnotationFieldParser<T, V> generic() {
        XGenericFieldParser parser = GENERIC;
        return parser;
    }

    public static XAnnotationFieldParser<?, ?> detectType(Class<?> theClass) {
        if (theClass == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        if (theClass.isArray()) {
            XAnnotationFieldParser<?, ?> componentType = XGenericFieldParser.detectType(theClass.getComponentType());
            if (componentType == BOOLEAN) {
                return BOOLEAN_ARRAY;
            }
            if (componentType == BYTE) {
                return BYTE_ARRAY;
            }
            if (componentType == INT) {
                return INT_ARRAY;
            }
            if (componentType == LONG) {
                return LONG_ARRAY;
            }
            if (componentType == SHORT) {
                return SHORT_ARRAY;
            }
            if (componentType == CHAR) {
                return CHAR_ARRAY;
            }
            if (componentType == CLASS) {
                return CLASS_ARRAY;
            }
            if (componentType == DOUBLE) {
                return DOUBLE_ARRAY;
            }
            if (componentType == FLOAT) {
                return FLOAT_ARRAY;
            }
            if (componentType == ENUM) {
                return ENUM_ARRAY;
            }
            if (componentType == STRING) {
                return STRING_ARRAY;
            }
            if (componentType == ANNOTATION) {
                return ANNOTATION_ARRAY;
            }
            throw new IllegalArgumentException("Unknown annotation field type.");
        }
        if (Boolean.class.equals(theClass) || Boolean.TYPE.equals(theClass)) {
            return BOOLEAN;
        }
        if (Byte.class.equals(theClass) || Byte.TYPE.equals(theClass)) {
            return BYTE;
        }
        if (Integer.class.equals(theClass) || Integer.TYPE.equals(theClass)) {
            return INT;
        }
        if (Long.class.equals(theClass) || Long.TYPE.equals(theClass)) {
            return LONG;
        }
        if (Short.class.equals(theClass) || Short.TYPE.equals(theClass)) {
            return SHORT;
        }
        if (Character.class.equals(theClass) || Character.TYPE.equals(theClass)) {
            return CHAR;
        }
        if (Double.class.equals(theClass) || Double.TYPE.equals(theClass)) {
            return DOUBLE;
        }
        if (Float.class.equals(theClass) || Float.TYPE.equals(theClass)) {
            return FLOAT;
        }
        if (Class.class.equals(theClass)) {
            return CLASS;
        }
        if (String.class.equals(theClass)) {
            return STRING;
        }
        if (Enum.class.isAssignableFrom(theClass)) {
            return ENUM;
        }
        if (Annotation.class.isAssignableFrom(theClass)) {
            return ANNOTATION;
        }
        throw new IllegalArgumentException("Unknown annotation field type [" + theClass.getName() + "].");
    }
}

