/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.parser;

import japa.parser.ast.Node;
import japa.parser.ast.expr.Expression;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.jvnet.basicjaxb_annox.annotation.NoSuchAnnotationFieldException;
import org.jvnet.basicjaxb_annox.model.annotation.field.XAnnotationField;
import org.jvnet.basicjaxb_annox.model.annotation.field.XSingleAnnotationField;
import org.jvnet.basicjaxb_annox.model.annotation.value.XAnnotationValue;
import org.jvnet.basicjaxb_annox.parser.XAnnotationFieldParser;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationElementParseException;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.basicjaxb_annox.parser.exception.ValueParseException;
import org.jvnet.basicjaxb_annox.parser.java.visitor.ExpressionVisitor;
import org.jvnet.basicjaxb_annox.parser.value.XAnnotationValueParser;
import org.jvnet.basicjaxb_annox.util.AnnotationElementUtils;
import org.w3c.dom.Element;

public class XSingleAnnotationFieldParser<T, V>
extends XAnnotationFieldParser<T, V> {
    private final XAnnotationValueParser<T, V> annotationValueParser;

    public XSingleAnnotationFieldParser(XAnnotationValueParser<T, V> annotationValueParser) {
        Objects.requireNonNull(annotationValueParser);
        this.annotationValueParser = annotationValueParser;
    }

    @Override
    public XAnnotationField<T> parse(Element element, String name, Class<?> type) throws AnnotationElementParseException {
        Objects.requireNonNull(element, "Element must not be null.");
        Objects.requireNonNull(name, "Field name must not be null.");
        Objects.requireNonNull(type, "Type must not be null.");
        String draft = AnnotationElementUtils.getFieldValue(element, name);
        if (draft == null) {
            return null;
        }
        try {
            XAnnotationValue<T> value = this.annotationValueParser.parse(draft, type);
            return new XSingleAnnotationField<T>(name, type, value);
        }
        catch (ValueParseException vpex) {
            throw new AnnotationElementParseException(element, (Throwable)vpex);
        }
    }

    @Override
    public XAnnotationField<T> parse(Annotation annotation, String name, Class<?> type) throws NoSuchAnnotationFieldException {
        Object value = this.getAnnotationFieldValue(annotation, name);
        return this.construct(name, value, type);
    }

    @Override
    public final XAnnotationField<T> construct(String name, V value, Class<?> type) {
        XAnnotationValue<T> fieldValue = this.annotationValueParser.construct(value, type);
        return new XSingleAnnotationField<T>(name, type, fieldValue);
    }

    @Override
    public XAnnotationField<T> parse(Expression expression, String name, Class<?> type) throws AnnotationExpressionParseException {
        ExpressionVisitor<XAnnotationValue<T>> expressionVisitor = this.annotationValueParser.createExpressionVisitor(type);
        try {
            XAnnotationValue value = (XAnnotationValue)expression.accept(expressionVisitor, null);
            return new XSingleAnnotationField(name, type, value);
        }
        catch (RuntimeException rex) {
            if (rex.getCause() != null) {
                throw new AnnotationExpressionParseException((Node)expression, rex.getCause());
            }
            throw new AnnotationExpressionParseException((Node)expression, (Throwable)rex);
        }
    }
}

