/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.parser.java.visitor;

import japa.parser.ast.expr.ClassExpr;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import japa.parser.ast.type.WildcardType;
import japa.parser.ast.visitor.GenericVisitor;
import java.lang.reflect.Array;
import org.jvnet.basicjaxb_annox.model.annotation.value.AbstractBasicXAnnotationValueVisitor;
import org.jvnet.basicjaxb_annox.model.annotation.value.XAnnotationValue;
import org.jvnet.basicjaxb_annox.model.annotation.value.XArrayClassAnnotationValue;
import org.jvnet.basicjaxb_annox.model.annotation.value.XClassAnnotationValue;
import org.jvnet.basicjaxb_annox.model.annotation.value.XClassByNameAnnotationValue;
import org.jvnet.basicjaxb_annox.parser.java.visitor.ExpressionVisitor;

public final class ClassExpressionVisitor
extends ExpressionVisitor<XAnnotationValue<Class<?>>> {
    public ClassExpressionVisitor(Class<?> targetClass) {
        super(targetClass);
    }

    @Override
    public XAnnotationValue<Class<?>> visit(ClassExpr n, Void arg) {
        return (XAnnotationValue)n.getType().accept((GenericVisitor)new ExpressionVisitor<XAnnotationValue<Class<?>>>(this.targetClass){

            @Override
            public XAnnotationValue<Class<?>> visit(ClassOrInterfaceType n, Void arg) {
                String className = n.toString();
                try {
                    XClassAnnotationValue classAnnotationValue = new XClassAnnotationValue(Class.forName(className));
                    return classAnnotationValue;
                }
                catch (ClassNotFoundException cnfex) {
                    XClassByNameAnnotationValue classByNameAnnotationValue = new XClassByNameAnnotationValue(className);
                    return classByNameAnnotationValue;
                }
            }

            @Override
            public XAnnotationValue<Class<?>> visit(ReferenceType n, Void arg) {
                Type type = n.getType();
                XAnnotationValue t = (XAnnotationValue)type.accept((GenericVisitor)this, (Object)arg);
                final int arrayCount = n.getArrayCount();
                if (arrayCount == 0) {
                    return t;
                }
                return (XAnnotationValue)t.accept(new AbstractBasicXAnnotationValueVisitor<XAnnotationValue<Class<?>>>(){

                    @Override
                    public XAnnotationValue<Class<?>> visitDefault(XAnnotationValue<?> value) {
                        throw new IllegalArgumentException();
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XArrayClassAnnotationValue<?, ?> value) {
                        XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value.getItemClassByNameAnnotationValue(), value.getDimension() + arrayCount);
                        return arrayClassAnnotationValue;
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XClassAnnotationValue<?> value) {
                        Class<?> _class = (Class<?>)value.getValue();
                        for (int index = 0; index < arrayCount; ++index) {
                            _class = Array.newInstance(_class, 0).getClass();
                        }
                        XClassAnnotationValue classAnnotationValue = new XClassAnnotationValue(_class);
                        return classAnnotationValue;
                    }

                    @Override
                    public XAnnotationValue<Class<?>> visit(XClassByNameAnnotationValue<?> value) {
                        XArrayClassAnnotationValue arrayClassAnnotationValue = new XArrayClassAnnotationValue(value, arrayCount);
                        return arrayClassAnnotationValue;
                    }
                });
            }

            @Override
            public XAnnotationValue<Class<?>> visit(VoidType n, Void arg) {
                return new XClassAnnotationValue<Void>(Void.class);
            }

            @Override
            public XAnnotationValue<Class<?>> visit(PrimitiveType n, Void arg) {
                switch (n.getType()) {
                    case Boolean: {
                        return new XClassAnnotationValue<Boolean>(Boolean.TYPE);
                    }
                    case Char: {
                        return new XClassAnnotationValue<Character>(Character.TYPE);
                    }
                    case Byte: {
                        return new XClassAnnotationValue<Byte>(Byte.TYPE);
                    }
                    case Short: {
                        return new XClassAnnotationValue<Short>(Short.TYPE);
                    }
                    case Int: {
                        return new XClassAnnotationValue<Integer>(Integer.TYPE);
                    }
                    case Long: {
                        return new XClassAnnotationValue<Long>(Long.TYPE);
                    }
                    case Double: {
                        return new XClassAnnotationValue<Double>(Double.TYPE);
                    }
                    case Float: {
                        return new XClassAnnotationValue<Float>(Float.TYPE);
                    }
                }
                throw new IllegalArgumentException();
            }

            @Override
            public XAnnotationValue<Class<?>> visit(WildcardType n, Void arg) {
                throw new UnsupportedOperationException("Wildcard types are not supported.");
            }
        }, null);
    }
}

