/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.reflect;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jvnet.basicjaxb_annox.reader.XReader;
import org.jvnet.basicjaxb_annox.reader.resourced.ResourcedXReader;
import org.jvnet.basicjaxb_annox.reflect.AnnotatedElementException;
import org.jvnet.basicjaxb_annox.reflect.AnnotatedElementFactory;
import org.jvnet.basicjaxb_annox.reflect.ParameterizedAnnotatedElement;

public class ResourcedAnnotatedElementFactory
implements AnnotatedElementFactory {
    private final XReader xreader;

    public ResourcedAnnotatedElementFactory(XReader xreader) {
        Objects.requireNonNull(xreader);
        this.xreader = xreader;
    }

    public ResourcedAnnotatedElementFactory() {
        this(new ResourcedXReader());
    }

    public XReader getXReader() {
        return this.xreader;
    }

    @Override
    public AnnotatedElement getAnnotatedElement(AnnotatedElement annotatedElement) throws AnnotatedElementException {
        Objects.requireNonNull(annotatedElement);
        if (annotatedElement instanceof Package) {
            return this.getXReader().getXPackage((Package)annotatedElement);
        }
        if (annotatedElement instanceof Class) {
            return this.getXReader().getXClass((Class)annotatedElement);
        }
        if (annotatedElement instanceof Field) {
            return this.getXReader().getXField((Field)annotatedElement);
        }
        if (annotatedElement instanceof Constructor) {
            return this.getXReader().getXConstructor((Constructor)annotatedElement);
        }
        if (annotatedElement instanceof Method) {
            return this.getXReader().getXMethod((Method)annotatedElement);
        }
        throw new AssertionError((Object)("Unexpected annotated element [" + String.valueOf(annotatedElement) + "]"));
    }

    public ParameterizedAnnotatedElement getAnnotatedElement(Constructor constructor) throws AnnotatedElementException {
        Objects.requireNonNull(constructor);
        return this.getXReader().getXConstructor(constructor);
    }

    @Override
    public ParameterizedAnnotatedElement getAnnotatedElement(Method method) throws AnnotatedElementException {
        Objects.requireNonNull(method);
        return this.getXReader().getXMethod(method);
    }
}

