/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jvnet.basicjaxb_annox.util.ClassUtils;

public class ReflectionUtils {
    public static Constructor<?> getConstructor(Class<?> theClass, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Objects.requireNonNull(theClass);
        if (parameterTypes == null) {
            try {
                return theClass.getDeclaredConstructor(ClassUtils.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<?> foundMethod = null;
                for (Constructor<?> method : theClass.getDeclaredConstructors()) {
                    if (foundMethod != null) {
                        throw new NoSuchMethodException("Duplicate constructors [" + String.valueOf(foundMethod) + "] and [" + String.valueOf(method) + "].");
                    }
                    foundMethod = method;
                }
                if (foundMethod != null) {
                    return foundMethod;
                }
                throw new NoSuchMethodException();
            }
        }
        return theClass.getDeclaredConstructor(parameterTypes);
    }

    public static Method getMethod(Class<?> theClass, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Objects.requireNonNull(theClass);
        Objects.requireNonNull(methodName);
        if (parameterTypes == null) {
            try {
                return theClass.getMethod(methodName, ClassUtils.EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Method foundMethod = null;
                for (Method method : theClass.getDeclaredMethods()) {
                    if (!methodName.equals(method.getName())) continue;
                    if (foundMethod == null) {
                        foundMethod = method;
                        continue;
                    }
                    throw new NoSuchMethodException("Duplicate methods [" + String.valueOf(foundMethod) + "] and [" + String.valueOf(method) + "].");
                }
                if (foundMethod != null) {
                    return foundMethod;
                }
                throw new NoSuchMethodException();
            }
        }
        return theClass.getDeclaredMethod(methodName, parameterTypes);
    }

    public static Field getField(Class<?> theClass, String fieldName) throws NoSuchFieldException {
        return theClass.getDeclaredField(fieldName);
    }
}

