/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb_annox.xml.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.glassfish.jaxb.core.v2.model.annotation.Locatable;
import org.glassfish.jaxb.core.v2.runtime.IllegalAnnotationException;
import org.glassfish.jaxb.runtime.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import org.glassfish.jaxb.runtime.v2.model.annotation.LocatableAnnotation;
import org.glassfish.jaxb.runtime.v2.model.annotation.RuntimeAnnotationReader;
import org.jvnet.basicjaxb_annox.reflect.AnnotatedElementException;
import org.jvnet.basicjaxb_annox.reflect.AnnotatedElementFactory;
import org.jvnet.basicjaxb_annox.reflect.DualAnnotatedElementFactory;
import org.jvnet.basicjaxb_annox.reflect.MethodAnnotatedElement;
import org.jvnet.basicjaxb_annox.reflect.ParameterizedAnnotatedElement;
import org.jvnet.basicjaxb_annox.xml.bind.LocatableUtils;

public class AnnoxAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private AnnotatedElementFactory annotatedElementFactory;
    private final Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache = new HashMap<Class<? extends Annotation>, Map<Package, Annotation>>();

    public AnnoxAnnotationReader() {
        this(new DualAnnotatedElementFactory());
    }

    public AnnoxAnnotationReader(AnnotatedElementFactory annotatedElementFactory) {
        this.annotatedElementFactory = annotatedElementFactory;
    }

    public AnnotatedElementFactory getAnnotatedElementFactory() {
        return this.annotatedElementFactory;
    }

    protected String illegalAnnotationMsg(AnnotatedElementException aex, String loadMsg) {
        String msg1 = aex.getClass().getSimpleName() + ": " + aex.getMessage();
        Throwable rc = ExceptionUtils.getRootCause((Throwable)aex);
        String msg2 = rc.getClass().getSimpleName() + ": " + rc.getMessage();
        return msg1 + "; " + msg2 + "; " + loadMsg;
    }

    protected AnnotatedElement getAnnotatedElement(Field field) {
        try {
            return this.getAnnotatedElementFactory().getAnnotatedElement(field);
        }
        catch (AnnotatedElementException aex) {
            String msg = this.illegalAnnotationMsg(aex, "Loading field [" + field.getName() + "].");
            this.getErrorHandler().error(new IllegalAnnotationException(msg, (Throwable)aex, LocatableUtils.getLocatable(field)));
            return field;
        }
    }

    protected ParameterizedAnnotatedElement getAnnotatedElement(Method theMethod) {
        try {
            return this.getAnnotatedElementFactory().getAnnotatedElement(theMethod);
        }
        catch (AnnotatedElementException aex) {
            String msg = this.illegalAnnotationMsg(aex, "Loading method [" + theMethod.getName() + "].");
            this.getErrorHandler().error(new IllegalAnnotationException(msg, (Throwable)aex, LocatableUtils.getLocatable(theMethod)));
            return new MethodAnnotatedElement(theMethod);
        }
    }

    protected AnnotatedElement getAnnotatedElement(Class theClass) {
        try {
            return this.getAnnotatedElementFactory().getAnnotatedElement(theClass);
        }
        catch (AnnotatedElementException aex) {
            String msg = this.illegalAnnotationMsg(aex, "Loading class [" + theClass.getName() + "].");
            this.getErrorHandler().error(new IllegalAnnotationException(msg, (Throwable)aex, LocatableUtils.getLocatable(theClass)));
            return theClass;
        }
    }

    protected AnnotatedElement getAnnotatedElement(Package thePackage) {
        try {
            return this.getAnnotatedElementFactory().getAnnotatedElement(thePackage);
        }
        catch (AnnotatedElementException aex) {
            String msg = this.illegalAnnotationMsg(aex, "Loading package [" + thePackage.getName() + "].");
            this.getErrorHandler().error(new IllegalAnnotationException(msg, (Throwable)aex, LocatableUtils.getLocatable(thePackage)));
            return thePackage;
        }
    }

    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation, Field field, Locatable srcPos) {
        AnnotatedElement annotatedElement = this.getAnnotatedElement(field);
        return (A)LocatableAnnotation.create(annotatedElement.getAnnotation(annotation), (Locatable)srcPos);
    }

    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field) {
        AnnotatedElement annotatedElement = this.getAnnotatedElement(field);
        return annotatedElement.isAnnotationPresent(annotationType);
    }

    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> annotationType) {
        AnnotatedElement annotatedElement = this.getAnnotatedElement(clazz);
        return annotatedElement.isAnnotationPresent(annotationType);
    }

    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        AnnotatedElement annotatedElement = this.getAnnotatedElement(field);
        Annotation[] r = annotatedElement.getAnnotations();
        for (int i = 0; i < r.length; ++i) {
            r[i] = LocatableAnnotation.create((Annotation)r[i], (Locatable)srcPos);
        }
        return r;
    }

    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation, Method method, Locatable srcPos) {
        ParameterizedAnnotatedElement annotatedElement = this.getAnnotatedElement(method);
        return (A)LocatableAnnotation.create(annotatedElement.getAnnotation(annotation), (Locatable)srcPos);
    }

    public boolean hasMethodAnnotation(Class<? extends Annotation> annotation, Method method) {
        ParameterizedAnnotatedElement annotatedElement = this.getAnnotatedElement(method);
        return annotatedElement.isAnnotationPresent(annotation);
    }

    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        ParameterizedAnnotatedElement annotatedElement = this.getAnnotatedElement(method);
        Annotation[] r = annotatedElement.getAnnotations();
        for (int i = 0; i < r.length; ++i) {
            r[i] = LocatableAnnotation.create((Annotation)r[i], (Locatable)srcPos);
        }
        return r;
    }

    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        Annotation[] pa;
        ParameterizedAnnotatedElement annotatedElement = this.getAnnotatedElement(method);
        for (Annotation a : pa = annotatedElement.getParameterAnnotations()[paramIndex]) {
            if (a.annotationType() != annotation) continue;
            Annotation typedA = a;
            return (A)LocatableAnnotation.create((Annotation)typedA, (Locatable)srcPos);
        }
        return null;
    }

    public <A extends Annotation> A getClassAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        AnnotatedElement annotatedElement = this.getAnnotatedElement(clazz);
        return (A)LocatableAnnotation.create(annotatedElement.getAnnotation(a), (Locatable)srcPos);
    }

    public Class getClassValue(Annotation a, String name) {
        try {
            return (Class)a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    public Class[] getClassArrayValue(Annotation a, String name) {
        try {
            return (Class[])a.annotationType().getMethod(name, new Class[0]).invoke((Object)a, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
    }

    protected String fullName(Method m) {
        return m.getDeclaringClass().getName() + "#" + m.getName();
    }

    public <A extends Annotation> A getPackageAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        Package p = clazz.getPackage();
        if (p == null) {
            return null;
        }
        AnnotatedElement annotatedElement = this.getAnnotatedElement(p);
        Map<Package, Annotation> cache = this.packageCache.get(a);
        if (cache == null) {
            cache = new HashMap<Package, Annotation>();
            this.packageCache.put(a, cache);
        }
        if (cache.containsKey(p)) {
            return (A)cache.get(p);
        }
        Annotation ann = LocatableAnnotation.create(annotatedElement.getAnnotation(a), (Locatable)srcPos);
        cache.put(p, ann);
        return (A)ann;
    }
}

