/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.codegenerator;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.codegenerator.Arguments;
import org.jvnet.basicjaxb.plugin.codegenerator.CodeGenerator;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.xml.sax.ErrorHandler;

public abstract class AbstractCodeGeneratorPlugin<A extends Arguments<A>>
extends AbstractParameterizablePlugin {
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private Ignoring ignoring = new CustomizedIgnoring(this.getSpecialIgnoredElementName(), Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    private CodeGenerator<A> codeGenerator;

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    protected abstract QName getSpecialIgnoredElementName();

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(this.getSpecialIgnoredElementName(), Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected CodeGenerator<A> getCodeGenerator() {
        if (this.codeGenerator == null) {
            throw new IllegalStateException("Code generator was not set yet.");
        }
        return this.codeGenerator;
    }

    protected abstract CodeGenerator<A> createCodeGenerator(JCodeModel var1);

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        this.codeGenerator = this.createCodeGenerator(outline.getCodeModel());
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        this.generate(classOutline, theClass);
    }

    protected abstract void generate(ClassOutline var1, JDefinedClass var2);
}

