/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simpleequals;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.ListIterator;
import org.apache.commons.lang3.Validate;
import org.jvnet.basicjaxb.plugin.codegenerator.Arguments;

public class EqualsArguments
implements Arguments<EqualsArguments> {
    private final JCodeModel codeModel;
    private final JVar leftValue;
    private final JExpression leftHasSetValue;
    private final JVar rightValue;
    private final JExpression rightHasSetValue;

    public EqualsArguments(JCodeModel codeModel, JVar leftValue, JExpression leftHasSetValue, JVar rightValue, JExpression rightHasSetValue) {
        this.codeModel = (JCodeModel)Validate.notNull((Object)codeModel);
        this.leftValue = (JVar)Validate.notNull((Object)leftValue);
        this.leftHasSetValue = (JExpression)Validate.notNull((Object)leftHasSetValue);
        this.rightValue = (JVar)Validate.notNull((Object)rightValue);
        this.rightHasSetValue = (JExpression)Validate.notNull((Object)rightHasSetValue);
    }

    private JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public JVar leftValue() {
        return this.leftValue;
    }

    public JExpression leftHasSetValue() {
        return this.leftHasSetValue;
    }

    public JVar rightValue() {
        return this.rightValue;
    }

    public JExpression rightHasSetValue() {
        return this.rightHasSetValue;
    }

    private EqualsArguments spawn(JVar leftValue, JExpression leftHasSetValue, JVar rightValue, JExpression rightHasSetValue) {
        return new EqualsArguments(this.getCodeModel(), leftValue, leftHasSetValue, rightValue, rightHasSetValue);
    }

    @Override
    public EqualsArguments property(JBlock block, String propertyName, String propertyMethod, JType declarablePropertyType, JType propertyType, Collection<JType> possiblePropertyTypes) {
        JVar leftPropertyValue = block.decl(8, declarablePropertyType, this.leftValue().name() + propertyName, (JExpression)this.leftValue().invoke(propertyMethod));
        JVar rightPropertyValue = block.decl(8, declarablePropertyType, this.rightValue().name() + propertyName, (JExpression)this.rightValue().invoke(propertyMethod));
        boolean isAlwaysSet = propertyType.isPrimitive();
        JExpression leftPropertyHasSetValue = isAlwaysSet ? JExpr.TRUE : leftPropertyValue.ne(JExpr._null());
        JExpression rightPropertyHasSetValue = isAlwaysSet ? JExpr.TRUE : rightPropertyValue.ne(JExpr._null());
        return this.spawn(leftPropertyValue, leftPropertyHasSetValue, rightPropertyValue, rightPropertyHasSetValue);
    }

    @Override
    public EqualsArguments iterator(JBlock block, JType elementType) {
        JVar leftListIterator = block.decl(8, (JType)this.getCodeModel().ref(ListIterator.class).narrow(elementType), this.leftValue().name() + "ListIterator", (JExpression)this.leftValue().invoke("listIterator"));
        JVar rightListIterator = block.decl(8, (JType)this.getCodeModel().ref(ListIterator.class).narrow(elementType), this.rightValue().name() + "ListIterator", (JExpression)this.rightValue().invoke("listIterator"));
        return this.spawn(rightListIterator, JExpr.TRUE, leftListIterator, JExpr.TRUE);
    }

    @Override
    public EqualsArguments element(JBlock subBlock, JType elementType) {
        JVar leftElementValue = subBlock.decl(8, elementType, this.leftValue().name() + "Element", (JExpression)this.leftValue().invoke("next"));
        JVar rightElementValue = subBlock.decl(8, elementType, this.rightValue().name() + "Element", (JExpression)this.rightValue().invoke("next"));
        boolean isElementAlwaysSet = elementType.isPrimitive();
        JExpression leftElementHasSetValue = isElementAlwaysSet ? JExpr.TRUE : leftElementValue.ne(JExpr._null());
        JExpression rightElementHasSetValue = isElementAlwaysSet ? JExpr.TRUE : rightElementValue.ne(JExpr._null());
        return this.spawn(leftElementValue, leftElementHasSetValue, rightElementValue, rightElementHasSetValue);
    }

    @Override
    public JExpression _instanceof(JType type) {
        return JOp.cand((JExpression)this.leftValue()._instanceof(type), (JExpression)this.rightValue()._instanceof(type));
    }

    @Override
    public EqualsArguments cast(String suffix, JBlock block, JType jaxbElementType, boolean suppressWarnings) {
        JVar castedLeftValue = block.decl(8, jaxbElementType, this.leftValue().name() + suffix, (JExpression)JExpr.cast((JType)jaxbElementType, (JExpression)this.leftValue()));
        if (suppressWarnings) {
            castedLeftValue.annotate(SuppressWarnings.class).param("value", "unchecked");
        }
        JVar castedRightValue = block.decl(8, jaxbElementType, this.rightValue().name() + suffix, (JExpression)JExpr.cast((JType)jaxbElementType, (JExpression)this.rightValue()));
        if (suppressWarnings) {
            castedRightValue.annotate(SuppressWarnings.class).param("value", "unchecked");
        }
        return new EqualsArguments(this.getCodeModel(), castedLeftValue, JExpr.TRUE, castedRightValue, JExpr.TRUE);
    }

    @Override
    public JBlock ifHasSetValue(JBlock block, boolean isAlwaysSet, boolean checkForNullRequired) {
        if (isAlwaysSet || !checkForNullRequired) {
            return block;
        }
        JConditional ifLeftHasSetValue = block._if(this.leftHasSetValue());
        JConditional ifLeftHasSetValueAndRightHasSetValue = ifLeftHasSetValue._then()._if(this.rightHasSetValue());
        JBlock subBlock = ifLeftHasSetValueAndRightHasSetValue._then();
        ifLeftHasSetValueAndRightHasSetValue._else()._return(JExpr.FALSE);
        ifLeftHasSetValue._elseif(this.rightHasSetValue())._then()._return(JExpr.FALSE);
        return subBlock;
    }

    @Override
    public JBlock _while(JBlock block) {
        JBlock _while = block._while(JOp.cand((JExpression)this.leftValue().invoke("hasNext"), (JExpression)this.rightValue().invoke("hasNext"))).body();
        block._if(JOp.cor((JExpression)this.leftValue().invoke("hasNext"), (JExpression)this.rightValue().invoke("hasNext")))._then()._return(JExpr.FALSE);
        return _while;
    }
}

