/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.wildcard;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.core.WildcardMode;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.wildcard.Customizations;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class WildcardPlugin
extends AbstractParameterizablePlugin {
    public String getOptionName() {
        return "Xwildcard";
    }

    public String getUsage() {
        return "  -Xwildcard         :  specify the wildcard mode for wildcard properties.";
    }

    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        boolean laxModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.LAX_ELEMENT_NAME);
        boolean skipModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.SKIP_ELEMENT_NAME);
        boolean strictModel = CustomizationUtils.containsCustomization((Model)model, (QName)Customizations.STRICT_ELEMENT_NAME);
        for (CClassInfo classInfo : model.beans().values()) {
            boolean laxClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.LAX_ELEMENT_NAME);
            boolean skipClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
            boolean strictClassInfo = CustomizationUtils.containsCustomization((CClassInfo)classInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                boolean laxPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.LAX_ELEMENT_NAME);
                boolean skipPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.SKIP_ELEMENT_NAME);
                boolean strictPropertyInfo = CustomizationUtils.containsCustomization((CPropertyInfo)referencePropertyInfo, (QName)Customizations.STRICT_ELEMENT_NAME);
                if (laxModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                    continue;
                }
                if (skipPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                    continue;
                }
                if (!strictPropertyInfo) continue;
                referencePropertyInfo.setWildcard(WildcardMode.STRICT);
            }
        }
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME);
    }
}

