/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.customizations;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.dom.DOMUtils;
import org.jvnet.basicjaxb.locator.util.LocatorBean;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.customizations.Customizations;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CustomizationsPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xcustomizations";
    private static final String OPTION_DESC = "read and add customizations from files";
    private static final String LOCATOR_PREFIX = "loc";
    private File directory;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File customizationsDirectory) {
        this.directory = customizationsDirectory;
    }

    protected void beforePostProcessModel(Model model) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Directory.: " + this.getDirectory());
            sb.append("\n  Verbose...: " + this.isVerbose());
            sb.append("\n  Debug.....: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterPostProcessModel(Model model, ErrorHandler errorHandler) {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError(errorHandler));
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void postProcessModel(Model model) {
        if (this.getDirectory() == null) {
            this.warn("Customizations directory is not provided, please use the -Xcustomizations-directory=<directory> command line argument to provide it.", new Object[0]);
        } else if (!this.getDirectory().exists()) {
            this.warn("Customizations directory [{}] does not exist.", new Object[]{this.getDirectory().getAbsolutePath()});
        } else if (!this.getDirectory().isDirectory()) {
            this.warn("Customizations directory [{}] is not a directory.", new Object[]{this.getDirectory().getAbsolutePath()});
        } else {
            for (CClassInfo classInfo : model.beans().values()) {
                this.postProcessClassInfo(model, classInfo);
            }
            for (CEnumLeafInfo enumLeafInfo : model.enums().values()) {
                this.postProcessEnumLeafInfo(model, enumLeafInfo);
            }
        }
    }

    private void postProcessClassInfo(Model model, CClassInfo classInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CClassInfo)classInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(classInfo.getLocator(), customizationsFileName);
        classInfo.getCustomizations().addAll(customizations);
        for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
            this.postProcessPropertyInfo(model, classInfo, propertyInfo);
        }
    }

    private void postProcessPropertyInfo(Model model, CClassInfo classInfo, CPropertyInfo propertyInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CClassInfo)classInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + "." + propertyInfo.getName(false) + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(classInfo.getLocator(), customizationsFileName);
        propertyInfo.getCustomizations().addAll(customizations);
    }

    private void postProcessEnumLeafInfo(Model model, CEnumLeafInfo enumLeafInfo) {
        String packagedClassName = ClassUtils.getPackagedClassName((CEnumLeafInfo)enumLeafInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(enumLeafInfo.getLocator(), customizationsFileName);
        enumLeafInfo.getCustomizations().addAll(customizations);
        for (CEnumConstant enumConstant : enumLeafInfo.getConstants()) {
            this.postProcessEnumConstant(model, enumLeafInfo, enumConstant);
        }
    }

    private void postProcessEnumConstant(Model model, CEnumLeafInfo enumLeafInfo, CEnumConstant enumConstant) {
        String packagedClassName = ClassUtils.getPackagedClassName((CEnumLeafInfo)enumLeafInfo);
        String customizationsFileName = packagedClassName.replace(".", "/") + "." + enumConstant.getName() + ".xml";
        List<CPluginCustomization> customizations = this.readCustomizations(enumLeafInfo.getLocator(), customizationsFileName);
        enumConstant.getCustomizations().addAll(customizations);
    }

    private List<CPluginCustomization> readCustomizations(Locator locator, String fileName) {
        LinkedList<CPluginCustomization> customizations = new LinkedList<CPluginCustomization>();
        String location = LocatorUtils.toLocation((Object)locator);
        File file = new File(this.getDirectory(), fileName);
        String systemId = file.getAbsolutePath();
        if (!file.exists()) {
            this.trace("{}, readCustomizations; Bypass customizations from [{}]; file does not exist.", new Object[]{location, systemId});
        } else if (!file.isFile()) {
            this.warn("{}, readCustomizations; This [{}] is not a file.", new Object[]{location, systemId});
        } else {
            try (FileInputStream is = new FileInputStream(file);){
                Document document = DOMUtils.saxParseDocument((InputStream)is, (String)systemId, (String)LOCATOR_PREFIX);
                Element element = document.getDocumentElement();
                String elNamespaceURI = element.getNamespaceURI();
                String elLocalName = element.getLocalName();
                QName elName = new QName(elNamespaceURI, elLocalName);
                if (Customizations.CUSTOMIZATIONS_ELEMENT_NAME.equals(elName)) {
                    NodeList childNodes = element.getChildNodes();
                    for (int index = 0; index < childNodes.getLength(); ++index) {
                        Node childNode = childNodes.item(index);
                        if (childNode.getNodeType() != 1) continue;
                        Element ce = (Element)childNode;
                        LocatorBean cl = DOMUtils.getLocator((Element)ce, (String)LOCATOR_PREFIX);
                        customizations.add(new CPluginCustomization(ce, (Locator)cl));
                        this.debug("{}, readCustomizations; {{}}{}", new Object[]{cl, ce.getNamespaceURI(), ce.getNodeName()});
                    }
                } else {
                    customizations.add(new CPluginCustomization(element, locator));
                }
                this.debug("{}, readCustomizations; Loaded customizations from [{}].", new Object[]{location, systemId});
            }
            catch (IOException ioex) {
                this.warn(String.format("%s, readCustomizations; Could not parse [%s].", location, systemId), ioex);
            }
            catch (SAXException saxex) {
                this.warn(String.format("%s, readCustomizations; Could not parse [%s].", location, systemId), saxex);
            }
        }
        return customizations;
    }
}

