/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.fixmixedextensions;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.generator.bean.field.DummyListField;
import com.sun.tools.xjc.generator.bean.field.IsSetField;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import org.jvnet.basicjaxb.plugin.AbstractPlugin;
import org.jvnet.basicjaxb.reflection.util.Accessor;
import org.jvnet.basicjaxb.reflection.util.FieldAccessor;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class FixMixedExtensions
extends AbstractPlugin {
    private static final String OPTION_NAME = "XfixMixedExtensions";
    private static final String OPTION_DESC = "adds missing 'getContentOverrideForNAME()' method";
    private static final JType[] NO_ARGS = new JType[0];
    private Accessor<JMethod> DummyListField_$get;
    private Accessor<FieldOutline> IsSetField_core;
    private Accessor<JFieldVar> AbstractListField_field;
    private Accessor<JClass> AbstractListField_listT;
    private Accessor<JClass> DummyListField_coreList;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        this.DummyListField_$get = new FieldAccessor(DummyListField.class, "$get", JMethod.class);
        this.IsSetField_core = new FieldAccessor(IsSetField.class, "core", FieldOutline.class);
        this.AbstractListField_field = new FieldAccessor(DummyListField.class.getSuperclass(), "field", JFieldVar.class);
        this.AbstractListField_listT = new FieldAccessor(DummyListField.class.getSuperclass(), "listT", JClass.class);
        this.DummyListField_coreList = new FieldAccessor(DummyListField.class, "coreList", JClass.class);
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    private void processClassOutline(ClassOutline classOutline) {
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.fixFieldOutline(fieldOutline);
        }
        JDefinedClass theClass = classOutline.implClass;
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private void fixFieldOutline(FieldOutline fieldOutline) {
        this.fixPublicName(fieldOutline);
        if (fieldOutline instanceof DummyListField) {
            this.fixDummyListField((DummyListField)fieldOutline);
        } else if (fieldOutline instanceof IsSetField) {
            this.fixIsSetField((IsSetField)fieldOutline);
        }
    }

    private void fixDummyListField(DummyListField fieldOutline) {
        if (this.DummyListField_$get.get((Object)fieldOutline) == null) {
            JFieldVar field = (JFieldVar)this.AbstractListField_field.get((Object)fieldOutline);
            JType listT = (JType)this.AbstractListField_listT.get((Object)fieldOutline);
            JClass coreList = (JClass)this.DummyListField_coreList.get((Object)fieldOutline);
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            JMethod $get = fieldOutline.parent().implClass.method(1, listT, "get" + fieldInfo.getName(true));
            JBlock block = $get.body();
            block._if(field.eq(JExpr._null()))._then().assign((JAssignmentTarget)field, (JExpression)JExpr._new((JClass)coreList));
            block._return((JExpression)JExpr._this().ref((JVar)field));
            this.DummyListField_$get.set((Object)fieldOutline, (Object)$get);
            this.trace("{}, fixDummyListField; Field={}", new Object[]{LocatorUtils.toLocation((Object)fieldInfo.getLocator()), fieldInfo.getName(false)});
        }
    }

    private void fixIsSetField(IsSetField isSetField) {
        this.fixIsSetMethod(isSetField);
        FieldOutline core = (FieldOutline)this.IsSetField_core.get((Object)isSetField);
        this.fixFieldOutline(core);
        CPropertyInfo fieldInfo = isSetField.getPropertyInfo();
        this.trace("{}, fixIsSetField; Field={}", new Object[]{LocatorUtils.toLocation((Object)fieldInfo.getLocator()), fieldInfo.getName(false)});
    }

    private void fixPublicName(FieldOutline fieldOutline) {
        CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
        String pubName = fieldInfo.getName(true);
        if (Character.isLowerCase(pubName.charAt(0))) {
            fieldInfo.setName(true, Character.toUpperCase(pubName.charAt(0)) + pubName.substring(1));
        }
    }

    private void fixIsSetMethod(IsSetField isSetField) {
        CPropertyInfo fieldInfo = isSetField.getPropertyInfo();
        JMethod isSetMethod = isSetField.parent().implClass.getMethod("isSet" + fieldInfo.getName(false), NO_ARGS);
        if (isSetMethod != null) {
            isSetMethod.name("isSet" + fieldInfo.getName(true));
        }
    }
}

