/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.valueconstructor;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.FieldOutlineUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class ValueConstructorPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XvalueConstructor";
    private static final String OPTION_DESC = "enable generation of value constructor(s)";
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.valueconstructor.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.valueconstructor.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline theClassOutline) {
        JDefinedClass theDefinedClass = theClassOutline.implClass;
        FieldOutline[] superClassFilteredFields = this.getSuperClassFilteredFields(theClassOutline);
        FieldOutline[] theClassFilteredFields = FieldOutlineUtils.filter(theClassOutline.getDeclaredFields(), this.getIgnoring());
        if (superClassFilteredFields.length != 0 || theClassFilteredFields.length != 0) {
            JMethod defaultConstructor = theDefinedClass.constructor(1);
            defaultConstructor.javadoc().add((Object)"Default no-arg constructor");
            defaultConstructor.body().invoke("super");
            JMethod valueConstructor = theDefinedClass.constructor(1);
            valueConstructor.javadoc().add((Object)"Field-initializing value constructor");
            if (theDefinedClass._extends() instanceof JDefinedClass) {
                this.generateSuperArgs(valueConstructor, theDefinedClass, superClassFilteredFields);
            }
            this.generateLocalArgs(valueConstructor, theDefinedClass, theClassFilteredFields);
        }
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)theDefinedClass.metadata), theDefinedClass.name()});
    }

    private void generateSuperArgs(JMethod valueConstructor, JDefinedClass theDefinedClass, FieldOutline[] superClassFilteredFields) {
        JInvocation superInvocation = valueConstructor.body().invoke("super");
        for (FieldOutline superClassDeclaredField : superClassFilteredFields) {
            if (!this.generateConstructorParameter(superClassDeclaredField)) continue;
            CPropertyInfo propertyInfo = superClassDeclaredField.getPropertyInfo();
            String fieldName = propertyInfo.getName(false);
            JType fieldType = superClassDeclaredField.getRawType();
            JVar arg = valueConstructor.param(0, fieldType, fieldName);
            superInvocation.arg((JExpression)arg);
            this.trace("{}, generateSuperArgs; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Object)propertyInfo.getLocator()), theDefinedClass.name(), fieldName});
        }
    }

    private void generateLocalArgs(JMethod valueConstructor, JDefinedClass theDefinedClass, FieldOutline[] theClassFilteredFields) {
        for (FieldOutline theClassDeclaredField : theClassFilteredFields) {
            if (!this.generateConstructorParameter(theClassDeclaredField)) continue;
            CPropertyInfo propertyInfo = theClassDeclaredField.getPropertyInfo();
            String fieldName = propertyInfo.getName(false);
            JType fieldType = theClassDeclaredField.getRawType();
            JVar arg = valueConstructor.param(0, fieldType, fieldName);
            valueConstructor.body().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)arg);
            this.trace("{}, generateLocalArgs; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Object)propertyInfo.getLocator()), theDefinedClass.name(), fieldName});
        }
    }

    protected boolean generateConstructorParameter(FieldOutline fieldOutline) {
        return true;
    }

    protected FieldOutline[] getSuperClassFilteredFields(ClassOutline classOutline) {
        LinkedList fieldOutlineList = new LinkedList();
        for (ClassOutline sco = classOutline.getSuperClass(); sco != null; sco = sco.getSuperClass()) {
            FieldOutline[] superFieldOutlines = FieldOutlineUtils.filter(sco.getDeclaredFields(), this.getIgnoring());
            ArrayList<FieldOutline> superFieldOutlineList = new ArrayList<FieldOutline>();
            for (FieldOutline superFieldOutline : superFieldOutlines) {
                superFieldOutlineList.add(superFieldOutline);
            }
            fieldOutlineList.addAll(0, superFieldOutlineList);
        }
        return fieldOutlineList.toArray(new FieldOutline[fieldOutlineList.size()]);
    }
}

