/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.fixotherattributes;

import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.lang.reflect.Field;
import java.util.Map;
import org.jvnet.basicjaxb.plugin.AbstractPlugin;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;

public class FixOtherAttributes
extends AbstractPlugin {
    private static final String OPTION_NAME = "XfixOtherAttributes";
    private static final String OPTION_DESC = "removes duplicate otherAttributes property";
    private static final String OTHER_ATTRIBUTES = "otherAttributes";
    private static final String GET_OTHER_ATTRIBUTES = "getOtherAttributes";
    private static final JType[] NO_ARGS = new JType[0];

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    private void processClassOutline(ClassOutline classOutline) throws ClassNotFoundException {
        JDefinedClass theClass = classOutline.implClass;
        for (Map.Entry<String, JFieldVar> entry : theClass.fields().entrySet()) {
            JMethod method;
            Class<?> superClass;
            if (!OTHER_ATTRIBUTES.equals(((JFieldVar)entry.getValue()).name()) || !this.hasField(superClass = Class.forName(theClass._extends().fullName()), OTHER_ATTRIBUTES) || (method = theClass.getMethod(GET_OTHER_ATTRIBUTES, NO_ARGS)) == null) continue;
            this.removeFieldAndMethod(theClass, entry, method, classOutline.target);
        }
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private void removeFieldAndMethod(JDefinedClass theClass, Map.Entry<String, JFieldVar> fieldEntry, JMethod method, CClassInfo target) {
        theClass.methods().remove(method);
        theClass.removeField(fieldEntry.getValue());
        target.hasAttributeWildcard(false);
        this.trace("{}, removeFieldAndMethod; Class={}; Field={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name(), fieldEntry.getValue().name()});
    }

    private boolean hasField(Class<?> clazz, String name) {
        if (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                return true;
            }
            return this.hasField(clazz.getSuperclass(), name);
        }
        return false;
    }
}

