/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.inheritance;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.inheritance.model.AnnotatesMetaObject;
import org.jvnet.basicjaxb.plugin.inheritance.model.ExtendsClass;
import org.jvnet.basicjaxb.plugin.inheritance.model.ImplementsInterface;
import org.jvnet.basicjaxb.plugin.inheritance.model.ObjectFactory;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Locator;

public class Customizations {
    public static String NAMESPACE_URI = "http://jvnet.org/basicjaxb/xjc/inheritance";
    public static QName OBJECT_FACTORY_ELEMENT_NAME = new QName(NAMESPACE_URI, "objectFactory");
    public static QName EXTENDS_ELEMENT_NAME = new QName(NAMESPACE_URI, "extends");
    public static QName IMPLEMENTS_ELEMENT_NAME = new QName(NAMESPACE_URI, "implements");
    public static QName ANNOTATES_ELEMENT_NAME = new QName(NAMESPACE_URI, "annotates");
    public static QName ANNOTATES_ELEMENT_ELEMENT_NAME = new QName(NAMESPACE_URI, "element");
    public static QName ANNOTATES_ELEMENTS_ELEMENT_NAME = new QName(NAMESPACE_URI, "elements");
    private static final Logger logger = LoggerFactory.getLogger(Customizations.class);
    private static final JAXBContext context;

    public static Logger getLogger() {
        return logger;
    }

    public static JAXBContext getContext() {
        return context;
    }

    public static void _annotates(CClassInfo classInfo, Map<String, Map<String, Object>> annotationMap) {
        for (String annotation : annotationMap.keySet()) {
            AnnotatesMetaObject annotatesMetaObject = new AnnotatesMetaObject();
            annotatesMetaObject.setAnnotation(annotation);
            Map<String, Object> elementMap = annotationMap.get(annotation);
            if (elementMap != null) {
                for (String name : elementMap.keySet()) {
                    Object object = elementMap.get(name);
                    if (object == null) continue;
                    if (object.getClass().isArray()) {
                        Class<?> componentType = object.getClass().getComponentType();
                        AnnotatesMetaObject.Elements elements = new AnnotatesMetaObject.Elements();
                        elements.setName(name);
                        elements.setType(componentType.getName());
                        for (Object value : Customizations._toObjectArray(object, componentType)) {
                            elements.getValue().add(value.toString());
                        }
                        annotatesMetaObject.getElements().add(elements);
                        continue;
                    }
                    AnnotatesMetaObject.Element element = new AnnotatesMetaObject.Element();
                    element.setName(name);
                    element.setType(object.getClass().getName());
                    element.setValue(object.toString());
                    annotatesMetaObject.getElement().add(element);
                }
            }
            CPluginCustomization customization = CustomizationUtils.marshal((JAXBContext)Customizations.getContext(), (QName)ANNOTATES_ELEMENT_NAME, (Object)annotatesMetaObject, (Locator)LocatorUtils.getLocator((CClassInfo)classInfo));
            customization.markAsAcknowledged();
            classInfo.getCustomizations().add((Object)customization);
        }
    }

    private static Object[] _toObjectArray(Object array, Class<?> componentType) {
        if (componentType.isPrimitive()) {
            ArrayList<Object> objects = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Object object = Array.get(array, i);
                if (object == null) continue;
                objects.add(object);
            }
            return objects.toArray();
        }
        return (Object[])array;
    }

    public static void _extends(CClassInfo classInfo, String className) {
        ExtendsClass extendsClass = new ExtendsClass();
        extendsClass.setValue(className);
        Locator locator = LocatorUtils.getLocator((CClassInfo)classInfo);
        CPluginCustomization customization = CustomizationUtils.marshal((JAXBContext)Customizations.getContext(), (QName)EXTENDS_ELEMENT_NAME, (Object)extendsClass, (Locator)locator);
        classInfo.getCustomizations().add((Object)customization);
        customization.markAsAcknowledged();
    }

    public static void _implements(CClassInfo classInfo, String ... interfaceNames) {
        for (String interfaceName : interfaceNames) {
            ImplementsInterface implementsInterface = new ImplementsInterface();
            implementsInterface.setValue(interfaceName);
            Locator locator = LocatorUtils.getLocator((CClassInfo)classInfo);
            CPluginCustomization customization = CustomizationUtils.marshal((JAXBContext)Customizations.getContext(), (QName)IMPLEMENTS_ELEMENT_NAME, (Object)implementsInterface, (Locator)locator);
            customization.markAsAcknowledged();
            classInfo.getCustomizations().add((Object)customization);
        }
    }

    static {
        try {
            context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)ObjectFactory.class.getClassLoader());
        }
        catch (JAXBException ex) {
            Customizations.getLogger().error("Cannot initialize JAXBContext", (Throwable)ex);
            throw new ExceptionInInitializerError(ex);
        }
    }
}

