/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.inheritance.util;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.visitor.GenericVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jvnet.basicjaxb.plugin.inheritance.util.TypeToJTypeConvertingVisitor;

public class JavaTypeParser {
    private final TypeToJTypeConvertingVisitor typeToJTypeConvertingVisitor;

    public JavaTypeParser() {
        this(Collections.emptyMap());
    }

    public JavaTypeParser(Map<String, JClass> knownClasses) {
        Objects.requireNonNull(knownClasses);
        this.typeToJTypeConvertingVisitor = new TypeToJTypeConvertingVisitor(knownClasses);
    }

    public JClass parseClass(String _class, JCodeModel codeModel) {
        JType type = this.parseType(_class, codeModel);
        if (type instanceof JClass) {
            return (JClass)type;
        }
        throw new IllegalArgumentException("Type [" + _class + "] is not a class.");
    }

    private JType parseType(String type, JCodeModel codeModel) {
        JType jType;
        String extendsType = "public class Ignored extends " + type + " {}";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(extendsType.getBytes(StandardCharsets.UTF_8));
        try {
            CompilationUnit compilationUnit = JavaParser.parse((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
            List typeDeclarations = compilationUnit.getTypes();
            TypeDeclaration typeDeclaration = (TypeDeclaration)typeDeclarations.get(0);
            ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)typeDeclaration;
            List _extended = classDeclaration.getExtends();
            ClassOrInterfaceType classOrInterfaceType = (ClassOrInterfaceType)_extended.get(0);
            jType = (JType)classOrInterfaceType.accept((GenericVisitor)this.typeToJTypeConvertingVisitor, (Object)codeModel);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException | IOException pex) {
                throw new IllegalArgumentException("Could not parse the type definition [" + type + "].", pex);
            }
        }
        inputStream.close();
        return jType;
    }
}

