/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simplehashcode;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.basicjaxb.plugin.codegenerator.CodeGenerator;
import org.jvnet.basicjaxb.plugin.hashcode.Customizations;
import org.jvnet.basicjaxb.plugin.simplehashcode.HashCodeArguments;
import org.jvnet.basicjaxb.plugin.simplehashcode.HashCodeCodeGenerator;
import org.jvnet.basicjaxb.plugin.util.AttributeWildcardArguments;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.FieldUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class SimpleHashCodePlugin
extends AbstractCodeGeneratorPlugin<HashCodeArguments> {
    private static final String OPTION_NAME = "XsimpleHashCode";
    private static final String OPTION_DESC = "generate reflection-free runtime-free 'hashCode' methods";
    private int multiplier = 31;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    @Override
    protected CodeGenerator<HashCodeArguments> createCodeGenerator(JCodeModel codeModel) {
        return new HashCodeCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod object$hashCode = theClass.method(1, (JType)codeModel.INT, "hashCode");
        object$hashCode.annotate(Override.class);
        JBlock body = object$hashCode.body();
        JExpression currentHashCodeExpression = JExpr.lit((int)1);
        JVar currentHashCode = body.decl((JType)codeModel.INT, "currentHashCode", currentHashCodeExpression);
        Boolean superClassImplementsHashCode = StrategyClassUtils.superClassNotIgnored(classOutline, this.getIgnoring());
        if (superClassImplementsHashCode != null) {
            body.assign((JAssignmentTarget)currentHashCode, currentHashCode.mul(JExpr.lit((int)this.getMultiplier())).plus((JExpression)JExpr._super().invoke("hashCode")));
        }
        for (FieldOutline fieldOutline : declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
            if (!fieldAccessor.isConstant()) {
                JBlock block = body.block();
                block.assign((JAssignmentTarget)currentHashCode, currentHashCode.mul(JExpr.lit((int)this.getMultiplier())));
                String propertyName = fieldInfo.getName(true);
                JType exposedType = fieldAccessor.getType();
                JVar value = block.decl(exposedType, "the" + propertyName);
                fieldAccessor.toRawValue(block, value);
                JExpression hasSetValue = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                HashCodeArguments arguments = new HashCodeArguments(codeModel, currentHashCode, this.getMultiplier(), value, hasSetValue);
                Set possibleTypes = FieldUtils.getPossibleTypes((FieldOutline)fieldOutline, (Aspect)Aspect.EXPOSED);
                boolean isAlwaysSet = fieldAccessor.isAlwaysSet();
                this.getCodeGenerator().generate(block, exposedType, possibleTypes, isAlwaysSet, arguments);
            }
            this.trace("{}, generate; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldInfo.getName(false)});
        }
        if (classOutline.target.declaresAttributeWildcard()) {
            AttributeWildcardArguments awa = new AttributeWildcardArguments(classOutline);
            JBlock block = body.block();
            JVar theValue = awa.fieldVar(block, JExpr._this(), "the");
            HashCodeArguments arguments = new HashCodeArguments(codeModel, currentHashCode, this.getMultiplier(), theValue, AttributeWildcardArguments.HAS_SET_VALUE);
            this.getCodeGenerator().generate(block, awa.getExposedType(), awa.getPossibleTypes(), true, arguments);
            this.trace("{}, generate; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((ClassOutline)classOutline), theClass.name(), "otherAttributes"});
        }
        body._return((JExpression)currentHashCode);
        this.debug("{}, generate; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private int getMultiplier() {
        return this.multiplier;
    }
}

