/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simpletostring;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.basicjaxb.plugin.codegenerator.CodeGenerator;
import org.jvnet.basicjaxb.plugin.simpletostring.ToStringArguments;
import org.jvnet.basicjaxb.plugin.simpletostring.ToStringCodeGenerator;
import org.jvnet.basicjaxb.plugin.tostring.Customizations;
import org.jvnet.basicjaxb.plugin.util.AttributeWildcardArguments;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.FieldUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class SimpleToStringPlugin
extends AbstractCodeGeneratorPlugin<ToStringArguments> {
    private static final String CONTENT_START = "[";
    private static final String CONTENT_END = "]";
    private static final String FIELD_SEPARATOR = ", ";
    private static final String OPTION_NAME = "XsimpleToString";
    private static final String OPTION_DESC = "generate reflection-free runtime-free 'toString' method";
    private boolean showFieldNames = false;
    private boolean showChildItems = false;
    private boolean fullClassName = false;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    public boolean isShowFieldNames() {
        return this.showFieldNames;
    }

    public void setShowFieldNames(boolean showFieldNames) {
        this.showFieldNames = showFieldNames;
    }

    public boolean isShowChildItems() {
        return this.showChildItems;
    }

    public void setShowChildItems(boolean showChildItems) {
        this.showChildItems = showChildItems;
    }

    public boolean isFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(boolean fullClassName) {
        this.fullClassName = fullClassName;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  ShowFieldNames.: " + this.isShowFieldNames());
            sb.append("\n  ShowChildItems.: " + this.isShowChildItems());
            sb.append("\n  FullClassName..: " + this.isFullClassName());
            sb.append("\n  Verbose........: " + this.isVerbose());
            sb.append("\n  Debug..........: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    @Override
    protected CodeGenerator<ToStringArguments> createCodeGenerator(JCodeModel codeModel) {
        return new ToStringCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        String methodName = "toStringFields";
        String[] methodParms = new String[]{"java.lang.StringBuilder"};
        Boolean sciToStringFields = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), methodName, methodParms, false);
        JMethod toStringFieldsMethod = this.generateToStringFieldsMethod(classOutline, theClass, sciToStringFields);
        if (!sciToStringFields.booleanValue()) {
            this.generateToStringMethod(theClass, toStringFieldsMethod);
        }
    }

    private void generateToStringMethod(JDefinedClass theClass, JMethod toStringFieldsMethod) {
        JCodeModel codeModel = theClass.owner();
        JMethod toStringMethod = theClass.method(1, (JType)codeModel.ref(String.class), "toString");
        toStringMethod.annotate(Override.class);
        JBlock body = toStringMethod.body();
        JVar stringBuilder = body.decl(8, (JType)codeModel.ref(StringBuilder.class), "stringBuilder", (JExpression)JExpr._new((JClass)codeModel.ref(StringBuilder.class)));
        if (this.isFullClassName()) {
            body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)JExpr._this().invoke("getClass").invoke("getName")));
        } else {
            body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)JExpr._this().invoke("getClass").invoke("getSimpleName")));
        }
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((char)'@')));
        body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)codeModel.ref(Integer.class).staticInvoke("toHexString").arg((JExpression)codeModel.ref(System.class).staticInvoke("identityHashCode").arg(JExpr._this()))));
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((String)CONTENT_START)));
        body.invoke(toStringFieldsMethod.name()).arg((JExpression)stringBuilder);
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((String)CONTENT_END)));
        body._return((JExpression)stringBuilder.invoke("toString"));
        this.debug("{}, generateToStringMethod; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }

    private JMethod generateToStringFieldsMethod(ClassOutline classOutline, JDefinedClass theClass, Boolean sciToStringFields) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod toStringFieldsMethod = theClass.method(1, (JType)codeModel.VOID, "toStringFields");
        if (sciToStringFields.booleanValue()) {
            toStringFieldsMethod.annotate(Override.class);
        }
        toStringFieldsMethod.param((JType)codeModel.ref(StringBuilder.class), "stringBuilder");
        JBlock body = toStringFieldsMethod.body();
        JVar stringBuilder = (JVar)toStringFieldsMethod.params().get(0);
        String fieldSeparator = null;
        if (sciToStringFields.booleanValue()) {
            body.add((JStatement)JExpr._super().invoke(toStringFieldsMethod.name()).arg((JExpression)stringBuilder));
            fieldSeparator = FIELD_SEPARATOR;
        }
        for (FieldOutline fieldOutline : declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            if (!fieldAccessor.isConstant()) {
                JBlock block = body.block();
                String propertyName = fieldInfo.getName(true);
                JType exposedType = fieldAccessor.getType();
                JVar value = block.decl(exposedType, "the" + propertyName);
                fieldAccessor.toRawValue(block, value);
                JExpression hasSetValue = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                String fieldName = this.isShowFieldNames() ? fieldInfo.getName(false) : null;
                CDefaultValue defaultValue = fieldInfo.defaultValue;
                ToStringArguments arguments = new ToStringArguments(codeModel, stringBuilder, value, hasSetValue, fieldSeparator, fieldName, this.isShowChildItems(), defaultValue != null);
                Set possibleTypes = FieldUtils.getPossibleTypes((FieldOutline)fieldOutline, (Aspect)Aspect.EXPOSED);
                boolean isAlwaysSet = fieldAccessor.isAlwaysSet();
                this.getCodeGenerator().generate(block, exposedType, possibleTypes, isAlwaysSet, arguments);
                fieldSeparator = FIELD_SEPARATOR;
            }
            this.trace("{}, generateToStringFieldsMethod; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldInfo.getName(false)});
        }
        if (classOutline.target.declaresAttributeWildcard()) {
            AttributeWildcardArguments awa = new AttributeWildcardArguments(classOutline);
            JBlock block = body.block();
            JVar theValue = awa.fieldVar(block, JExpr._this(), "the");
            String fieldName = this.isShowFieldNames() ? "otherAttributes" : null;
            ToStringArguments arguments = new ToStringArguments(codeModel, stringBuilder, theValue, AttributeWildcardArguments.HAS_SET_VALUE, fieldSeparator, fieldName, this.isShowChildItems(), false);
            this.getCodeGenerator().generate(block, awa.getExposedType(), awa.getPossibleTypes(), true, arguments);
            this.trace("{}, generateToStringFieldsMethod; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((ClassOutline)classOutline), theClass.name(), "otherAttributes"});
        }
        return toStringFieldsMethod;
    }
}

