/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jvnet.basicjaxb.lang.CopyStrategy;
import org.jvnet.basicjaxb.lang.CopyTo;
import org.jvnet.basicjaxb.lang.StringUtils;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCopyStrategy
implements CopyStrategy {
    private static final DefaultCopyStrategy INSTANCE = new DefaultCopyStrategy();
    private Logger logger = LoggerFactory.getLogger(CopyStrategy.class);

    public static DefaultCopyStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    protected <T> T observe(ObjectLocator locator, T obj) {
        return this.observe("COPY", locator, obj);
    }

    protected <T> T observe(String label, ObjectLocator locator, T obj) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
        } else if (this.isDebugEnabled() && locator instanceof RootObjectLocator) {
            this.debug(this.buildMessage(label, locator, StringUtils.valueToString(obj)));
        }
        return obj;
    }

    protected String buildMessage(String label, ObjectLocator locator, String value) {
        String message = locator != null ? label + ": {" + locator.getPathAsString() + "} -> " + value : label + ": {} -> " + value;
        return message;
    }

    @Override
    public Boolean shouldBeCopiedAndSet(ObjectLocator locator, boolean valueSet) {
        return valueSet;
    }

    protected Object copyInternal(ObjectLocator locator, Object object) {
        if (object == null) {
            return this.observe(locator, null);
        }
        if (object instanceof String) {
            return this.observe(locator, object);
        }
        if (object instanceof Number) {
            return this.observe(locator, object);
        }
        if (object instanceof XMLGregorianCalendar) {
            return this.copyInternal(locator, (XMLGregorianCalendar)object);
        }
        if (object instanceof CopyTo) {
            return this.observe(locator, ((CopyTo)object).copyTo(locator, ((CopyTo)object).createNewInstance(), this));
        }
        if (object instanceof Cloneable) {
            return this.copyInternal(locator, (Cloneable)object);
        }
        return this.observe(locator, object);
    }

    protected Object copyInternal(ObjectLocator locator, XMLGregorianCalendar xgc) {
        return this.observe(locator, xgc.clone());
    }

    protected Object copy(ObjectLocator locator, Object value) {
        if (value == null) {
            return this.observe(locator, null);
        }
        Class<?> lhsClass = value.getClass();
        if (!lhsClass.isArray()) {
            return this.copyInternal(locator, value);
        }
        if (value instanceof long[]) {
            return this.copy(locator, (long[])value);
        }
        if (value instanceof int[]) {
            return this.copy(locator, (int[])value);
        }
        if (value instanceof short[]) {
            return this.copy(locator, (short[])value);
        }
        if (value instanceof char[]) {
            return this.copy(locator, (char[])value);
        }
        if (value instanceof byte[]) {
            return this.copy(locator, (byte[])value);
        }
        if (value instanceof double[]) {
            return this.copy(locator, (double[])value);
        }
        if (value instanceof float[]) {
            return this.copy(locator, (float[])value);
        }
        if (value instanceof boolean[]) {
            return this.copy(locator, (boolean[])value);
        }
        return this.copy(locator, (Object[])value);
    }

    protected long copy(ObjectLocator locator, long value) {
        return this.observe(locator, value);
    }

    protected int copy(ObjectLocator locator, int value) {
        return this.observe(locator, value);
    }

    protected short copy(ObjectLocator locator, short value) {
        return this.observe(locator, value);
    }

    protected char copy(ObjectLocator locator, char value) {
        return this.observe(locator, Character.valueOf(value)).charValue();
    }

    protected byte copy(ObjectLocator locator, byte value) {
        return this.observe(locator, value);
    }

    protected double copy(ObjectLocator locator, double value) {
        return this.observe(locator, value);
    }

    protected float copy(ObjectLocator locator, float value) {
        return this.observe(locator, Float.valueOf(value)).floatValue();
    }

    protected boolean copy(ObjectLocator locator, boolean value) {
        return this.observe(locator, value);
    }

    protected Object[] copy(ObjectLocator locator, Object[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        Object[] copy = new Object[array.length];
        for (int index = 0; index < array.length; ++index) {
            Object elementCopy;
            Object element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected long[] copy(ObjectLocator locator, long[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        long[] copy = new long[array.length];
        for (int index = 0; index < array.length; ++index) {
            long elementCopy;
            long element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected int[] copy(ObjectLocator locator, int[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        int[] copy = new int[array.length];
        for (int index = 0; index < array.length; ++index) {
            int elementCopy;
            int element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected short[] copy(ObjectLocator locator, short[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        short[] copy = new short[array.length];
        for (int index = 0; index < array.length; ++index) {
            short elementCopy;
            short element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected char[] copy(ObjectLocator locator, char[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        char[] copy = new char[array.length];
        for (int index = 0; index < array.length; ++index) {
            char elementCopy;
            char element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected byte[] copy(ObjectLocator locator, byte[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        byte[] copy = new byte[array.length];
        for (int index = 0; index < array.length; ++index) {
            byte elementCopy;
            byte element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected double[] copy(ObjectLocator locator, double[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        double[] copy = new double[array.length];
        for (int index = 0; index < array.length; ++index) {
            double elementCopy;
            double element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected float[] copy(ObjectLocator locator, float[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        float[] copy = new float[array.length];
        for (int index = 0; index < array.length; ++index) {
            float elementCopy;
            float element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected boolean[] copy(ObjectLocator locator, boolean[] array) {
        if (array == null) {
            return this.observe(locator, null);
        }
        boolean[] copy = new boolean[array.length];
        for (int index = 0; index < array.length; ++index) {
            boolean elementCopy;
            boolean element = array[index];
            copy[index] = elementCopy = this.copy((ObjectLocator)LocatorUtils.item(locator, index, element), element);
        }
        return copy;
    }

    protected Object copyInternal(ObjectLocator locator, Cloneable object) {
        Method method = null;
        try {
            method = object.getClass().getMethod("clone", null);
        }
        catch (NoSuchMethodException nsmex) {
            method = null;
        }
        if (method == null || !Modifier.isPublic(method.getModifiers())) {
            throw new UnsupportedOperationException("Could not clone object [" + String.valueOf(object) + "].", new CloneNotSupportedException("Object class [" + String.valueOf(object.getClass()) + "] implements java.lang.Cloneable interface, but does not provide a public no-arg clone() method. By convention, classes that implement java.lang.Cloneable should override java.lang.Object.clone() method (which is protected) with a public method."));
        }
        boolean wasAccessible = method.canAccess(object);
        try {
            if (!wasAccessible) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException ex) {
                    this.getLogger().warn("copyInternal " + ex.getMessage(), (Throwable)ex);
                }
            }
            Object ex = this.observe(locator, method.invoke((Object)object, (Object[])null));
            return ex;
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Could not clone the object [" + String.valueOf(object) + "] as invocation of the clone() method has thrown an exception.", ex);
        }
        finally {
            if (!wasAccessible) {
                try {
                    method.setAccessible(false);
                }
                catch (SecurityException ex) {
                    this.getLogger().warn("copyInternal " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public boolean copy(ObjectLocator locator, boolean value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public byte copy(ObjectLocator locator, byte value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public char copy(ObjectLocator locator, char value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public double copy(ObjectLocator locator, double value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public float copy(ObjectLocator locator, float value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public int copy(ObjectLocator locator, int value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public long copy(ObjectLocator locator, long value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public short copy(ObjectLocator locator, short value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public Object copy(ObjectLocator locator, Object value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public boolean[] copy(ObjectLocator locator, boolean[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public byte[] copy(ObjectLocator locator, byte[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public char[] copy(ObjectLocator locator, char[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public double[] copy(ObjectLocator locator, double[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public float[] copy(ObjectLocator locator, float[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public int[] copy(ObjectLocator locator, int[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public long[] copy(ObjectLocator locator, long[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public short[] copy(ObjectLocator locator, short[] value, boolean valueSet) {
        return this.copy(locator, value);
    }

    @Override
    public Object[] copy(ObjectLocator locator, Object[] value, boolean valueSet) {
        return this.copy(locator, value);
    }
}

