/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import jakarta.xml.bind.JAXBElement;
import java.util.Iterator;
import java.util.List;
import org.jvnet.basicjaxb.lang.DefaultEqualsStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;

public class JAXBEqualsStrategy
extends DefaultEqualsStrategy {
    private static JAXBEqualsStrategy INSTANCE = new JAXBEqualsStrategy();

    public static JAXBEqualsStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, Object lhs, Object rhs) {
        if (lhs instanceof JAXBElement && rhs instanceof JAXBElement) {
            return this.equalsInternal(lhsLocator, rhsLocator, (JAXBElement)lhs, (JAXBElement)rhs);
        }
        if (lhs instanceof List && rhs instanceof List) {
            return this.equalsInternal(lhsLocator, rhsLocator, (List)lhs, (List)rhs);
        }
        return super.equalsInternal(lhsLocator, rhsLocator, lhs, rhs);
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, List<?> lhs, List<?> rhs) {
        Iterator<?> e1 = lhs.iterator();
        Iterator<?> e2 = rhs.iterator();
        int index = 0;
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 != null ? this.equals((ObjectLocator)LocatorUtils.item(lhsLocator, index, o1), (ObjectLocator)LocatorUtils.item(rhsLocator, index, o2), o1, o2) : o2 == null)) {
                return false;
            }
            ++index;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    protected boolean equalsInternal(ObjectLocator lhsLocator, ObjectLocator rhsLocator, JAXBElement<?> lhs, JAXBElement<?> rhs) {
        return this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "name", lhs.getName()), (ObjectLocator)LocatorUtils.property(rhsLocator, "name", rhs.getName()), lhs.getName(), rhs.getName()) && this.equals((ObjectLocator)LocatorUtils.property(lhsLocator, "value", lhs.getValue()), (ObjectLocator)LocatorUtils.property(rhsLocator, "value", rhs.getValue()), lhs.getValue(), rhs.getValue());
    }
}

