/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin;

import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.util.ErrorReceiverFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractPlugin
extends Plugin {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String USAGE_FORMAT = "  -%-20s : %s";
    public static final String LOGGING_PREFIX = "XJC> ";
    public static final String LOGGING_START = ": Start";
    public static final String LOGGING_FINISH = ": Finish";
    protected static final JType[] NOARGS = new JType[0];
    private Options options = new Options();
    private ErrorHandler errorHandler = null;
    private boolean debug = false;
    private boolean quiet = false;
    private boolean verbose = false;
    private List<String> customizationURIs;
    private Set<QName> customizationElementNames;

    public Logger getLogger() {
        return this.logger;
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void setOptions(Options options) {
        this.options = options;
        this.setDebug(options.debugMode);
        this.setQuiet(options.quiet);
        this.setVerbose(options.verbose);
    }

    protected ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isVerbose() {
        return this.verbose || this.debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void onActivated(Options options) throws BadCommandLineException {
        super.onActivated(options);
        try {
            this.init(options);
        }
        catch (Exception ex) {
            throw new BadCommandLineException("Could not initialize the plugin [" + this.getOptionName() + "].", (Throwable)ex);
        }
    }

    protected SAXException handleException(ErrorHandler errorHandler, SAXParseException saxpex) {
        SAXException saxex = null;
        try {
            errorHandler.error(saxpex);
            saxex = saxpex;
        }
        catch (SAXException sex) {
            saxex = sex;
        }
        return saxex;
    }

    protected SAXException handleException(ErrorHandler errorHandler, Exception ex, String msg) {
        SAXException saxex = null;
        try {
            SAXParseException saxpex = null;
            saxpex = ex instanceof SAXParseException ? (SAXParseException)ex : new SAXParseException(msg, null, ex);
            errorHandler.error(saxpex);
            saxex = saxpex;
        }
        catch (SAXException sex) {
            saxex = sex;
        }
        return saxex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        block10: {
            this.setErrorHandler(errorHandler);
            this.beforePostProcessModel(model);
            this.postProcessModel(model);
            try {
                this.afterPostProcessModel(model, errorHandler);
            }
            catch (Exception ex) {
                this.error("{}: {}", ex.getClass().getSimpleName(), ex.getMessage());
                this.handleException(errorHandler, ex, "Error after plugin postProcessModel.");
            }
            break block10;
            catch (Exception ex) {
                try {
                    this.error("{}: {}", ex.getClass().getSimpleName(), ex.getMessage());
                    this.handleException(errorHandler, ex, "Error during plugin postProcessModel.");
                }
                catch (Throwable throwable) {
                    try {
                        this.afterPostProcessModel(model, errorHandler);
                    }
                    catch (Exception ex2) {
                        this.error("{}: {}", ex2.getClass().getSimpleName(), ex2.getMessage());
                        this.handleException(errorHandler, ex2, "Error after plugin postProcessModel.");
                    }
                    throw throwable;
                }
                try {
                    this.afterPostProcessModel(model, errorHandler);
                }
                catch (Exception ex3) {
                    this.error("{}: {}", ex3.getClass().getSimpleName(), ex3.getMessage());
                    this.handleException(errorHandler, ex3, "Error after plugin postProcessModel.");
                }
            }
        }
    }

    protected void beforePostProcessModel(Model model) throws Exception {
    }

    protected void postProcessModel(Model model) throws Exception {
    }

    protected void afterPostProcessModel(Model model, ErrorHandler errorHandler) throws Exception {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) throws SAXException {
        boolean bl;
        this.setOptions(options);
        this.setErrorHandler(errorHandler);
        try {
            this.beforeRun(outline);
            bl = this.run(outline);
        }
        catch (Exception ex) {
            try {
                this.error("{}: {}", ex.getClass().getSimpleName(), ex.getMessage());
                throw this.handleException(errorHandler, ex, "Error during plugin execution.");
            }
            catch (Throwable throwable) {
                try {
                    this.afterRun(outline);
                    throw throwable;
                }
                catch (Exception ex2) {
                    this.error("{}: {}", ex2.getClass().getSimpleName(), ex2.getMessage());
                    throw this.handleException(errorHandler, ex2, "Error after plugin execution.");
                }
            }
        }
        try {
            this.afterRun(outline);
            return bl;
        }
        catch (Exception ex) {
            this.error("{}: {}", ex.getClass().getSimpleName(), ex.getMessage());
            throw this.handleException(errorHandler, ex, "Error after plugin execution.");
        }
    }

    protected void beforeRun(Outline outline) throws Exception {
    }

    protected boolean run(Outline outline) throws Exception {
        return true;
    }

    protected void afterRun(Outline outline) throws Exception {
    }

    protected void init(Options options) throws Exception {
    }

    public Collection<QName> getCustomizationElementNames() {
        return Collections.emptyList();
    }

    public List<String> getCustomizationURIs() {
        if (this.customizationURIs == null) {
            Collection<QName> customizationElementNames = this.getCustomizationElementNames();
            this.customizationURIs = new ArrayList<String>(customizationElementNames.size());
            for (QName customizationElementName : customizationElementNames) {
                String namespaceURI = customizationElementName.getNamespaceURI();
                if (namespaceURI == null || namespaceURI.length() == 0) continue;
                this.customizationURIs.add(namespaceURI);
            }
        }
        return this.customizationURIs;
    }

    public boolean isCustomizationTagName(String namespaceURI, String localName) {
        if (this.customizationElementNames == null) {
            this.customizationElementNames = new HashSet<QName>(this.getCustomizationElementNames());
        }
        return this.customizationElementNames.contains(new QName(namespaceURI, localName));
    }

    public boolean isTraceEnabled() {
        return !this.isQuiet() && this.isVerbose() && this.isDebug() && this.getLogger().isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return !this.isQuiet() && this.isVerbose() && this.isDebug() && this.getLogger().isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return !this.isQuiet() && this.isVerbose() && this.getLogger().isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return !this.isQuiet() && this.getLogger().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return !this.isQuiet() && this.getLogger().isErrorEnabled();
    }

    public void trace(String msg, Object ... args) {
        if (!this.isQuiet() && this.isVerbose() && this.isDebug()) {
            this.getLogger().trace(LOGGING_PREFIX + this.getOptionName() + ": " + msg, args);
        }
    }

    public void trace(String msg, Throwable th) {
        if (!this.isQuiet() && this.isVerbose() && this.isDebug()) {
            this.getLogger().trace(LOGGING_PREFIX + this.getOptionName() + ": " + msg, th);
        }
    }

    public void debug(String msg, Object ... args) {
        if (!this.isQuiet() && this.isVerbose() && this.isDebug()) {
            this.getLogger().debug(LOGGING_PREFIX + this.getOptionName() + ": " + msg, args);
        }
    }

    public void debug(boolean isVerbose, String msg, Throwable th) {
        if (!this.isQuiet() && this.isVerbose() && this.isDebug()) {
            this.getLogger().debug(LOGGING_PREFIX + this.getOptionName() + ": " + msg, th);
        }
    }

    public void info(String msg, Object ... args) {
        if (!this.isQuiet() && this.isVerbose()) {
            this.getLogger().info(LOGGING_PREFIX + this.getOptionName() + ": " + msg, args);
        }
    }

    public void info(String msg, Throwable th) {
        if (!this.isQuiet() && this.isVerbose()) {
            this.getLogger().info(LOGGING_PREFIX + this.getOptionName() + ": " + msg, th);
        }
    }

    public void warn(String msg, Object ... args) {
        if (!this.isQuiet()) {
            this.getLogger().warn(LOGGING_PREFIX + this.getOptionName() + ": " + msg, args);
        }
    }

    public void warn(String msg, Throwable th) {
        if (!this.isQuiet()) {
            this.getLogger().warn(LOGGING_PREFIX + this.getOptionName() + ": " + msg, th);
        }
    }

    public void error(String msg, Object ... args) {
        if (!this.isQuiet()) {
            this.getLogger().error(LOGGING_PREFIX + this.getOptionName() + ": " + msg, args);
        }
    }

    public void error(String msg, Throwable th) {
        if (!this.isQuiet()) {
            this.getLogger().error(LOGGING_PREFIX + this.getOptionName() + ": " + msg, th);
        }
    }

    protected boolean hadError(ErrorHandler errorHandler) {
        boolean hadError = false;
        if (errorHandler instanceof ErrorReceiverFilter) {
            ErrorReceiverFilter errorReceiverFilter = (ErrorReceiverFilter)errorHandler;
            hadError = errorReceiverFilter.hadError();
        }
        return hadError;
    }
}

