/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb_annox.plugin.removeannotation;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.hyperjaxb_annox.plugin.AnnotationTarget;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RemoveAnnotationPlugin
extends AbstractParameterizablePlugin {
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromProperty");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_GETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertyGetter");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertySetter");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_FIELD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertyField");
    public static final QName REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_PARAMETER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPropertySetterParameter");
    public static final QName REMOVE_ANNOTATION_FROM_PACKAGE_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromPackage");
    public static final QName REMOVE_ANNOTATION_FROM_CLASS_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromClass");
    public static final QName REMOVE_ANNOTATION_FROM_ELEMENT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromElement");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnum");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_CONSTANT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumConstant");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumValueMethod");
    public static final QName REMOVE_ANNOTATION_FROM_ENUM_FROM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotationFromEnumFromValueMethod");
    public static final QName REMOVE_ANNOTATION_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "removeAnnotation");
    public static final Set<QName> CUSTOMIZATION_ELEMENT_QNAMES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(REMOVE_ANNOTATION_QNAME, REMOVE_ANNOTATION_FROM_PACKAGE_QNAME, REMOVE_ANNOTATION_FROM_CLASS_QNAME, REMOVE_ANNOTATION_FROM_ELEMENT_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_FIELD_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_GETTER_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_QNAME, REMOVE_ANNOTATION_FROM_PROPERTY_SETTER_PARAMETER_QNAME, REMOVE_ANNOTATION_FROM_ENUM_QNAME, REMOVE_ANNOTATION_FROM_ENUM_CONSTANT_QNAME, REMOVE_ANNOTATION_FROM_ENUM_VALUE_METHOD_QNAME, REMOVE_ANNOTATION_FROM_ENUM_FROM_VALUE_METHOD_QNAME)));
    public static final String CLASS_ATTRIBUTE_NAME = "class";
    private String defaultFieldTarget = "getter";

    public String getOptionName() {
        return "XremoveAnnotation";
    }

    public String getUsage() {
        return "TBD";
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "setter-parameter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline, options, errorHandler);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline, options, errorHandler);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline, options, errorHandler);
        }
        return true;
    }

    protected void processElementOutline(ElementOutline elementOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ElementOutline)elementOutline);
        this.removeAnnotationFromElementOutline(elementOutline.implClass.owner(), elementOutline, customizations, errorHandler);
    }

    protected void processEnumOutline(EnumOutline enumOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumOutline)enumOutline);
        this.removeAnnotationFromEnumOutline(enumOutline.clazz.owner(), enumOutline, customizations, errorHandler);
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline, options, errorHandler);
        }
    }

    protected void processClassOutline(ClassOutline classOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.removeAnnotationFromClassOutline(classOutline.ref.owner(), classOutline, customizations, errorHandler);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline, options, errorHandler);
        }
    }

    protected void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.removeAnnotationFromFieldOutline(fieldOutline.parent().ref.owner(), fieldOutline, customizations, errorHandler);
    }

    protected void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, Options options, ErrorHandler errorHandler) {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumConstantOutline)enumConstantOutline);
        this.removeAnnotationFromEnumConstantOutline(enumOutline.parent().getCodeModel(), enumOutline.parent(), enumConstantOutline, customizations, errorHandler);
    }

    protected void removeAnnotationFromElementOutline(JCodeModel codeModel, ElementOutline elementOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ELEMENT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(elementOutline.parent(), elementOutline);
                this.removeAnnotation(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void removeAnnotationFromEnumOutline(JCodeModel codeModel, EnumOutline enumOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutline.parent(), enumOutline);
                this.removeAnnotation(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void removeAnnotationFromEnumConstantOutline(JCodeModel codeModel, Outline outline, EnumConstantOutline enumConstantOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM_CONSTANT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(outline, enumConstantOutline);
                this.removeAnnotation(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void removeAnnotationFromClassOutline(JCodeModel codeModel, ClassOutline classOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.CLASS);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(classOutline.parent(), classOutline);
                this.removeAnnotation(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void removeAnnotationFromFieldOutline(JCodeModel codeModel, FieldOutline fieldOutline, CCustomizations customizations, ErrorHandler errorHandler) {
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.getAnnotationTarget(this.getDefaultFieldTarget()));
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(fieldOutline.parent().parent(), fieldOutline);
                this.removeAnnotation(codeModel, errorHandler, customization, element, annotatable);
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error removing the annotation.", (Throwable)iaex);
            }
        }
    }

    private void removeAnnotation(JCodeModel codeModel, ErrorHandler errorHandler, CPluginCustomization customization, Element element, JAnnotatable annotatable) {
        String aClass = element.getAttribute(CLASS_ATTRIBUTE_NAME);
        if (StringUtils.isBlank((CharSequence)aClass)) {
            try {
                errorHandler.error(new SAXParseException("Could not remove the annotation, annotation class is not specified. Annotation class must be specified using the class attribute of the customization element.", customization.locator));
            }
            catch (SAXException sAXException) {}
        } else {
            JClass annotationClass = codeModel.ref(aClass);
            JAnnotationUse annotationUse = null;
            for (JAnnotationUse annotation : annotatable.annotations()) {
                if (!annotationClass.equals(annotation.getAnnotationClass())) continue;
                annotationUse = annotation;
            }
            if (annotationUse == null) {
                try {
                    errorHandler.warning(new SAXParseException(MessageFormat.format("Could not remove the annotation, target element is not annotated with annotation class [{0}].", annotationClass), customization.locator));
                }
                catch (SAXException sAXException) {}
            } else {
                annotatable.removeAnnotation(annotationUse);
            }
        }
    }

    private boolean isCustomizationElementName(QName name) {
        return CUSTOMIZATION_ELEMENT_QNAMES.contains(name);
    }

    public Collection<QName> getCustomizationElementNames() {
        return CUSTOMIZATION_ELEMENT_QNAMES;
    }
}

