/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hyperjaxb_annox.plugin.annotate;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.model.CCustomizations;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CPluginCustomization;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.ElementOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.util.CustomizationUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb_annox.model.XAnnotation;
import org.jvnet.basicjaxb_annox.parser.XAnnotationParser;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationElementParseException;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationExpressionParseException;
import org.jvnet.basicjaxb_annox.parser.exception.AnnotationStringParseException;
import org.jvnet.hyperjaxb_annox.plugin.AnnotationTarget;
import org.jvnet.hyperjaxb_annox.plugin.annotate.Annotator;
import org.jvnet.hyperjaxb_annox.plugin.removeannotation.RemoveAnnotationPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class AnnotatePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "Xannotate";
    private static final String OPTION_DESC = "add arbitrary annotations to generated sources";
    public static final QName ANNOTATE_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotate");
    public static final QName ANNOTATE_PROPERTY_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateProperty");
    public static final QName ANNOTATE_PROPERTY_GETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotatePropertyGetter");
    public static final QName ANNOTATE_PROPERTY_SETTER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotatePropertySetter");
    public static final QName ANNOTATE_PROPERTY_FIELD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotatePropertyField");
    public static final QName ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotatePropertySetterParameter");
    public static final QName ANNOTATE_PACKAGE_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotatePackage");
    public static final QName ANNOTATE_CLASS_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateClass");
    public static final QName ANNOTATE_ELEMENT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateElement");
    public static final QName ANNOTATE_ENUM_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateEnum");
    public static final QName ANNOTATE_ENUM_CONSTANT_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateEnumConstant");
    public static final QName ANNOTATE_ENUM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateEnumValueMethod");
    public static final QName ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME = new QName("http://jvnet.org/basicjaxb/xjc/annox", "annotateEnumFromValueMethod");
    public static final Set<QName> CUSTOMIZATION_ELEMENT_QNAMES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(ANNOTATE_QNAME, ANNOTATE_PACKAGE_QNAME, ANNOTATE_CLASS_QNAME, ANNOTATE_ELEMENT_QNAME, ANNOTATE_PROPERTY_QNAME, ANNOTATE_PROPERTY_FIELD_QNAME, ANNOTATE_PROPERTY_GETTER_QNAME, ANNOTATE_PROPERTY_SETTER_QNAME, ANNOTATE_PROPERTY_SETTER_PARAMETER_QNAME, ANNOTATE_ENUM_QNAME, ANNOTATE_ENUM_CONSTANT_QNAME, ANNOTATE_ENUM_VALUE_METHOD_QNAME, ANNOTATE_ENUM_FROM_VALUE_METHOD_QNAME)));
    private String defaultFieldTarget = "getter";
    private XAnnotationParser annotationParser = XAnnotationParser.INSTANCE;
    private Annotator annotator = new Annotator();

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Collection<QName> getCustomizationElementNames() {
        return CUSTOMIZATION_ELEMENT_QNAMES;
    }

    private boolean isCustomizationElementName(QName name) {
        return name != null && "http://jvnet.org/basicjaxb/xjc/annox".equals(name.getNamespaceURI()) && !RemoveAnnotationPlugin.CUSTOMIZATION_ELEMENT_QNAMES.contains(name);
    }

    public String getDefaultFieldTarget() {
        return this.defaultFieldTarget;
    }

    public void setDefaultFieldTarget(String defaultFieldTarget) {
        if (!("getter".equals(defaultFieldTarget) || "setter".equals(defaultFieldTarget) || "setter-parameter".equals(defaultFieldTarget) || "field".equals(defaultFieldTarget))) {
            throw new IllegalArgumentException("Invalid default field target.");
        }
        this.defaultFieldTarget = defaultFieldTarget;
    }

    public XAnnotationParser getAnnotationParser() {
        return this.annotationParser;
    }

    public void setAnnotationParser(XAnnotationParser annotationParser) {
        this.annotationParser = annotationParser;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public void setAnnotator(Annotator annotator) {
        this.annotator = annotator;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  DefaultFieldTarget.: " + this.getDefaultFieldTarget());
            sb.append("\n  AnnotationParser...: " + this.getAnnotationParser());
            sb.append("\n  Annotator..........: " + this.getAnnotator());
            sb.append("\n  Verbose............: " + this.isVerbose());
            sb.append("\n  Debug..............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (CElementInfo elementInfo : outline.getModel().getAllElements()) {
            ElementOutline elementOutline = outline.getElement(elementInfo);
            if (elementOutline == null) continue;
            this.processElementOutline(elementOutline);
        }
        for (ClassOutline classOutline : outline.getClasses()) {
            this.processClassOutline(classOutline);
        }
        for (EnumOutline enumOutline : outline.getEnums()) {
            this.processEnumOutline(enumOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processElementOutline(ElementOutline elementOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ElementOutline)elementOutline);
        this.annotateElementOutline(elementOutline, customizations);
    }

    protected void annotateElementOutline(ElementOutline elementOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theElementClass = elementOutline.implClass;
        JCodeModel theElementOwner = theElementClass.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ELEMENT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(elementOutline.parent(), elementOutline);
                if (!this.annotate(theElementOwner, customization, element, annotatable)) continue;
                this.debug("{}, annotateElementOutline; Class={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (ElementOutline)elementOutline), theElementClass.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processClassOutline(ClassOutline classOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((ClassOutline)classOutline);
        this.annotateClassOutline(classOutline, customizations);
        for (FieldOutline fieldOutline : classOutline.getDeclaredFields()) {
            this.processFieldOutline(classOutline, fieldOutline);
        }
    }

    protected void annotateClassOutline(ClassOutline classOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theClassRef = classOutline.ref;
        JCodeModel theClassRefOwner = theClassRef.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.CLASS);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(classOutline.parent(), classOutline);
                if (!this.annotate(theClassRefOwner, customization, element, annotatable)) continue;
                this.debug("{}, annotateClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (ClassOutline)classOutline), theClassRef.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processFieldOutline(ClassOutline classOutline, FieldOutline fieldOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((FieldOutline)fieldOutline);
        this.annotateFieldOutline(fieldOutline, customizations);
    }

    protected void annotateFieldOutline(FieldOutline fieldOutline, CCustomizations customizations) throws SAXParseException {
        CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
        JDefinedClass fieldParentRef = fieldOutline.parent().ref;
        JCodeModel fieldParentRefOwner = fieldParentRef.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.getAnnotationTarget(this.getDefaultFieldTarget()));
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(fieldOutline.parent().parent(), fieldOutline);
                if (!this.annotate(fieldParentRefOwner, customization, element, annotatable)) continue;
                this.trace("{}, annotateFieldOutline; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (FieldOutline)fieldOutline), fieldParentRef.name(), fieldInfo.getName(false)});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processEnumOutline(EnumOutline enumOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumOutline)enumOutline);
        this.annotateEnumOutline(enumOutline, customizations);
        for (EnumConstantOutline enumConstantOutline : enumOutline.constants) {
            this.processEnumConstantOutline(enumOutline, enumConstantOutline);
        }
    }

    protected void annotateEnumOutline(EnumOutline enumOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass theEnumClass = enumOutline.clazz;
        JCodeModel theEnumClassOwner = theEnumClass.owner();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutline.parent(), enumOutline);
                if (!this.annotate(theEnumClassOwner, customization, element, annotatable)) continue;
                this.debug("{}, annotateEnumOutline; Enum={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (EnumOutline)enumOutline), theEnumClass.name()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    protected void processEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline) throws SAXParseException {
        CCustomizations customizations = CustomizationUtils.getCustomizations((EnumConstantOutline)enumConstantOutline);
        this.annotateEnumConstantOutline(enumOutline, enumConstantOutline, customizations);
    }

    protected void annotateEnumConstantOutline(EnumOutline enumOutline, EnumConstantOutline enumConstantOutline, CCustomizations customizations) throws SAXParseException {
        JDefinedClass enumClass = enumOutline.clazz;
        Outline enumOutlineParent = enumOutline.parent();
        JCodeModel enumOutlineParentOwner = enumOutlineParent.getCodeModel();
        for (CPluginCustomization customization : customizations) {
            Element element = customization.element;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (!this.isCustomizationElementName(name)) continue;
            customization.markAsAcknowledged();
            AnnotationTarget annotationTarget = AnnotationTarget.getAnnotationTarget(element, AnnotationTarget.ENUM_CONSTANT);
            try {
                JAnnotatable annotatable = annotationTarget.getAnnotatable(enumOutlineParent, enumConstantOutline);
                if (!this.annotate(enumOutlineParentOwner, customization, element, annotatable)) continue;
                this.trace("{}, annotateEnumConstantOutline; Class={}, EnumConstant={}", new Object[]{LocatorUtils.toLocation((CPluginCustomization)customization, (EnumOutline)enumOutline), enumClass.name(), enumConstantOutline.constRef.getName()});
            }
            catch (IllegalArgumentException iaex) {
                this.getLogger().error("Error applying the annotation.", (Throwable)iaex);
            }
        }
    }

    private boolean annotate(JCodeModel codeModel, CPluginCustomization customization, Element element, JAnnotatable annotatable) throws SAXParseException {
        boolean annotated = false;
        try {
            NodeList elements = element.getChildNodes();
            for (int index = 0; index < elements.getLength(); ++index) {
                String nodeValue;
                XAnnotation annotation;
                Node node = elements.item(index);
                if (node.getNodeType() == 1) {
                    Element child = (Element)node;
                    annotation = this.getAnnotationParser().parse(child);
                    this.getAnnotator().annotate(codeModel, annotatable, annotation);
                    annotated = true;
                    continue;
                }
                if (node.getNodeType() != 3 || !StringUtils.isNotBlank((CharSequence)(nodeValue = node.getNodeValue()))) continue;
                annotation = this.getAnnotationParser().parse(nodeValue);
                this.getAnnotator().annotate(codeModel, annotatable, annotation);
                annotated = true;
            }
        }
        catch (AnnotationElementParseException | AnnotationExpressionParseException | AnnotationStringParseException ex) {
            throw new SAXParseException("Cannot annotate " + annotatable, customization.locator, (Exception)ex);
        }
        return annotated;
    }
}

